/*
 * Decompiled with CFR 0.152.
 */
package zio;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Chunk$;
import zio.Dequeue;
import zio.Enqueue;
import zio.Exit$;
import zio.FiberId;
import zio.Promise;
import zio.Promise$unsafe$;
import zio.Queue$;
import zio.Queue$Strategy$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.internal.MutableConcurrentQueue;

public abstract class Queue<A>
extends Dequeue.Internal<A>
implements Enqueue.Internal<A> {
    public static <A> ZIO<Object, Nothing$, Queue<A>> bounded(Function0<Object> function0, Object object) {
        return Queue$.MODULE$.bounded(function0, object);
    }

    public static <A> ZIO<Object, Nothing$, Queue<A>> dropping(Function0<Object> function0, Object object) {
        return Queue$.MODULE$.dropping(function0, object);
    }

    public static <A> ZIO<Object, Nothing$, Queue<A>> sliding(Function0<Object> function0, Object object) {
        return Queue$.MODULE$.sliding(function0, object);
    }

    public static <A> ZIO<Object, Nothing$, Queue<A>> unbounded(Object object) {
        return Queue$.MODULE$.unbounded(object);
    }

    @Override
    public final ZIO<Object, Nothing$, Object> isEmpty(Object trace) {
        return this.size(trace).map((JFunction1.mcZI.sp & Serializable)_$1 -> _$1 <= 0, trace);
    }

    @Override
    public final ZIO<Object, Nothing$, Object> isFull(Object trace) {
        return this.size(trace).map((JFunction1.mcZI.sp & Serializable)_$2 -> _$2 >= this.capacity(), trace);
    }

    public static abstract class Internal<A>
    extends Queue<A> {
    }

    public static final class QueueImpl<A>
    extends Queue<A> {
        private final MutableConcurrentQueue<A> queue;
        private final ConcurrentLinkedDeque<Promise<Nothing$, A>> takers;
        private final Promise<Nothing$, BoxedUnit> shutdownHook;
        private final AtomicBoolean shutdownFlag;
        private final Strategy<A> strategy;

        public QueueImpl(MutableConcurrentQueue<A> queue, ConcurrentLinkedDeque<Promise<Nothing$, A>> takers, Promise<Nothing$, BoxedUnit> shutdownHook, AtomicBoolean shutdownFlag, Strategy<A> strategy) {
            this.queue = queue;
            this.takers = takers;
            this.shutdownHook = shutdownHook;
            this.shutdownFlag = shutdownFlag;
            this.strategy = strategy;
        }

        @Override
        public int capacity() {
            return this.queue.capacity();
        }

        @Override
        public ZIO<Object, Nothing$, Object> offer(A a, Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.offer$$anonfun$1(trace, a), trace);
        }

        private boolean tryOffer(A a) {
            boolean noRemaining;
            boolean bl = noRemaining = this.queue.isEmpty() ? this.offeredToTaker$1(a) : false;
            if (noRemaining) {
                return true;
            }
            if (this.queue.offer(a)) {
                this.strategy.unsafeCompleteTakers(this.queue, this.takers);
                return true;
            }
            return false;
        }

        @Override
        public <A1 extends A> ZIO<Object, Nothing$, Chunk<A1>> offerAll(Iterable<A1> as, Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.offerAll$$anonfun$1(trace, as), trace);
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> awaitShutdown(Object trace) {
            return this.shutdownHook.await(trace);
        }

        @Override
        public ZIO<Object, Nothing$, Object> size(Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.size$$anonfun$1(trace), trace);
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> shutdown(Object trace) {
            return ZIO$.MODULE$.fiberIdWith((Function1 & Serializable)fiberId -> {
                if (this.shutdownFlag.compareAndSet(false, true)) {
                    Unsafe$ unsafe2 = Unsafe$.MODULE$;
                    this.shutdownHook.unsafe().succeedUnit($less$colon$less$.MODULE$.refl(), trace, unsafe2);
                    Iterator it = Queue$.MODULE$.zio$Queue$$$unsafePollAll(this.takers).iterator();
                    while (it.hasNext()) {
                        ((Promise)it.next()).unsafe().interruptAs((FiberId)fiberId, trace, unsafe2);
                    }
                    this.strategy.shutdown((FiberId)fiberId, trace, unsafe2);
                }
                return Exit$.MODULE$.unit();
            }, trace).uninterruptible(trace);
        }

        @Override
        public ZIO<Object, Nothing$, Object> isShutdown(Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return this.shutdownFlag.get();
            });
        }

        @Override
        public ZIO<Object, Nothing$, A> take(Object trace) {
            return ZIO$.MODULE$.uninterruptibleMask((Function1 & Serializable)restore -> ZIO$.MODULE$.fiberIdWith((Function1 & Serializable)fiberId -> {
                if (this.shutdownFlag.get()) {
                    return ZIO$.MODULE$.interrupt(trace);
                }
                Object a = this.queue.poll(null);
                if (a == null) {
                    Promise p = Promise$unsafe$.MODULE$.make((FiberId)fiberId, Unsafe$.MODULE$);
                    this.takers.offer(p);
                    this.strategy.unsafeCompleteTakers(this.queue, this.takers);
                    return restore.apply(() -> Queue$.zio$Queue$QueueImpl$$_$take$$anonfun$1$$anonfun$1$$anonfun$1(p, trace), trace).catchAllCause((Function1 & Serializable)c -> {
                        boolean removed = p.unsafe().completeWith(Queue$.zio$Queue$$$interruptAsNone, Unsafe$.MODULE$);
                        this.takers.remove(p);
                        if (removed) {
                            return Exit$.MODULE$.failCause(c);
                        }
                        return p.await(trace);
                    }, trace);
                }
                Object item = a;
                this.strategy.unsafeOnQueueEmptySpace(this.queue, this.takers);
                return Exit$.MODULE$.succeed(item);
            }, trace), trace);
        }

        @Override
        public ZIO<Object, Nothing$, Chunk<A>> takeAll(Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.takeAll$$anonfun$1(trace), trace);
        }

        @Override
        public ZIO<Object, Nothing$, Chunk<A>> takeUpTo(int max, Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.takeUpTo$$anonfun$1(trace, max), trace);
        }

        @Override
        public ZIO<Object, Nothing$, Option<A>> poll(Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.poll$$anonfun$1(trace), trace);
        }

        private final ZIO offer$$anonfun$1(Object trace$1, Object a$1) {
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$1);
            }
            if (this.tryOffer(a$1)) {
                return Exit$.MODULE$.true();
            }
            return this.strategy.handleSurplus((Iterable<Object>)Chunk$.MODULE$.single(a$1), (MutableConcurrentQueue<Object>)this.queue, (ConcurrentLinkedDeque<Promise<Nothing$, Object>>)this.takers, this.shutdownFlag, trace$1);
        }

        private final boolean offeredToTaker$1(Object a$2) {
            Promise<Nothing$, A> taker;
            do {
                if ((taker = this.takers.poll()) != null) continue;
                return false;
            } while (!Queue$.MODULE$.zio$Queue$$$unsafeCompletePromise(taker, a$2));
            return true;
        }

        private final ZIO offerAll$$anonfun$1(Object trace$2, Iterable as$1) {
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$2);
            }
            Chunk<Promise<Nothing$, A>> pTakers = this.queue.isEmpty() ? Queue$.MODULE$.zio$Queue$$$unsafePollN(this.takers, as$1.size()) : Chunk$.MODULE$.empty();
            Tuple2 tuple2 = as$1.splitAt(pTakers.size());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Iterable forTakers = (Iterable)tuple2._1();
            Iterable remaining = (Iterable)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)forTakers, (Object)remaining);
            Iterable forTakers2 = (Iterable)tuple22._1();
            Iterable remaining2 = (Iterable)tuple22._2();
            ((IterableOnceOps)pTakers.zip((IterableOnce)forTakers2)).foreach(Queue$::zio$Queue$QueueImpl$$_$offerAll$$anonfun$1$$anonfun$1);
            if (remaining2.isEmpty()) {
                return Exit$.MODULE$.emptyChunk();
            }
            Chunk surplus = Queue$.MODULE$.zio$Queue$$$unsafeOfferAll(this.queue, remaining2);
            if (surplus.isEmpty()) {
                this.strategy.unsafeCompleteTakers(this.queue, this.takers);
                return Exit$.MODULE$.emptyChunk();
            }
            return this.strategy.handleSurplus(surplus, this.queue, this.takers, this.shutdownFlag, trace$2).map(arg_0 -> Queue$.zio$Queue$QueueImpl$$_$offerAll$$anonfun$1$$anonfun$adapted$1(surplus, arg_0), trace$2);
        }

        private final ZIO size$$anonfun$1(Object trace$3) {
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$3);
            }
            return Exit$.MODULE$.succeed(BoxesRunTime.boxToInteger((int)(this.queue.size() - this.takers.size() + this.strategy.surplusSize())));
        }

        private final ZIO takeAll$$anonfun$1(Object trace$9) {
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$9);
            }
            Chunk<A> as = Queue$.MODULE$.zio$Queue$$$unsafePollAll(this.queue);
            if (!as.isEmpty()) {
                this.strategy.unsafeOnQueueEmptySpace(this.queue, this.takers);
                return Exit$.MODULE$.succeed(as);
            }
            return Exit$.MODULE$.emptyChunk();
        }

        private final ZIO takeUpTo$$anonfun$1(Object trace$10, int max$1) {
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$10);
            }
            Chunk<A> as = Queue$.MODULE$.zio$Queue$$$unsafePollN(this.queue, max$1);
            if (!as.isEmpty()) {
                this.strategy.unsafeOnQueueEmptySpace(this.queue, this.takers);
                return Exit$.MODULE$.succeed(as);
            }
            return Exit$.MODULE$.emptyChunk();
        }

        private final ZIO poll$$anonfun$1(Object trace$11) {
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$11);
            }
            Object var2_2 = this.queue.poll(null);
            if (var2_2 == null) {
                return Exit$.MODULE$.none();
            }
            Object v = var2_2;
            this.strategy.unsafeOnQueueEmptySpace(this.queue, this.takers);
            return Exit$.MODULE$.succeed(Some$.MODULE$.apply(v));
        }
    }

    public static abstract class Strategy<A> {
        private final AtomicBoolean draining = new AtomicBoolean(false);

        public static int ordinal(Strategy<?> strategy) {
            return Queue$Strategy$.MODULE$.ordinal(strategy);
        }

        public abstract ZIO<Object, Nothing$, Object> handleSurplus(Iterable<A> var1, MutableConcurrentQueue<A> var2, ConcurrentLinkedDeque<Promise<Nothing$, A>> var3, AtomicBoolean var4, Object var5);

        public abstract void unsafeOnQueueEmptySpace(MutableConcurrentQueue<A> var1, ConcurrentLinkedDeque<Promise<Nothing$, A>> var2);

        public abstract int surplusSize();

        public abstract void shutdown(FiberId var1, Object var2, Unsafe var3);

        public final void unsafeCompleteTakers(MutableConcurrentQueue<A> queue, ConcurrentLinkedDeque<Promise<Nothing$, A>> takers) {
            while (!takers.isEmpty() && this.draining.compareAndSet(false, true)) {
                try {
                    boolean keepPolling = !queue.isEmpty();
                    Object empty = null;
                    boolean notifyEmptySpace = false;
                    Object currentItem = empty;
                    while (keepPolling) {
                        Object a;
                        Promise<Nothing$, A> taker = takers.poll();
                        if (taker == null) {
                            keepPolling = false;
                            if (currentItem == null) continue;
                            queue.offer(currentItem);
                            continue;
                        }
                        if (taker.unsafe().isDone(Unsafe$.MODULE$)) continue;
                        if (currentItem == null) {
                            currentItem = queue.poll(empty);
                        }
                        if ((a = currentItem) == null) {
                            takers.addFirst(taker);
                            keepPolling = false;
                            continue;
                        }
                        Object a2 = a;
                        if (Queue$.MODULE$.zio$Queue$$$unsafeCompletePromise(taker, a2)) {
                            notifyEmptySpace = true;
                            currentItem = empty;
                            continue;
                        }
                        currentItem = a2;
                    }
                    if (notifyEmptySpace) {
                        this.unsafeOnQueueEmptySpace(queue, takers);
                    }
                }
                finally {
                    this.draining.set(false);
                }
                if (!queue.isEmpty()) continue;
                return;
            }
        }
    }
}

