/*
 * Decompiled with CFR 0.152.
 */
package zio.metrics;

import java.io.IOException;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Console$;
import zio.System$;
import zio.ZIO;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricLabel;
import zio.metrics.MetricPair;
import zio.metrics.MetricState;
import zio.metrics.MetricState$Counter$;
import zio.metrics.MetricState$Frequency$;
import zio.metrics.MetricState$Gauge$;
import zio.metrics.MetricState$Histogram$;
import zio.metrics.MetricState$Summary$;
import zio.metrics.Metrics$;

public final class Metrics
implements Product,
Serializable {
    private final Set metrics;

    public static Metrics apply(Set<MetricPair<MetricKeyType, Object>> set) {
        return Metrics$.MODULE$.apply(set);
    }

    public static Metrics fromProduct(Product product) {
        return Metrics$.MODULE$.fromProduct(product);
    }

    public static Metrics unapply(Metrics metrics) {
        return Metrics$.MODULE$.unapply(metrics);
    }

    public Metrics(Set<MetricPair<MetricKeyType, Object>> metrics) {
        this.metrics = metrics;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Metrics)) return false;
        Metrics metrics = (Metrics)object;
        Set<MetricPair<MetricKeyType, Object>> set = this.metrics();
        Set<MetricPair<MetricKeyType, Object>> set2 = metrics.metrics();
        if (set != null) {
            if (!set.equals(set2)) return false;
            return true;
        }
        if (set2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Metrics;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Metrics";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "metrics";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Set<MetricPair<MetricKeyType, Object>> metrics() {
        return this.metrics;
    }

    public ZIO<Object, Nothing$, String> prettyPrint(Object trace) {
        return System$.MODULE$.lineSeparator(trace).map((Function1 & Serializable)_$1 -> this.renderMetrics(this.metrics(), (String)_$1), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> dump(Object trace) {
        return this.prettyPrint(trace).flatMap((Function1 & Serializable)_$2 -> Console$.MODULE$.printLine((Function0<Object>)((Function0 & Serializable)() -> Metrics.dump$$anonfun$1$$anonfun$1(_$2)), trace), trace);
    }

    private String renderMetrics(Set<MetricPair<MetricKeyType, Object>> metrics, String lineSeparator) {
        if (metrics.nonEmpty()) {
            int maxNameLength = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)metrics.map((Function1 & Serializable)m -> m.metricKey().name().length() + BoxesRunTime.unboxToInt((Object)m.metricKey().description().map((Function1 & Serializable)_$3 -> _$3.length() + 2).getOrElse(Metrics::$anonfun$1$$anonfun$2)))).max((Ordering)Ordering.Int$.MODULE$)) + 2;
            int maxTagSectionLength = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)metrics.map((Function1 & Serializable)m -> this.tagsToString(m.metricKey().tags()).length())).max((Ordering)Ordering.Int$.MODULE$)) + 2;
            return ((List)metrics.groupBy((Function1 & Serializable)_$4 -> _$4.metricKey().name()).toList().sortBy((Function1 & Serializable)_$5 -> (String)_$5._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Set groupedMetrics = (Set)tuple2._2();
                    return ((IterableOnceOps)groupedMetrics.map((Function1 & Serializable)metric -> new StringBuilder(0).append(this.renderKey(metric.metricKey(), maxNameLength)).append(this.renderTags(metric.metricKey(), maxTagSectionLength)).append(this.renderValue((MetricPair<?, ?>)metric)).toString())).mkString(lineSeparator);
                }
                throw new MatchError((Object)tuple2);
            }).mkString(lineSeparator);
        }
        return "";
    }

    private String renderKey(MetricKey<?> key, int padTo) {
        return StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(new StringBuilder(0).append(key.name()).append(key.description().map((Function1 & Serializable)d -> new StringBuilder(2).append("(").append((String)d).append(")").toString()).getOrElse(Metrics::renderKey$$anonfun$2)).toString()), padTo, ' ');
    }

    private String renderTags(MetricKey<?> key, int padTo) {
        String tagsStr = this.tagsToString(key.tags());
        return new StringBuilder(0).append(tagsStr).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), package$.MODULE$.max(0, padTo - tagsStr.length()))).toString();
    }

    private String renderValue(MetricPair<?, ?> metric) {
        MetricState<?> metricState = metric.metricState();
        if (metricState instanceof MetricState.Counter) {
            double d;
            MetricState.Counter counter = MetricState$Counter$.MODULE$.unapply((MetricState.Counter)metricState);
            double count = d = counter._1();
            return new StringBuilder(9).append("Counter[").append(count).append("]").toString();
        }
        if (metricState instanceof MetricState.Frequency) {
            Map<String, Object> map;
            MetricState.Frequency frequency = MetricState$Frequency$.MODULE$.unapply((MetricState.Frequency)metricState);
            Map<String, Object> occurrences = map = frequency._1();
            return new StringBuilder(11).append("Frequency[").append(Metrics.renderKeyValues$1(occurrences)).append("]").toString();
        }
        if (metricState instanceof MetricState.Gauge) {
            double d;
            MetricState.Gauge gauge = MetricState$Gauge$.MODULE$.unapply((MetricState.Gauge)metricState);
            double value = d = gauge._1();
            return new StringBuilder(7).append("Gauge[").append(value).append("]").toString();
        }
        if (metricState instanceof MetricState.Histogram) {
            MetricState.Histogram histogram = MetricState$Histogram$.MODULE$.unapply((MetricState.Histogram)metricState);
            Chunk<Tuple2<Object, Object>> chunk = histogram._1();
            long l = histogram._2();
            double d = histogram._3();
            double d2 = histogram._4();
            double d3 = histogram._5();
            Chunk<Tuple2<Object, Object>> buckets = chunk;
            long count = l;
            double min = d;
            double max = d2;
            double sum = d3;
            return new StringBuilder(60).append("Histogram[buckets: [").append(Metrics.renderKeyValues$1(buckets)).append("], count: [").append(count).append("], min: [").append(min).append("], max: [").append(max).append("], sum: [").append(sum).append("]]").toString();
        }
        if (metricState instanceof MetricState.Summary) {
            MetricState.Summary summary = MetricState$Summary$.MODULE$.unapply((MetricState.Summary)metricState);
            double d = summary._1();
            Chunk<Tuple2<Object, Option<Object>>> chunk = summary._2();
            long l = summary._3();
            double d4 = summary._4();
            double d5 = summary._5();
            double d6 = summary._6();
            Chunk<Tuple2<Object, Option<Object>>> quantiles = chunk;
            long count = l;
            double min = d4;
            double max = d5;
            double sum = d6;
            return new StringBuilder(60).append("Summary[quantiles: [").append(Metrics.renderKeyValues$1(quantiles)).append("], count: [").append(count).append("], min: [").append(min).append("], max: [").append(max).append("], sum: [").append(sum).append("]]").toString();
        }
        throw new MatchError(metricState);
    }

    private String tagsToString(Set<MetricLabel> tags) {
        List byName = (List)tags.toList().sortBy((Function1 & Serializable)_$6 -> _$6.key(), (Ordering)Ordering.String$.MODULE$);
        return new StringBuilder(6).append("tags[").append(byName.map((Function1 & Serializable)l -> new StringBuilder(2).append(l.key()).append(": ").append(l.value()).toString()).mkString(", ")).append("]").toString();
    }

    public Metrics copy(Set<MetricPair<MetricKeyType, Object>> metrics) {
        return new Metrics(metrics);
    }

    public Set<MetricPair<MetricKeyType, Object>> copy$default$1() {
        return this.metrics();
    }

    public Set<MetricPair<MetricKeyType, Object>> _1() {
        return this.metrics();
    }

    private static final Object dump$$anonfun$1$$anonfun$1(String _$2$1) {
        return _$2$1;
    }

    private static final int $anonfun$1$$anonfun$2() {
        return 0;
    }

    private static final String renderKey$$anonfun$2() {
        return "";
    }

    private static final String renderKeyValues$1(Iterable keyValues) {
        return ((IterableOnceOps)keyValues.map((Function1 & Serializable)p -> new StringBuilder(6).append("(").append(p._1()).append(" -> ").append(p._2()).append(")").toString())).mkString(", ");
    }
}

