/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Unsafe;
import zio.internal.metrics.ConcurrentMetricHooks$;
import zio.internal.metrics.MetricEventType;
import zio.internal.metrics.MetricEventType$Modify$;
import zio.internal.metrics.MetricEventType$Update$;
import zio.internal.metrics.MetricHook;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricKeyType$Frequency$;
import zio.metrics.MetricKeyType$Gauge$;
import zio.metrics.MetricKeyType$Histogram$;
import zio.metrics.MetricKeyType$Summary$;
import zio.metrics.MetricListener;
import zio.metrics.MetricPair;
import zio.metrics.MetricPair$;
import zio.metrics.MetricState;

public class ConcurrentMetricRegistry {
    private final AtomicReference<MetricListener[]> listenersRef = new AtomicReference<Object>(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(MetricListener.class)));
    private final ConcurrentHashMap<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> map = new ConcurrentHashMap();

    public scala.collection.immutable.Set<MetricPair<MetricKeyType, Object>> snapshot(Unsafe unsafe) {
        Iterator<Map.Entry<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>>> iterator = this.map.entrySet().iterator();
        Set result = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricPair[0]));
        while (iterator.hasNext()) {
            Map.Entry<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> value = iterator.next();
            MetricKey<MetricKeyType> key = value.getKey();
            MetricHook<?, MetricState<Object>> hook = value.getValue();
            result.add(MetricPair$.MODULE$.make(key, (MetricState)hook.get().apply(), unsafe));
        }
        return result.toSet();
    }

    public <Type extends MetricKeyType> MetricHook<Object, Object> get(MetricKey<Type> key, Unsafe unsafe) {
        MetricHook<Object, Object> hook0 = this.map.get(key);
        if (hook0 == null) {
            MetricKeyType metricKeyType = (MetricKeyType)key.keyType();
            if (MetricKeyType$Counter$.MODULE$.equals(metricKeyType)) {
                return this.getCounter(key, unsafe);
            }
            if (MetricKeyType$Frequency$.MODULE$.equals(metricKeyType)) {
                return this.getSetCount(key, unsafe);
            }
            if (MetricKeyType$Gauge$.MODULE$.equals(metricKeyType)) {
                return this.getGauge(key, unsafe);
            }
            if (metricKeyType instanceof MetricKeyType.Histogram) {
                MetricKeyType.Histogram histogram = MetricKeyType$Histogram$.MODULE$.unapply((MetricKeyType.Histogram)metricKeyType);
                MetricKeyType.Histogram.Boundaries boundaries = histogram._1();
                return this.getHistogram(key, unsafe);
            }
            if (metricKeyType instanceof MetricKeyType.Summary) {
                MetricKeyType.Summary summary = MetricKeyType$Summary$.MODULE$.unapply((MetricKeyType.Summary)metricKeyType);
                Duration duration = summary._1();
                int n = summary._2();
                double d = summary._3();
                Chunk<Object> chunk = summary._4();
                return this.getSummary(key, unsafe);
            }
            throw new MatchError((Object)metricKeyType);
        }
        return hook0;
    }

    public <Type extends MetricKeyType> boolean remove(MetricKey<Type> key, Unsafe unsafe) {
        return this.map.remove(key) != null;
    }

    public final void addListener(MetricListener listener, Unsafe unsafe) {
        Object object;
        MetricListener[] newListeners;
        Object[] oldListeners;
        while (!this.listenersRef.compareAndSet((MetricListener[])(oldListeners = this.listenersRef.get()), newListeners = (MetricListener[])ArrayOps$.MODULE$.$colon$plus$extension(object = Predef$.MODULE$.refArrayOps(oldListeners), (Object)listener, ClassTag$.MODULE$.apply(MetricListener.class)))) {
        }
    }

    public final void removeListener(MetricListener listener, Unsafe unsafe) {
        Object object;
        MetricListener[] newListeners;
        Object[] oldListeners;
        while (!this.listenersRef.compareAndSet((MetricListener[])(oldListeners = this.listenersRef.get()), newListeners = (MetricListener[])ArrayOps$.MODULE$.filter$extension(object = Predef$.MODULE$.refArrayOps(oldListeners), (Function1 & Serializable)_$1 -> _$1 != listener))) {
        }
    }

    public <T> void notifyListeners(MetricKey<MetricKeyType> key, T value, MetricEventType eventType, Object trace, Unsafe unsafe) {
        MetricListener[] listeners = this.listenersRef.get();
        int len = listeners.length;
        if (len > 0) {
            int i;
            MetricKeyType metricKeyType = key.keyType();
            if (MetricKeyType$Gauge$.MODULE$.equals(metricKeyType)) {
                MetricEventType metricEventType = eventType;
                if (MetricEventType$Modify$.MODULE$.equals(metricEventType)) {
                    for (i = 0; i < len; ++i) {
                        listeners[i].modifyGauge(key, BoxesRunTime.unboxToDouble(value), unsafe);
                    }
                    return;
                }
                if (MetricEventType$Update$.MODULE$.equals(metricEventType)) {
                    while (i < len) {
                        listeners[i].updateGauge(key, BoxesRunTime.unboxToDouble(value), unsafe);
                        ++i;
                    }
                    return;
                }
                throw new MatchError((Object)metricEventType);
            }
            if (metricKeyType instanceof MetricKeyType.Histogram) {
                MetricKeyType.Histogram histogram = MetricKeyType$Histogram$.MODULE$.unapply((MetricKeyType.Histogram)metricKeyType);
                MetricKeyType.Histogram.Boundaries boundaries = histogram._1();
                while (i < len) {
                    listeners[i].updateHistogram(key, BoxesRunTime.unboxToDouble(value), unsafe);
                    ++i;
                }
                return;
            }
            if (MetricKeyType$Frequency$.MODULE$.equals(metricKeyType)) {
                while (i < len) {
                    listeners[i].updateFrequency(key, (String)value, unsafe);
                    ++i;
                }
                return;
            }
            if (metricKeyType instanceof MetricKeyType.Summary) {
                MetricKeyType.Summary summary = MetricKeyType$Summary$.MODULE$.unapply((MetricKeyType.Summary)metricKeyType);
                Duration duration = summary._1();
                int n = summary._2();
                double d = summary._3();
                Chunk<Object> chunk = summary._4();
                while (i < len) {
                    Tuple2 tuple2 = (Tuple2)value;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    double v = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                    Instant instant = (Instant)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)v), (Object)instant);
                    double v2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
                    Instant instant2 = (Instant)tuple22._2();
                    listeners[i].updateSummary(key, v2, instant2, unsafe);
                    ++i;
                }
                return;
            }
            if (MetricKeyType$Counter$.MODULE$.equals(metricKeyType)) {
                while (i < len) {
                    listeners[i].updateCounter(key, BoxesRunTime.unboxToDouble(value), unsafe);
                    ++i;
                }
                return;
            }
            throw new MatchError((Object)metricKeyType);
        }
    }

    private MetricHook<Object, MetricState.Counter> getCounter(MetricKey<MetricKeyType$Counter$> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map.get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Counter> counter = ConcurrentMetricHooks$.MODULE$.counter(key);
            this.map.putIfAbsent(key, counter);
            value = this.map.get(key);
        }
        return value;
    }

    private MetricHook<Object, MetricState.Gauge> getGauge(MetricKey<MetricKeyType$Gauge$> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map.get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Gauge> gauge = ConcurrentMetricHooks$.MODULE$.gauge(key, 0.0);
            this.map.putIfAbsent(key, gauge);
            value = this.map.get(key);
        }
        return value;
    }

    private MetricHook<Object, MetricState.Histogram> getHistogram(MetricKey<MetricKeyType.Histogram> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map.get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Histogram> histogram = ConcurrentMetricHooks$.MODULE$.histogram(key);
            this.map.putIfAbsent(key, histogram);
            value = this.map.get(key);
        }
        return value;
    }

    private MetricHook<Tuple2<Object, Instant>, MetricState.Summary> getSummary(MetricKey<MetricKeyType.Summary> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map.get(key);
        if (value == null) {
            MetricHook<Tuple2<Object, Instant>, MetricState.Summary> summary = ConcurrentMetricHooks$.MODULE$.summary(key);
            this.map.putIfAbsent(key, summary);
            value = this.map.get(key);
        }
        return value;
    }

    private MetricHook<String, MetricState.Frequency> getSetCount(MetricKey<MetricKeyType$Frequency$> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map.get(key);
        if (value == null) {
            MetricHook<String, MetricState.Frequency> frequency = ConcurrentMetricHooks$.MODULE$.frequency(key);
            this.map.putIfAbsent(key, frequency);
            value = this.map.get(key);
        }
        return value;
    }
}

