/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.math.package$;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.internal.Hub;

public final class BoundedHubArb<A>
extends Hub<A> {
    public final Object[] zio$internal$BoundedHubArb$$array;
    public long zio$internal$BoundedHubArb$$publisherIndex;
    public final int[] zio$internal$BoundedHubArb$$subscribers;
    public int zio$internal$BoundedHubArb$$subscriberCount;
    public long zio$internal$BoundedHubArb$$subscribersIndex;
    private final int capacity;

    public BoundedHubArb(int requestedCapacity) {
        this.zio$internal$BoundedHubArb$$array = new Object[requestedCapacity];
        this.zio$internal$BoundedHubArb$$publisherIndex = 0L;
        this.zio$internal$BoundedHubArb$$subscribers = new int[requestedCapacity];
        this.zio$internal$BoundedHubArb$$subscriberCount = 0;
        this.zio$internal$BoundedHubArb$$subscribersIndex = 0L;
        this.capacity = requestedCapacity;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean isEmpty() {
        return this.zio$internal$BoundedHubArb$$publisherIndex == this.zio$internal$BoundedHubArb$$subscribersIndex;
    }

    @Override
    public boolean isFull() {
        return this.zio$internal$BoundedHubArb$$publisherIndex == this.zio$internal$BoundedHubArb$$subscribersIndex + (long)this.capacity();
    }

    @Override
    public boolean publish(A a) {
        if (this.zio$internal$BoundedHubArb$$publisherIndex == this.zio$internal$BoundedHubArb$$subscribersIndex + (long)this.capacity()) {
            return false;
        }
        if (this.zio$internal$BoundedHubArb$$subscriberCount != 0) {
            int index = (int)(this.zio$internal$BoundedHubArb$$publisherIndex % (long)this.capacity());
            this.zio$internal$BoundedHubArb$$array[index] = a;
            this.zio$internal$BoundedHubArb$$subscribers[index] = this.zio$internal$BoundedHubArb$$subscriberCount;
            ++this.zio$internal$BoundedHubArb$$publisherIndex;
        }
        return true;
    }

    @Override
    public <A1 extends A> Chunk<A1> publishAll(Iterable<A1> as) {
        int n = as.size();
        int size = (int)(this.zio$internal$BoundedHubArb$$publisherIndex - this.zio$internal$BoundedHubArb$$subscribersIndex);
        int available = this.capacity() - size;
        int forHub = package$.MODULE$.min(n, available);
        if (forHub == 0) {
            return Chunk$.MODULE$.fromIterable(as);
        }
        Iterator iterator = as.iterator();
        long publishAllIndex = this.zio$internal$BoundedHubArb$$publisherIndex + (long)forHub;
        while (this.zio$internal$BoundedHubArb$$publisherIndex != publishAllIndex) {
            Object a = iterator.next();
            int index = (int)(this.zio$internal$BoundedHubArb$$publisherIndex % (long)this.capacity());
            this.zio$internal$BoundedHubArb$$array[index] = a;
            this.zio$internal$BoundedHubArb$$subscribers[index] = this.zio$internal$BoundedHubArb$$subscriberCount;
            ++this.zio$internal$BoundedHubArb$$publisherIndex;
        }
        return Chunk$.MODULE$.fromIterator(iterator);
    }

    @Override
    public int size() {
        return (int)(this.zio$internal$BoundedHubArb$$publisherIndex - this.zio$internal$BoundedHubArb$$subscribersIndex);
    }

    @Override
    public void slide() {
        if (this.zio$internal$BoundedHubArb$$subscribersIndex != this.zio$internal$BoundedHubArb$$publisherIndex) {
            int index = (int)(this.zio$internal$BoundedHubArb$$subscribersIndex % (long)this.capacity());
            this.zio$internal$BoundedHubArb$$array[index] = null;
            this.zio$internal$BoundedHubArb$$subscribers[index] = 0;
            ++this.zio$internal$BoundedHubArb$$subscribersIndex;
            return;
        }
    }

    @Override
    public Hub.Subscription<A> subscribe() {
        return new Hub.Subscription<A>(this){
            private long subscriberIndex;
            private boolean unsubscribed;
            private final /* synthetic */ BoundedHubArb $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.subscriberIndex = $outer.zio$internal$BoundedHubArb$$publisherIndex;
                this.unsubscribed = false;
                ++$outer.zio$internal$BoundedHubArb$$subscriberCount;
            }

            public boolean isEmpty() {
                return this.unsubscribed || this.$outer.zio$internal$BoundedHubArb$$publisherIndex == this.subscriberIndex || this.$outer.zio$internal$BoundedHubArb$$publisherIndex == this.$outer.zio$internal$BoundedHubArb$$subscribersIndex;
            }

            public Object poll(Object object) {
                if (this.unsubscribed) {
                    return object;
                }
                this.subscriberIndex = package$.MODULE$.max(this.subscriberIndex, this.$outer.zio$internal$BoundedHubArb$$subscribersIndex);
                if (this.subscriberIndex != this.$outer.zio$internal$BoundedHubArb$$publisherIndex) {
                    int index = (int)(this.subscriberIndex % (long)this.$outer.capacity());
                    Object a = this.$outer.zio$internal$BoundedHubArb$$array[index];
                    this.$outer.zio$internal$BoundedHubArb$$subscribers[index] = this.$outer.zio$internal$BoundedHubArb$$subscribers[index] - 1;
                    if (this.$outer.zio$internal$BoundedHubArb$$subscribers[index] == 0) {
                        this.$outer.zio$internal$BoundedHubArb$$array[index] = null;
                        ++this.$outer.zio$internal$BoundedHubArb$$subscribersIndex;
                    }
                    ++this.subscriberIndex;
                    return a;
                }
                return object;
            }

            public Chunk pollUpTo(int n) {
                if (this.unsubscribed) {
                    return Chunk$.MODULE$.empty();
                }
                this.subscriberIndex = package$.MODULE$.max(this.subscriberIndex, this.$outer.zio$internal$BoundedHubArb$$subscribersIndex);
                int size = (int)(this.$outer.zio$internal$BoundedHubArb$$publisherIndex - this.subscriberIndex);
                int toPoll = package$.MODULE$.min(n, size);
                if (toPoll <= 0) {
                    return Chunk$.MODULE$.empty();
                }
                ChunkBuilder<A> builder = ChunkBuilder$.MODULE$.make();
                long pollUpToIndex = this.subscriberIndex + (long)toPoll;
                while (this.subscriberIndex != pollUpToIndex) {
                    int index = (int)(this.subscriberIndex % (long)this.$outer.capacity());
                    Object a = this.$outer.zio$internal$BoundedHubArb$$array[index];
                    this.$outer.zio$internal$BoundedHubArb$$subscribers[index] = this.$outer.zio$internal$BoundedHubArb$$subscribers[index] - 1;
                    if (this.$outer.zio$internal$BoundedHubArb$$subscribers[index] == 0) {
                        this.$outer.zio$internal$BoundedHubArb$$array[index] = null;
                        ++this.$outer.zio$internal$BoundedHubArb$$subscribersIndex;
                    }
                    builder.$plus$eq(a);
                    ++this.subscriberIndex;
                }
                return (Chunk)builder.result();
            }

            public int size() {
                if (this.unsubscribed) {
                    return 0;
                }
                return (int)(this.$outer.zio$internal$BoundedHubArb$$publisherIndex - package$.MODULE$.max(this.subscriberIndex, this.$outer.zio$internal$BoundedHubArb$$subscribersIndex));
            }

            public void unsubscribe() {
                if (!this.unsubscribed) {
                    this.unsubscribed = true;
                    --this.$outer.zio$internal$BoundedHubArb$$subscriberCount;
                    this.subscriberIndex = package$.MODULE$.max(this.subscriberIndex, this.$outer.zio$internal$BoundedHubArb$$subscribersIndex);
                    while (this.subscriberIndex != this.$outer.zio$internal$BoundedHubArb$$publisherIndex) {
                        int index = (int)(this.subscriberIndex % (long)this.$outer.capacity());
                        this.$outer.zio$internal$BoundedHubArb$$subscribers[index] = this.$outer.zio$internal$BoundedHubArb$$subscribers[index] - 1;
                        if (this.$outer.zio$internal$BoundedHubArb$$subscribers[index] == 0) {
                            this.$outer.zio$internal$BoundedHubArb$$array[index] = null;
                            ++this.$outer.zio$internal$BoundedHubArb$$subscribersIndex;
                        }
                        ++this.subscriberIndex;
                    }
                    return;
                }
            }
        };
    }
}

