/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import scala.runtime.Scala3RunTime$;
import zio.internal.MutableConcurrentQueue;

public final class OneElementConcurrentQueue<A>
extends MutableConcurrentQueue<A>
implements Serializable {
    private final AtomicReference<Object> ref = new AtomicReference();
    private final AtomicLong headCounter = new AtomicLong(0L);
    private final AtomicBoolean deqInProgress = new AtomicBoolean(false);
    private final AtomicLong tailCounter = new AtomicLong(0L);
    private final AtomicBoolean enqInProgress = new AtomicBoolean(false);

    @Override
    public final int capacity() {
        return 1;
    }

    @Override
    public long dequeuedCount() {
        return this.headCounter.get();
    }

    @Override
    public long enqueuedCount() {
        return this.tailCounter.get();
    }

    @Override
    public boolean isEmpty() {
        return this.ref.get() == null;
    }

    @Override
    public boolean isFull() {
        return !this.isEmpty();
    }

    @Override
    public boolean offer(A a) {
        if (a == null) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        boolean res = false;
        boolean looping = true;
        while (looping) {
            if (this.isFull()) {
                looping = false;
                continue;
            }
            if (!this.enqInProgress.compareAndSet(false, true)) continue;
            if (this.ref.get() == null) {
                this.tailCounter.lazySet(this.tailCounter.get() + 1L);
                this.ref.lazySet(a);
                res = true;
            }
            this.enqInProgress.lazySet(false);
            looping = false;
        }
        return res;
    }

    @Override
    public A poll(A a) {
        Object res = a;
        boolean looping = true;
        while (looping) {
            if (this.isEmpty()) {
                looping = false;
                continue;
            }
            if (!this.deqInProgress.compareAndSet(false, true)) continue;
            Object el = this.ref.get();
            if (el != null) {
                res = el;
                this.headCounter.lazySet(this.headCounter.get() + 1L);
                this.ref.lazySet(null);
            }
            this.deqInProgress.lazySet(false);
            looping = false;
        }
        return res;
    }

    @Override
    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return 1;
    }
}

