/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import zio.internal.MutableConcurrentQueue;
import zio.internal.RingBuffer$;

public abstract class RingBuffer<A>
extends MutableConcurrentQueue<A> {
    private final int capacity;
    private final Object[] buf;
    private long head;
    private long tail;

    public static <A> MutableConcurrentQueue<A> apply(int n) {
        return RingBuffer$.MODULE$.apply(n);
    }

    public static int nextPow2(int n) {
        return RingBuffer$.MODULE$.nextPow2(n);
    }

    public RingBuffer(int capacity) {
        this.capacity = capacity;
        this.buf = new Object[capacity];
        this.head = 0L;
        this.tail = 0L;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    public abstract int posToIdx(long var1, int var3);

    @Override
    public final int size() {
        return (int)(this.tail - this.head);
    }

    @Override
    public final long enqueuedCount() {
        return this.tail;
    }

    @Override
    public final long dequeuedCount() {
        return this.head;
    }

    @Override
    public final boolean offer(A a) {
        if (this.tail < this.head + (long)this.capacity()) {
            int curIdx = this.posToIdx(this.tail, this.capacity());
            this.buf[curIdx] = a;
            ++this.tail;
            return true;
        }
        return false;
    }

    @Override
    public final A poll(A a) {
        if (this.head < this.tail) {
            int curIdx = this.posToIdx(this.head, this.capacity());
            Object deqElement = this.buf[curIdx];
            this.buf[curIdx] = null;
            ++this.head;
            return (A)deqElement;
        }
        return a;
    }

    @Override
    public final boolean isEmpty() {
        return this.tail == this.head;
    }

    @Override
    public final boolean isFull() {
        return this.tail == this.head + (long)this.capacity();
    }
}

