/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.NoSuchElementException;
import java.util.Set;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;
import zio.Unsafe$;
import zio.internal.MutableConcurrentQueue;
import zio.internal.Platform$;
import zio.internal.RingBuffer$;
import zio.internal.WeakConcurrentBag$;

public class WeakConcurrentBag<A> {
    private final int nurserySize;
    private final Function1<A, Object> isAlive;
    private final MutableConcurrentQueue nursery;
    private final Set graduates;

    public static <A> WeakConcurrentBag<A> apply(int n, Function1<A, Object> function1) {
        return WeakConcurrentBag$.MODULE$.apply(n, function1);
    }

    public static <A> Function1<A, Object> apply$default$2() {
        return WeakConcurrentBag$.MODULE$.apply$default$2();
    }

    public WeakConcurrentBag(int nurserySize, Function1<A, Object> isAlive) {
        this.nurserySize = nurserySize;
        this.isAlive = isAlive;
        this.nursery = RingBuffer$.MODULE$.apply(nurserySize);
        this.graduates = Platform$.MODULE$.newConcurrentSet(Unsafe$.MODULE$.unsafe());
    }

    public MutableConcurrentQueue<A> nursery() {
        return this.nursery;
    }

    public Set<WeakReference<A>> graduates() {
        return this.graduates;
    }

    public final void add(A a) {
        while (!this.nursery().offer(a)) {
            this.graduate();
        }
    }

    public final void gc() {
        for (WeakReference<A> weakRef : this.graduates()) {
            Object value = weakRef.get();
            if (value == null) {
                this.graduates().remove(weakRef);
                continue;
            }
            if (BoxesRunTime.unboxToBoolean((Object)this.isAlive.apply(value))) continue;
            this.graduates().remove(weakRef);
        }
    }

    public final void graduate() {
        int graduateCount = 0;
        Object element = this.nursery().poll(null);
        while (element != null) {
            if (BoxesRunTime.unboxToBoolean((Object)this.isAlive.apply(element))) {
                WeakReference<Object> weakRef = new WeakReference<Object>(element);
                this.graduates().add(weakRef);
            }
            element = this.nursery().poll(null);
            ++graduateCount;
        }
        if (graduateCount > this.nurserySize / 10) {
            this.gc();
            return;
        }
    }

    public final Iterator<A> iterator() {
        this.graduate();
        return new Iterator<A>(this){
            private final java.util.Iterator it;
            private Object _next;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.it = $outer.graduates().iterator();
                this._next = this.prefetch();
            }

            public java.util.Iterator it() {
                return this.it;
            }

            public Object _next() {
                return this._next;
            }

            public void _next_$eq(Object x$1) {
                this._next = x$1;
            }

            public Object prefetch() {
                while (this.it().hasNext()) {
                    T next = ((Reference)this.it().next()).get();
                    if (next == null) continue;
                    return next;
                }
                return null;
            }

            public boolean hasNext() {
                return this._next() != null;
            }

            public Object next() {
                if (this._next() == null) {
                    throw new NoSuchElementException("There is no more element in the weak concurrent bag iterator");
                }
                Object result = this._next();
                this._next_$eq(this.prefetch());
                return result;
            }
        };
    }

    public int size() {
        return this.graduates().size() + this.nursery().size();
    }

    public final String toString() {
        return this.iterator().mkString("WeakConcurrentBag(", ",", ")");
    }
}

