/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import scala.;
import scala.$less$colon$less$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.ChunkLike;
import zio.Duration$;
import zio.internal.metrics.ConcurrentMetricHooks;
import zio.internal.metrics.MetricHook;
import zio.internal.metrics.MetricHook$;
import zio.internal.metrics.package$;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricKeyType$Frequency$;
import zio.metrics.MetricKeyType$Gauge$;
import zio.metrics.MetricState;
import zio.metrics.MetricState$Counter$;
import zio.metrics.MetricState$Frequency$;
import zio.metrics.MetricState$Gauge$;
import zio.metrics.MetricState$Histogram$;
import zio.metrics.MetricState$Summary$;

public class ConcurrentMetricHooksPlatformSpecific
implements ConcurrentMetricHooks {
    @Override
    public MetricHook<Object, MetricState.Counter> counter(MetricKey<MetricKeyType$Counter$> key) {
        DoubleRef sum = DoubleRef.create((double)0.0);
        return MetricHook$.MODULE$.apply((JFunction1.mcVD.sp & Serializable)v -> {
            double d;
            sum$1.elem = d = sum$1.elem + v;
        }, (Function0 & Serializable)() -> MetricState$Counter$.MODULE$.apply(sum$2.elem), (JFunction1.mcVD.sp & Serializable)v -> {
            double d;
            sum$3.elem = d = sum$3.elem + v;
        });
    }

    @Override
    public MetricHook<Object, MetricState.Gauge> gauge(MetricKey<MetricKeyType$Gauge$> key, double startAt) {
        DoubleRef value = DoubleRef.create((double)startAt);
        return MetricHook$.MODULE$.apply((JFunction1.mcVD.sp & Serializable)v -> {
            double d;
            value$1.elem = d = v;
        }, (Function0 & Serializable)() -> MetricState$Gauge$.MODULE$.apply(value$2.elem), (JFunction1.mcVD.sp & Serializable)v -> {
            double d;
            value$3.elem = d = value$3.elem + v;
        });
    }

    @Override
    public MetricHook<Object, MetricState.Histogram> histogram(MetricKey<MetricKeyType.Histogram> key) {
        Chunk<Object> bounds = key.keyType().boundaries().values();
        long[] values = new long[bounds.length() + 1];
        double[] boundaries = new double[bounds.length()];
        LongRef count = LongRef.create((long)0L);
        DoubleRef sum = DoubleRef.create((double)0.0);
        int size = bounds.length();
        DoubleRef min = DoubleRef.create((double)Double.MAX_VALUE);
        DoubleRef max = DoubleRef.create((double)Double$.MODULE$.MinValue());
        ((ChunkLike)bounds.sorted((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).zipWithIndex().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double n = tuple2._1$mcD$sp();
                int i = tuple2._2$mcI$sp();
                boundaries$1[i] = n;
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        JFunction1.mcVD.sp & Serializable update = (JFunction1.mcVD.sp & Serializable)value -> {
            double d;
            long l;
            int from = 0;
            int to = size;
            while (from != to) {
                int mid = from + (to - from) / 2;
                double boundary = boundaries[mid];
                if (value <= boundary) {
                    to = mid;
                } else {
                    from = mid;
                }
                if (to != from + 1) continue;
                if (value <= boundaries[from]) {
                    to = from;
                    continue;
                }
                from = to;
            }
            values$1[from] = values[from] + 1L;
            count$1.elem = l = count$1.elem + 1L;
            sum$4.elem = d = sum$4.elem + value;
            if (value < min$1.elem) {
                double d2;
                min$1.elem = d2 = value;
            }
            if (value > max$1.elem) {
                double d3;
                max$1.elem = d3 = value;
            }
        };
        return MetricHook$.MODULE$.apply(update, (Function0 & Serializable)() -> MetricState$Histogram$.MODULE$.apply(ConcurrentMetricHooksPlatformSpecific.getBuckets$1(values, boundaries, size), count$2.elem, min$2.elem, max$2.elem, sum$5.elem), update);
    }

    @Override
    public MetricHook<Tuple2<Object, Instant>, MetricState.Summary> summary(MetricKey<MetricKeyType.Summary> key) {
        Tuple2[] values = new Tuple2[key.keyType().maxSize()];
        IntRef head = IntRef.create((int)0);
        LongRef count = LongRef.create((long)0L);
        DoubleRef sum = DoubleRef.create((double)0.0);
        DoubleRef min = DoubleRef.create((double)Double.MAX_VALUE);
        DoubleRef max = DoubleRef.create((double)Double$.MODULE$.MinValue());
        Chunk sortedQuantiles = (Chunk)key.keyType().quantiles().sorted(package$.MODULE$.DoubleOrdering());
        return MetricHook$.MODULE$.apply((JProcedure1 & Serializable)t -> ConcurrentMetricHooksPlatformSpecific.observe$1(key, values, head, count, sum, min, max, BoxesRunTime.unboxToDouble((Object)t._1()), (Instant)t._2()), (Function0 & Serializable)() -> MetricState$Summary$.MODULE$.apply(((MetricKeyType.Summary)key.keyType()).error(), ConcurrentMetricHooksPlatformSpecific.snapshot$1(key, values, sortedQuantiles, Instant.now()), ConcurrentMetricHooksPlatformSpecific.getCount$1(count), ConcurrentMetricHooksPlatformSpecific.getMin$1(min), ConcurrentMetricHooksPlatformSpecific.getMax$1(max), ConcurrentMetricHooksPlatformSpecific.getSum$1(sum)), (JProcedure1 & Serializable)t -> ConcurrentMetricHooksPlatformSpecific.observe$1(key, values, head, count, sum, min, max, BoxesRunTime.unboxToDouble((Object)t._1()), (Instant)t._2()));
    }

    @Override
    public MetricHook<String, MetricState.Frequency> frequency(MetricKey<MetricKeyType$Frequency$> key) {
        LongRef count = LongRef.create((long)0L);
        HashMap values = new HashMap();
        JProcedure1 & Serializable update = (JProcedure1 & Serializable)word -> {
            long l;
            count$6.elem = l = count$6.elem + 1L;
            long slotCount = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply(values.get(word)).getOrElse(ConcurrentMetricHooksPlatformSpecific::$anonfun$3));
            values.put(word, BoxesRunTime.boxToLong((long)(slotCount + 1L)));
        };
        return MetricHook$.MODULE$.apply(update, (Function0 & Serializable)() -> MetricState$Frequency$.MODULE$.apply((Map<String, Object>)ConcurrentMetricHooksPlatformSpecific.snapshot$2(values)), update);
    }

    private static final Chunk getBuckets$1(long[] values$2, double[] boundaries$3, int size$2) {
        ChunkBuilder builder = ChunkBuilder$.MODULE$.make();
        long cumulated = 0L;
        for (int i = 0; i != size$2; ++i) {
            double boundary = boundaries$3[i];
            long value = values$2[i];
            Double d = (Double)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)boundary));
            builder.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)d, (Object)BoxesRunTime.boxToLong((long)(cumulated += value))));
        }
        return (Chunk)builder.result();
    }

    private static final long getCount$1(LongRef count$3) {
        return count$3.elem;
    }

    private static final double getMin$1(DoubleRef min$3) {
        return min$3.elem;
    }

    private static final double getMax$1(DoubleRef max$3) {
        return max$3.elem;
    }

    private static final double getSum$1(DoubleRef sum$6) {
        return sum$6.elem;
    }

    private static final Chunk snapshot$1(MetricKey key$1, Tuple2[] values$4, Chunk sortedQuantiles$1, Instant now) {
        ChunkBuilder builder = ChunkBuilder$.MODULE$.make();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ((MetricKeyType.Summary)key$1.keyType()).maxSize()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            Tuple2 item = values$4[idx];
            if (item != null) {
                Tuple2 tuple2 = item;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Instant t = (Instant)tuple2._1();
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)t, (Object)BoxesRunTime.boxToDouble((double)v));
                Instant t2 = (Instant)tuple22._1();
                double v2 = BoxesRunTime.unboxToDouble((Object)tuple22._2());
                Duration age = Duration$.MODULE$.fromInterval(t2, now);
                if (!age.isNegative() && age.compareTo(((MetricKeyType.Summary)key$1.keyType()).maxAge()) <= 0) {
                    builder.$plus$eq(BoxesRunTime.boxToDouble((double)v2));
                    return;
                }
                return;
            }
        });
        return package$.MODULE$.calculateQuantiles(((MetricKeyType.Summary)key$1.keyType()).error(), sortedQuantiles$1, (Chunk)((StrictOptimizedSeqOps)builder.result()).sorted(package$.MODULE$.DoubleOrdering()));
    }

    private static final void observe$1(MetricKey key$3, Tuple2[] values$6, IntRef head$1, LongRef count$4, DoubleRef sum$7, DoubleRef min$4, DoubleRef max$4, double value, Instant t) {
        double d;
        long l;
        if (((MetricKeyType.Summary)key$3.keyType()).maxSize() > 0) {
            int n;
            head$1.elem = n = head$1.elem + 1;
            int target = head$1.elem % ((MetricKeyType.Summary)key$3.keyType()).maxSize();
            values$6[target] = Tuple2$.MODULE$.apply((Object)t, (Object)BoxesRunTime.boxToDouble((double)value));
        }
        count$4.elem = l = count$4.elem + 1L;
        sum$7.elem = d = sum$7.elem + value;
        if (value < min$4.elem) {
            double d2;
            min$4.elem = d2 = value;
        }
        if (value > max$4.elem) {
            double d3;
            max$4.elem = d3 = value;
        }
    }

    private static final long $anonfun$3() {
        return 0L;
    }

    private static final Map snapshot$2(HashMap values$9) {
        scala.collection.mutable.Map builder = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        for (Map.Entry e : values$9.entrySet()) {
            builder.update(e.getKey(), (Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong(e.getValue()))));
        }
        return builder.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }
}

