/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import zio.Unsafe;
import zio.internal.metrics.ConcurrentMetricHooks$;
import zio.internal.metrics.MetricHook;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricKeyType$Frequency$;
import zio.metrics.MetricKeyType$Gauge$;
import zio.metrics.MetricListener;
import zio.metrics.MetricPair;
import zio.metrics.MetricPair$;
import zio.metrics.MetricState;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh!B\u0001\u0003\u0001\u0019A!\u0001G\"p]\u000e,(O]3oi6+GO]5d%\u0016<\u0017n\u001d;ss*\u00111\u0001B\u0001\b[\u0016$(/[2t\u0015\t)a!\u0001\u0005j]R,'O\\1m\u0015\u00059\u0011a\u0001>j_N\u0011\u0001!\u0003\t\u0003\u00155i\u0011a\u0003\u0006\u0002\u0019\u0005)1oY1mC&\u0011ab\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000bA\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?\u0007\u0001!\u0012a\u0005\t\u0003)\u0001i\u0011A\u0001\u0005\b-\u0001\u0011\r\u0011\"\u0003\u0018\u00031a\u0017n\u001d;f]\u0016\u00148OU3g+\u0005A\u0002cA\r#I5\t!D\u0003\u0002\u001c9\u00051\u0011\r^8nS\u000eT!!\b\u0010\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002 A\u0005!Q\u000f^5m\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u000e\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u00042AC\u0013(\u0013\t13BA\u0003BeJ\f\u0017\u0010\u0005\u0002)U5\t\u0011F\u0003\u0002\u0004\r%\u00111&\u000b\u0002\u000f\u001b\u0016$(/[2MSN$XM\\3s\u0011\u0019i\u0003\u0001)A\u00051\u0005iA.[:uK:,'o\u001d*fM\u0002Bqa\f\u0001C\u0002\u0013%\u0001'A\u0002nCB,\u0012!\r\t\u0005eM*4(D\u0001\u001d\u0013\t!DDA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u00042\u0001\u000b\u001c9\u0013\t9\u0014FA\u0005NKR\u0014\u0018nY&fsB\u0011\u0001&O\u0005\u0003u%\u0012Q\"T3ue&\u001c7*Z=UsB,\u0007C\u0001\u001f@\u001d\t!R(\u0003\u0002?\u0005\u0005QQ*\u001a;sS\u000eDun\\6\n\u0005\u0001\u000b%\u0001\u0002*p_RT!A\u0010\u0002\t\r\r\u0003\u0001\u0015!\u00032\u0003\u0011i\u0017\r\u001d\u0011\t\u000b\u0015\u0003A\u0011\u0001$\u0002\u0011Mt\u0017\r]:i_R$\u0012a\u0012\u000b\u0003\u0011Z\u00032!\u0013'P\u001d\tQ!*\u0003\u0002L\u0017\u00051\u0001K]3eK\u001aL!!\u0014(\u0003\u0007M+GO\u0003\u0002L\u0017A\u0011\u0001k\u0015\b\u0003QEK!AU\u0015\u0002\u00155+GO]5d!\u0006L'/\u0003\u0002U+\n9QK\u001c;za\u0016$'B\u0001**\u0011\u00159F\tq\u0001Y\u0003\u0019)hn]1gKB\u0011\u0011LW\u0007\u0002\r%\u00111L\u0002\u0002\u0007+:\u001c\u0018MZ3\t\u000bu\u0003A\u0011\u00010\u0002\u0007\u001d,G/\u0006\u0002`YR\u0011\u0001\r\u001b\u000b\u0003Cf\u0004B\u0001\u00062em&\u00111M\u0001\u0002\u000b\u001b\u0016$(/[2I_>\\\u0007CA3u\u001d\t1'O\u0004\u0002hQ2\u0001\u0001\"B5]\u0001\u0004Q\u0017aA6fsB\u0019\u0001FN6\u0011\u0005\u001ddG!B7]\u0005\u0004q'\u0001\u0002+za\u0016\f\"a\u001c\u001d\u0011\u0005)\u0001\u0018BA9\f\u0005\u001dqu\u000e\u001e5j]\u001eL!a\u001d\u001c\u0002\u000f-,\u0017\u0010V=qK&\u0011Q/\u000f\u0002\u0003\u0013:\u0004\"!Z<\n\u0005aL$aA(vi\")q\u000b\u0018a\u00021\")1\u0010\u0001C\u0003y\u0006Y\u0011\r\u001a3MSN$XM\\3s)\ri\u0018Q\u0001\u000b\u0004}\u0006\r\u0001C\u0001\u0006\u0000\u0013\r\t\ta\u0003\u0002\u0005+:LG\u000fC\u0003Xu\u0002\u000f\u0001\f\u0003\u0004\u0002\bi\u0004\raJ\u0001\tY&\u001cH/\u001a8fe\"\u001a!0a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005\f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\tyAA\u0004uC&d'/Z2\t\u000f\u0005e\u0001\u0001\"\u0002\u0002\u001c\u0005q!/Z7pm\u0016d\u0015n\u001d;f]\u0016\u0014H\u0003BA\u000f\u0003C!2A`A\u0010\u0011\u00199\u0016q\u0003a\u00021\"9\u0011qAA\f\u0001\u00049\u0003\u0006BA\f\u0003\u0017A\u0001\"a\n\u0001\t\u00031\u0011\u0011F\u0001\u0010]>$\u0018NZ=MSN$XM\\3sgV!\u00111FA1)\u0019\ti#!\u0014\u0002nQ)a0a\f\u0002L!A\u0011\u0011GA\u0013\u0001\b\t\u0019$A\u0003ue\u0006\u001cW\r\u0005\u0003\u00026\u0005\u0015c\u0002BA\u001c\u0003\u0003rA!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{\t\u0012A\u0002\u001fs_>$h(C\u0001\b\u0013\r\t\u0019EB\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9%!\u0013\u0003\u000bQ\u0013\u0018mY3\u000b\u0007\u0005\rc\u0001\u0003\u0004X\u0003K\u0001\u001d\u0001\u0017\u0005\bS\u0006\u0015\u0002\u0019AA(!\u0011Ac'!\u0015\u0011\r\u0005M\u0013\u0011LA0\u001d\rA\u0013QK\u0005\u0004\u0003/J\u0013!D'fiJL7mS3z)f\u0004X-\u0003\u0003\u0002\\\u0005u#AB,ji\"LeNC\u0002\u0002X%\u00022aZA1\t!\t\u0019'!\nC\u0002\u0005\u0015$!\u0001+\u0012\u0007=\f9\u0007E\u0002\u000b\u0003SJ1!a\u001b\f\u0005\r\te.\u001f\u0005\t\u0003_\n)\u00031\u0001\u0002`\u0005)a/\u00197vK\"9\u00111\u000f\u0001\u0005\n\u0005U\u0014AC4fi\u000e{WO\u001c;feR!\u0011qOAA)\u0011\tI(a \u0011\u0007q\nY(C\u0002\u0002~\u0005\u0013qaQ8v]R,'\u000f\u0003\u0004X\u0003c\u0002\u001d\u0001\u0017\u0005\bS\u0006E\u0004\u0019AAB!\u0011\t))a#\u000f\u0007!\n9)C\u0002\u0002\n&\n\u0011\"T3ue&\u001c7*Z=\n\t\u0005u\u0014Q\u0012\u0006\u0004\u0003\u0013K\u0003bBAI\u0001\u0011%\u00111S\u0001\tO\u0016$x)Y;hKR!\u0011QSAP)\u0011\t9*!(\u0011\u0007q\nI*C\u0002\u0002\u001c\u0006\u0013QaR1vO\u0016DaaVAH\u0001\bA\u0006bB5\u0002\u0010\u0002\u0007\u0011\u0011\u0015\t\u0005\u0003\u000b\u000b\u0019+\u0003\u0003\u0002\u001c\u00065\u0005bBAT\u0001\u0011%\u0011\u0011V\u0001\rO\u0016$\b*[:u_\u001e\u0014\u0018-\u001c\u000b\u0005\u0003W\u000b)\f\u0006\u0003\u0002.\u0006M\u0006c\u0001\u001f\u00020&\u0019\u0011\u0011W!\u0003\u0013!K7\u000f^8he\u0006l\u0007BB,\u0002&\u0002\u000f\u0001\fC\u0004j\u0003K\u0003\r!a.\u0011\t\u0005\u0015\u0015\u0011X\u0005\u0005\u0003c\u000bi\tC\u0004\u0002>\u0002!I!a0\u0002\u0015\u001d,GoU;n[\u0006\u0014\u0018\u0010\u0006\u0003\u0002B\u0006-G\u0003BAb\u0003\u0013\u00042\u0001PAc\u0013\r\t9-\u0011\u0002\b'VlW.\u0019:z\u0011\u00199\u00161\u0018a\u00021\"9\u0011.a/A\u0002\u00055\u0007\u0003BAC\u0003\u001fLA!a2\u0002\u000e\"9\u00111\u001b\u0001\u0005\n\u0005U\u0017aC4fiN+GoQ8v]R$B!a6\u0002bR!\u0011\u0011\\Ap!\ra\u00141\\\u0005\u0004\u0003;\f%!\u0003$sKF,XM\\2z\u0011\u00199\u0016\u0011\u001ba\u00021\"9\u0011.!5A\u0002\u0005\r\b\u0003BAC\u0003KLA!!8\u0002\u000e\u0002")
public class ConcurrentMetricRegistry {
    private final AtomicReference<MetricListener[]> listenersRef = new AtomicReference<Object>(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(MetricListener.class)));
    private final ConcurrentHashMap<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> map = new ConcurrentHashMap();

    private AtomicReference<MetricListener[]> listenersRef() {
        return this.listenersRef;
    }

    private ConcurrentHashMap<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> map() {
        return this.map;
    }

    public scala.collection.immutable.Set<MetricPair<MetricKeyType, Object>> snapshot(Unsafe unsafe) {
        Iterator<Map.Entry<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>>> iterator2 = this.map().entrySet().iterator();
        Set result = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (iterator2.hasNext()) {
            Map.Entry<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> value2 = iterator2.next();
            MetricKey<MetricKeyType> key = value2.getKey();
            MetricHook<?, MetricState<Object>> hook = value2.getValue();
            result.add(MetricPair$.MODULE$.make(key, (MetricState)hook.get().apply(), unsafe));
        }
        return result.toSet();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <Type extends MetricKeyType> MetricHook<Object, Object> get(MetricKey<Type> key, Unsafe unsafe) {
        MetricHook<Object, Object> metricHook;
        MetricHook<Object, Object> hook0 = this.map().get(key);
        if (hook0 == null) {
            void var5_10;
            MetricKeyType metricKeyType = key.keyType();
            if (MetricKeyType$Counter$.MODULE$.equals(metricKeyType)) {
                MetricHook<Object, MetricState.Counter> metricHook2 = this.getCounter(key, unsafe);
            } else if (MetricKeyType$Frequency$.MODULE$.equals(metricKeyType)) {
                MetricHook<String, MetricState.Frequency> metricHook3 = this.getSetCount(key, unsafe);
            } else if (MetricKeyType$Gauge$.MODULE$.equals(metricKeyType)) {
                MetricHook<Object, MetricState.Gauge> metricHook4 = this.getGauge(key, unsafe);
            } else if (metricKeyType instanceof MetricKeyType.Histogram) {
                MetricHook<Object, MetricState.Histogram> metricHook5 = this.getHistogram(key, unsafe);
            } else {
                if (!(metricKeyType instanceof MetricKeyType.Summary)) throw new MatchError((Object)metricKeyType);
                MetricHook<Tuple2<Object, Instant>, MetricState.Summary> metricHook6 = this.getSummary(key, unsafe);
            }
            metricHook = var5_10;
            return metricHook;
        } else {
            metricHook = hook0;
        }
        return metricHook;
    }

    public final void addListener(MetricListener listener, Unsafe unsafe) {
        while (true) {
            MetricListener[] oldListeners = this.listenersRef().get();
            MetricListener[] newListeners = (MetricListener[])Predef$.MODULE$.refArrayOps((Object[])oldListeners).$colon$plus((Object)listener, ClassTag$.MODULE$.apply(MetricListener.class));
            if (!this.listenersRef().compareAndSet(oldListeners, newListeners)) continue;
            return;
        }
    }

    public final void removeListener(MetricListener listener, Unsafe unsafe) {
        while (true) {
            MetricListener[] oldListeners = this.listenersRef().get();
            MetricListener[] newListeners = (MetricListener[])Predef$.MODULE$.refArrayOps((Object[])oldListeners).filter((Function1)new Serializable(this, listener){
                public static final long serialVersionUID = 0L;
                private final MetricListener listener$1;

                public final boolean apply(MetricListener x$1) {
                    return x$1 != this.listener$1;
                }
                {
                    this.listener$1 = listener$1;
                }
            });
            if (!this.listenersRef().compareAndSet(oldListeners, newListeners)) continue;
            return;
        }
    }

    public <T> void notifyListeners(MetricKey<MetricKeyType> key, T value2, Object trace2, Unsafe unsafe) {
        MetricListener[] listeners = this.listenersRef().get();
        int len = listeners.length;
        if (len > 0) {
            int i;
            MetricKeyType metricKeyType = key.keyType();
            if (MetricKeyType$Gauge$.MODULE$.equals(metricKeyType)) {
                for (i = 0; i < len; ++i) {
                    listeners[i].updateGauge(key, BoxesRunTime.unboxToDouble(value2), unsafe);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (metricKeyType instanceof MetricKeyType.Histogram) {
                while (i < len) {
                    listeners[i].updateHistogram(key, BoxesRunTime.unboxToDouble(value2), unsafe);
                    ++i;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (MetricKeyType$Frequency$.MODULE$.equals(metricKeyType)) {
                while (i < len) {
                    listeners[i].updateFrequency(key, (String)value2, unsafe);
                    ++i;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (metricKeyType instanceof MetricKeyType.Summary) {
                while (i < len) {
                    Tuple2 tuple2 = (Tuple2)value2;
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        double v = tuple2._1$mcD$sp();
                        Instant instant2 = (Instant)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)v), (Object)instant2);
                        double v2 = tuple23._1$mcD$sp();
                        Instant instant3 = (Instant)tuple23._2();
                        listeners[i].updateSummary(key, v2, instant3, unsafe);
                        ++i;
                        continue;
                    }
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (MetricKeyType$Counter$.MODULE$.equals(metricKeyType)) {
                while (i < len) {
                    listeners[i].updateCounter(key, BoxesRunTime.unboxToDouble(value2), unsafe);
                    ++i;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)metricKeyType);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private MetricHook<Object, MetricState.Counter> getCounter(MetricKey<MetricKeyType$Counter$> key, Unsafe unsafe) {
        void var3_3;
        MetricHook<?, MetricState<Object>> value2 = this.map().get(key);
        if (value2 == null) {
            MetricHook<Object, MetricState.Counter> counter2 = ConcurrentMetricHooks$.MODULE$.counter(key);
            this.map().putIfAbsent(key, counter2);
            value2 = this.map().get(key);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private MetricHook<Object, MetricState.Gauge> getGauge(MetricKey<MetricKeyType$Gauge$> key, Unsafe unsafe) {
        void var3_3;
        MetricHook<?, MetricState<Object>> value2 = this.map().get(key);
        if (value2 == null) {
            MetricHook<Object, MetricState.Gauge> gauge2 = ConcurrentMetricHooks$.MODULE$.gauge(key, 0.0);
            this.map().putIfAbsent(key, gauge2);
            value2 = this.map().get(key);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private MetricHook<Object, MetricState.Histogram> getHistogram(MetricKey<MetricKeyType.Histogram> key, Unsafe unsafe) {
        void var3_3;
        MetricHook<?, MetricState<Object>> value2 = this.map().get(key);
        if (value2 == null) {
            MetricHook<Object, MetricState.Histogram> histogram2 = ConcurrentMetricHooks$.MODULE$.histogram(key);
            this.map().putIfAbsent(key, histogram2);
            value2 = this.map().get(key);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private MetricHook<Tuple2<Object, Instant>, MetricState.Summary> getSummary(MetricKey<MetricKeyType.Summary> key, Unsafe unsafe) {
        void var3_3;
        MetricHook<?, MetricState<Object>> value2 = this.map().get(key);
        if (value2 == null) {
            MetricHook<Tuple2<Object, Instant>, MetricState.Summary> summary2 = ConcurrentMetricHooks$.MODULE$.summary(key);
            this.map().putIfAbsent(key, summary2);
            value2 = this.map().get(key);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private MetricHook<String, MetricState.Frequency> getSetCount(MetricKey<MetricKeyType$Frequency$> key, Unsafe unsafe) {
        void var3_3;
        MetricHook<?, MetricState<Object>> value2 = this.map().get(key);
        if (value2 == null) {
            MetricHook<String, MetricState.Frequency> frequency2 = ConcurrentMetricHooks$.MODULE$.frequency(key);
            this.map().putIfAbsent(key, frequency2);
            value2 = this.map().get(key);
        }
        return var3_3;
    }
}

