/*
 * Decompiled with CFR 0.152.
 */
package dev.zwander.kotlin.file;

import android.content.Context;
import android.net.Uri;
import dev.zwander.kotlin.file.ContextInitializer;
import dev.zwander.kotlin.file.IPlatformFile;
import dev.zwander.kotlin.file.PlatformFile;
import dev.zwander.kotlin.file.PlatformUriFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ldev/zwander/kotlin/file/FileUtils;", "", "<init>", "()V", "fromString", "Ldev/zwander/kotlin/file/IPlatformFile;", "input", "", "isDirectory", "", "library_release"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();

    private FileUtils() {
    }

    @Nullable
    public final IPlatformFile fromString(@NotNull String input, boolean isDirectory) {
        IPlatformFile iPlatformFile;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Uri uri = Uri.parse((String)input);
        if (uri.getScheme() != null && !Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
            Context context = ContextInitializer.Companion.getAppContext();
            Intrinsics.checkNotNull((Object)uri);
            iPlatformFile = new PlatformUriFile(context, uri, isDirectory);
        } else if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
            PlatformFile platformFile;
            String string = uri.getPath();
            if (string != null) {
                String it = string;
                boolean bl = false;
                platformFile = new PlatformFile(it);
            } else {
                platformFile = null;
            }
            iPlatformFile = platformFile;
        } else {
            iPlatformFile = new PlatformFile(new File(input));
        }
        return iPlatformFile;
    }
}

