/*
 * Decompiled with CFR 0.152.
 */
package dev.zwander.kotlin.file;

import android.content.Context;
import android.net.Uri;
import androidx.documentfile.provider.DocumentFile;
import dev.zwander.kotlin.file.IPlatformFile;
import dev.zwander.kotlin.file.IPlatformFileKt;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.CoreKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\tB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0006\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0010H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\u0001H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0001H\u0016J\b\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\rH\u0016J\b\u0010\u001f\u001a\u00020\rH\u0016J\b\u0010 \u001a\u00020\rH\u0016J\b\u0010!\u001a\u00020\rH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020#H\u0016J\b\u0010'\u001a\u00020#H\u0016J\b\u0010(\u001a\u00020\rH\u0016J\b\u0010)\u001a\u00020\rH\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0013\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100-H\u0016\u00a2\u0006\u0002\u0010.JK\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100-26\u0010/\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\r00H\u0016\u00a2\u0006\u0002\u00104J\u0013\u00105\u001a\b\u0012\u0004\u0012\u00020\u00010-H\u0016\u00a2\u0006\u0002\u00106JK\u00105\u001a\b\u0012\u0004\u0012\u00020\u00010-26\u0010/\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\r00H\u0016\u00a2\u0006\u0002\u00107J6\u00105\u001a\b\u0012\u0004\u0012\u00020\u00010-2!\u0010/\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(9\u0012\u0004\u0012\u00020\r08H\u0016\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020\rH\u0016J\b\u0010<\u001a\u00020\rH\u0016J\u0010\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020\u0001H\u0016J\u0010\u0010?\u001a\u00020\r2\u0006\u0010@\u001a\u00020#H\u0016J\b\u0010A\u001a\u00020\rH\u0016J\u0018\u0010B\u001a\u00020\r2\u0006\u0010C\u001a\u00020\r2\u0006\u0010D\u001a\u00020\rH\u0016J\u0010\u0010B\u001a\u00020\r2\u0006\u0010C\u001a\u00020\rH\u0016J\u0018\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\u0006\u0010D\u001a\u00020\rH\u0016J\u0010\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\rH\u0016J\u0018\u0010G\u001a\u00020\r2\u0006\u0010H\u001a\u00020\r2\u0006\u0010D\u001a\u00020\rH\u0016J\u0010\u0010G\u001a\u00020\r2\u0006\u0010H\u001a\u00020\rH\u0016J\b\u0010I\u001a\u00020\rH\u0016J\u0012\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020\rH\u0016J\n\u0010M\u001a\u0004\u0018\u00010NH\u0016J\"\u0010O\u001a\u0004\u0018\u00010\u00012\u0006\u0010P\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010Q\u001a\u00020\u0010H\u0016J\u0011\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u0001H\u0096\u0002J\u0013\u0010U\u001a\u00020\r2\b\u0010T\u001a\u0004\u0018\u00010VH\u0096\u0002J\b\u0010W\u001a\u00020SH\u0016J\b\u0010X\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006Y"}, d2={"Ldev/zwander/kotlin/file/PlatformUriFile;", "Ldev/zwander/kotlin/file/IPlatformFile;", "context", "Landroid/content/Context;", "wrappedFile", "Landroidx/documentfile/provider/DocumentFile;", "<init>", "(Landroid/content/Context;Landroidx/documentfile/provider/DocumentFile;)V", "file", "(Landroid/content/Context;Ldev/zwander/kotlin/file/IPlatformFile;)V", "uri", "Landroid/net/Uri;", "isTree", "", "(Landroid/content/Context;Landroid/net/Uri;Z)V", "nameWithoutExtension", "", "getNameWithoutExtension", "()Ljava/lang/String;", "getName", "getParent", "getParentFile", "getPath", "isAbsolute", "getAbsolutePath", "getAbsoluteFile", "getCanonicalPath", "getCanonicalFile", "getCanRead", "getCanWrite", "getExists", "isDirectory", "isFile", "isHidden", "getLastModified", "", "getLength", "getTotalSpace", "getFreeSpace", "getUsableSpace", "createNewFile", "delete", "deleteOnExit", "", "list", "", "()[Ljava/lang/String;", "filter", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "dir", "(Lkotlin/jvm/functions/Function2;)[Ljava/lang/String;", "listFiles", "()[Ldev/zwander/kotlin/file/IPlatformFile;", "(Lkotlin/jvm/functions/Function2;)[Ldev/zwander/kotlin/file/IPlatformFile;", "Lkotlin/Function1;", "pathName", "(Lkotlin/jvm/functions/Function1;)[Ldev/zwander/kotlin/file/IPlatformFile;", "mkdir", "mkdirs", "renameTo", "dest", "setLastModified", "time", "setReadOnly", "setWritable", "writable", "ownerOnly", "setReadable", "readable", "setExecutable", "executable", "canExecute", "openOutputStream", "Lkotlinx/io/Sink;", "append", "openInputStream", "Lkotlinx/io/Source;", "child", "childName", "mimeType", "compareTo", "", "other", "equals", "", "hashCode", "toString", "library_release"})
@SourceDebugExtension(value={"SMAP\nPlatformUriFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformUriFile.kt\ndev/zwander/kotlin/file/PlatformUriFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1#2:180\n11165#3:181\n11500#3,3:182\n3829#3:187\n4344#3,2:188\n11165#3:196\n11500#3,3:197\n3829#3:202\n4344#3,2:203\n3829#3:211\n4344#3,2:212\n37#4,2:185\n37#4,2:194\n37#4,2:200\n37#4,2:209\n37#4,2:218\n1557#5:190\n1628#5,3:191\n1557#5:205\n1628#5,3:206\n1557#5:214\n1628#5,3:215\n*S KotlinDebug\n*F\n+ 1 PlatformUriFile.kt\ndev/zwander/kotlin/file/PlatformUriFile\n*L\n64#1:181\n64#1:182,3\n68#1:187\n68#1:188,2\n74#1:196\n74#1:197,3\n79#1:202\n79#1:203,2\n85#1:211\n85#1:212,2\n64#1:185,2\n70#1:194,2\n75#1:200,2\n81#1:209,2\n87#1:218,2\n70#1:190\n70#1:191,3\n80#1:205\n80#1:206,3\n86#1:214\n86#1:215,3\n*E\n"})
public final class PlatformUriFile
implements IPlatformFile {
    @NotNull
    private final Context context;
    @NotNull
    private final DocumentFile wrappedFile;

    public PlatformUriFile(@NotNull Context context, @NotNull DocumentFile wrappedFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)wrappedFile, (String)"wrappedFile");
        this.context = context;
        this.wrappedFile = wrappedFile;
    }

    public PlatformUriFile(@NotNull Context context, @NotNull IPlatformFile file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(context, ((PlatformUriFile)file).wrappedFile);
    }

    public PlatformUriFile(@NotNull Context context, @NotNull Uri uri, boolean isTree) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        DocumentFile documentFile = isTree ? DocumentFile.fromTreeUri((Context)context, (Uri)uri) : DocumentFile.fromSingleUri((Context)context, (Uri)uri);
        Intrinsics.checkNotNull((Object)documentFile);
        this(context, documentFile);
    }

    @Override
    @NotNull
    public String getNameWithoutExtension() {
        String string = this.wrappedFile.getName();
        if (string == null || (string = StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null)) == null) {
            String string2 = this.wrappedFile.getUri().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.wrappedFile.getName();
        if (string == null) {
            String string2 = this.wrappedFile.getUri().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        return string;
    }

    @Override
    @Nullable
    public String getParent() {
        DocumentFile documentFile = this.wrappedFile.getParentFile();
        return documentFile != null && (documentFile = documentFile.getUri()) != null ? documentFile.toString() : null;
    }

    @Override
    @Nullable
    public IPlatformFile getParentFile() {
        PlatformUriFile platformUriFile;
        DocumentFile documentFile = this.wrappedFile.getParentFile();
        if (documentFile != null) {
            DocumentFile it = documentFile;
            boolean bl = false;
            platformUriFile = new PlatformUriFile(this.context, it);
        } else {
            platformUriFile = null;
        }
        return platformUriFile;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.wrappedFile.getUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public boolean isAbsolute() {
        return false;
    }

    @Override
    @NotNull
    public String getAbsolutePath() {
        return this.getPath();
    }

    @Override
    @NotNull
    public IPlatformFile getAbsoluteFile() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalPath() {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    @NotNull
    public IPlatformFile getCanonicalFile() {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    public boolean getCanRead() {
        return this.wrappedFile.canRead();
    }

    @Override
    public boolean getCanWrite() {
        return this.wrappedFile.canWrite();
    }

    @Override
    public boolean getExists() {
        return this.wrappedFile.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.wrappedFile.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.wrappedFile.isFile();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public long getLastModified() {
        return this.wrappedFile.lastModified();
    }

    @Override
    public long getLength() {
        return this.wrappedFile.length();
    }

    @Override
    public long getTotalSpace() {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    public long getFreeSpace() {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    public long getUsableSpace() {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    public boolean createNewFile() {
        return true;
    }

    @Override
    public boolean delete() {
        return this.wrappedFile.delete();
    }

    @Override
    public void deleteOnExit() {
        throw new IllegalStateException("Not Supported");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String[] list() {
        void $this$mapTo$iv$iv;
        DocumentFile[] documentFileArray = this.wrappedFile.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)documentFileArray, (String)"listFiles(...)");
        Object[] $this$map$iv = documentFileArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DocumentFile documentFile = (DocumentFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            if (string == null) {
                String string2 = it.getUri().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            collection.add(string);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String[] list(@NotNull Function2<? super IPlatformFile, ? super String, Boolean> filter) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        DocumentFile[] documentFileArray = this.wrappedFile.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)documentFileArray, (String)"listFiles(...)");
        Object[] $this$filter$iv = documentFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (DocumentFile element$iv$iv : $this$filterTo$iv$iv) {
            DocumentFile it = element$iv$iv;
            boolean bl = false;
            DocumentFile documentFile = it.getParentFile();
            Intrinsics.checkNotNull((Object)documentFile);
            PlatformUriFile platformUriFile = new PlatformUriFile(this.context, documentFile);
            String string = it.getName();
            if (string == null) {
                String string2 = it.getUri().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            if (!((Boolean)filter.invoke((Object)platformUriFile, (Object)string)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DocumentFile element$iv$iv;
            element$iv$iv = (DocumentFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            if (string == null) {
                String string3 = it.getUri().toString();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            }
            collection.add(string);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IPlatformFile[] listFiles() {
        void $this$mapTo$iv$iv;
        DocumentFile[] documentFileArray = this.wrappedFile.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)documentFileArray, (String)"listFiles(...)");
        Object[] $this$map$iv = documentFileArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DocumentFile documentFile = (DocumentFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new PlatformUriFile(this.context, (DocumentFile)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new IPlatformFile[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IPlatformFile[] listFiles(@NotNull Function2<? super IPlatformFile, ? super String, Boolean> filter) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        DocumentFile[] documentFileArray = this.wrappedFile.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)documentFileArray, (String)"listFiles(...)");
        Object[] $this$filter$iv = documentFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (DocumentFile element$iv$iv : $this$filterTo$iv$iv) {
            DocumentFile it = element$iv$iv;
            boolean bl = false;
            DocumentFile documentFile = it.getParentFile();
            Intrinsics.checkNotNull((Object)documentFile);
            PlatformUriFile platformUriFile = new PlatformUriFile(this.context, documentFile);
            String string = it.getName();
            if (string == null) {
                String string2 = it.getUri().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            if (!((Boolean)filter.invoke((Object)platformUriFile, (Object)string)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DocumentFile element$iv$iv;
            element$iv$iv = (DocumentFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new PlatformUriFile(this.context, (DocumentFile)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new IPlatformFile[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IPlatformFile[] listFiles(@NotNull Function1<? super IPlatformFile, Boolean> filter) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        DocumentFile[] documentFileArray = this.wrappedFile.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)documentFileArray, (String)"listFiles(...)");
        Object[] $this$filter$iv = documentFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (DocumentFile element$iv$iv : $this$filterTo$iv$iv) {
            DocumentFile it = element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!((Boolean)filter.invoke((Object)new PlatformUriFile(this.context, it))).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DocumentFile element$iv$iv;
            element$iv$iv = (DocumentFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new PlatformUriFile(this.context, (DocumentFile)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new IPlatformFile[0]);
    }

    @Override
    public boolean mkdir() {
        return true;
    }

    @Override
    public boolean mkdirs() {
        return true;
    }

    @Override
    public boolean renameTo(@NotNull IPlatformFile dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        return this.wrappedFile.renameTo(dest.getName());
    }

    @Override
    public boolean setLastModified(long time) {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    public boolean setReadOnly() {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    public boolean setWritable(boolean writable) {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    public boolean setReadable(boolean readable) {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    public boolean setExecutable(boolean executable) {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    public boolean canExecute() {
        throw new IllegalStateException("Not Supported");
    }

    @Override
    @Nullable
    public Sink openOutputStream(boolean append) {
        OutputStream outputStream = this.context.getContentResolver().openOutputStream(this.wrappedFile.getUri(), "w" + (append ? "a" : ""));
        return outputStream != null && (outputStream = JvmCoreKt.asSink((OutputStream)outputStream)) != null ? CoreKt.buffered((RawSink)outputStream) : null;
    }

    @Override
    @Nullable
    public Source openInputStream() {
        InputStream inputStream = this.context.getContentResolver().openInputStream(this.wrappedFile.getUri());
        return inputStream != null && (inputStream = JvmCoreKt.asSource((InputStream)inputStream)) != null ? CoreKt.buffered((RawSource)inputStream) : null;
    }

    @Override
    @Nullable
    public IPlatformFile child(@NotNull String childName, boolean isDirectory, @NotNull String mimeType) {
        IPlatformFile iPlatformFile;
        Intrinsics.checkNotNullParameter((Object)childName, (String)"childName");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        if (this.isDirectory()) {
            PlatformUriFile platformUriFile;
            if (isDirectory) {
                DocumentFile documentFile = this.wrappedFile.findFile(childName);
                if (documentFile == null) {
                    documentFile = this.wrappedFile.createDirectory(childName);
                }
                if (documentFile != null) {
                    DocumentFile it = documentFile;
                    boolean bl = false;
                    platformUriFile = new PlatformUriFile(this.context, it);
                } else {
                    platformUriFile = null;
                }
            } else {
                DocumentFile documentFile = this.wrappedFile.findFile(childName);
                if (documentFile == null) {
                    documentFile = this.wrappedFile.createFile(mimeType, childName);
                }
                if (documentFile != null) {
                    DocumentFile it = documentFile;
                    boolean bl = false;
                    platformUriFile = new PlatformUriFile(this.context, it);
                } else {
                    platformUriFile = null;
                }
            }
            iPlatformFile = platformUriFile;
        } else {
            iPlatformFile = null;
        }
        return iPlatformFile;
    }

    @Override
    public int compareTo(@NotNull IPlatformFile other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof PlatformUriFile)) {
            return -1;
        }
        return this.wrappedFile.getUri().compareTo(((PlatformUriFile)other).wrappedFile.getUri());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof PlatformUriFile && Intrinsics.areEqual((Object)this.wrappedFile.getUri(), (Object)((PlatformUriFile)other).wrappedFile.getUri());
    }

    @Override
    public int hashCode() {
        return this.wrappedFile.getUri().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return IPlatformFileKt.stringify(this);
    }
}

