/*
 * Decompiled with CFR 0.152.
 */
package dev.zwander.kotlin.file.attribute;

import dev.zwander.kotlin.file.attribute.FileAttribute;
import dev.zwander.kotlin.file.attribute.PosixFilePermission;
import dev.zwander.kotlin.file.attribute.PosixFilePermissionKt;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aJ\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0019\u001a\u00020\u0018J\"\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0%2\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aJ\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010'\u001a\u00020\u0005J\u0014\u0010(\u001a\u00020\u00052\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldev/zwander/kotlin/file/attribute/PosixFilePermissions;", "", "<init>", "()V", "OWNER_READ_FILEMODE", "", "OWNER_WRITE_FILEMODE", "OWNER_EXEC_FILEMODE", "GROUP_READ_FILEMODE", "GROUP_WRITE_FILEMODE", "GROUP_EXEC_FILEMODE", "OTHERS_READ_FILEMODE", "OTHERS_WRITE_FILEMODE", "OTHERS_EXEC_FILEMODE", "writeBits", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "r", "", "w", "x", "toString", "", "perms", "", "Ldev/zwander/kotlin/file/attribute/PosixFilePermission;", "isSet", "c", "", "setValue", "isR", "isW", "isX", "fromString", "asFileAttribute", "Ldev/zwander/kotlin/file/attribute/FileAttribute;", "posixFilePermissions", "mode", "toOctalFileMode", "permissions", "library_release"})
@SourceDebugExtension(value={"SMAP\nPosixFilePermissions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PosixFilePermissions.kt\ndev/zwander/kotlin/file/attribute/PosixFilePermissions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1#2:200\n1755#3,3:201\n*S KotlinDebug\n*F\n+ 1 PosixFilePermissions.kt\ndev/zwander/kotlin/file/attribute/PosixFilePermissions\n*L\n154#1:201,3\n*E\n"})
public final class PosixFilePermissions {
    @NotNull
    public static final PosixFilePermissions INSTANCE = new PosixFilePermissions();
    public static final int OWNER_READ_FILEMODE = 256;
    public static final int OWNER_WRITE_FILEMODE = 128;
    public static final int OWNER_EXEC_FILEMODE = 64;
    public static final int GROUP_READ_FILEMODE = 32;
    public static final int GROUP_WRITE_FILEMODE = 16;
    public static final int GROUP_EXEC_FILEMODE = 8;
    public static final int OTHERS_READ_FILEMODE = 4;
    public static final int OTHERS_WRITE_FILEMODE = 2;
    public static final int OTHERS_EXEC_FILEMODE = 1;

    private PosixFilePermissions() {
    }

    private final void writeBits(StringBuilder sb, boolean r, boolean w, boolean x) {
        StringBuilder stringBuilder = r ? sb.append('r') : sb.append('-');
        StringBuilder stringBuilder2 = w ? sb.append('w') : sb.append('-');
        StringBuilder stringBuilder3 = x ? sb.append('x') : sb.append('-');
    }

    @NotNull
    public final String toString(@NotNull Set<? extends PosixFilePermission> perms) {
        Intrinsics.checkNotNullParameter(perms, (String)"perms");
        StringBuilder sb = new StringBuilder(9);
        this.writeBits(sb, perms.contains((Object)PosixFilePermission.OWNER_READ), perms.contains((Object)PosixFilePermission.OWNER_WRITE), perms.contains((Object)PosixFilePermission.OWNER_EXECUTE));
        this.writeBits(sb, perms.contains((Object)PosixFilePermission.GROUP_READ), perms.contains((Object)PosixFilePermission.GROUP_WRITE), perms.contains((Object)PosixFilePermission.GROUP_EXECUTE));
        this.writeBits(sb, perms.contains((Object)PosixFilePermission.OTHERS_READ), perms.contains((Object)PosixFilePermission.OTHERS_WRITE), perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE));
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean isSet(char c, char setValue) {
        if (c == setValue) {
            return true;
        }
        if (c == '-') {
            return false;
        }
        throw new IllegalArgumentException("Invalid mode");
    }

    private final boolean isR(char c) {
        return this.isSet(c, 'r');
    }

    private final boolean isW(char c) {
        return this.isSet(c, 'w');
    }

    private final boolean isX(char c) {
        return this.isSet(c, 'x');
    }

    @NotNull
    public final Set<PosixFilePermission> fromString(@NotNull String perms) {
        Intrinsics.checkNotNullParameter((Object)perms, (String)"perms");
        if (!(perms.length() == 9)) {
            boolean bl = false;
            String string = "Invalid mode";
            throw new IllegalArgumentException(string.toString());
        }
        Set result = new LinkedHashSet();
        if (this.isR(perms.charAt(0))) {
            result.add(PosixFilePermission.OWNER_READ);
        }
        if (this.isW(perms.charAt(1))) {
            result.add(PosixFilePermission.OWNER_WRITE);
        }
        if (this.isX(perms.charAt(2))) {
            result.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if (this.isR(perms.charAt(3))) {
            result.add(PosixFilePermission.GROUP_READ);
        }
        if (this.isW(perms.charAt(4))) {
            result.add(PosixFilePermission.GROUP_WRITE);
        }
        if (this.isX(perms.charAt(5))) {
            result.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if (this.isR(perms.charAt(6))) {
            result.add(PosixFilePermission.OTHERS_READ);
        }
        if (this.isW(perms.charAt(7))) {
            result.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (this.isX(perms.charAt(8))) {
            result.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return result;
    }

    @NotNull
    public final FileAttribute<Set<PosixFilePermission>> asFileAttribute(@NotNull Set<? extends PosixFilePermission> perms) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(perms, (String)"perms");
            Iterable $this$any$iv = perms;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PosixFilePermission it = (PosixFilePermission)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new NullPointerException();
        }
        Set value = new HashSet(CollectionsKt.filterNotNull((Iterable)perms));
        return new FileAttribute<Set<? extends PosixFilePermission>>((Set<? extends PosixFilePermission>)value){
            final /* synthetic */ Set<PosixFilePermission> $value;
            {
                this.$value = $value;
            }

            public String name() {
                return "posix:permissions";
            }

            public Set<PosixFilePermission> value() {
                return CollectionsKt.toSet((Iterable)this.$value);
            }
        };
    }

    @NotNull
    public final Set<PosixFilePermission> posixFilePermissions(int mode) {
        int mask = 1;
        Set perms = new LinkedHashSet();
        for (PosixFilePermission flag : PosixFilePermissionKt.getPosixFilePermissionReverse()) {
            if ((mask & mode) != 0) {
                perms.add(flag);
            }
            mask <<= 1;
        }
        return perms;
    }

    public final int toOctalFileMode(@NotNull Set<? extends PosixFilePermission> permissions) {
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        int result = 0;
        for (PosixFilePermission posixFilePermission : permissions) {
            result = switch (WhenMappings.$EnumSwitchMapping$0[posixFilePermission.ordinal()]) {
                case 1 -> result | 0x100;
                case 2 -> result | 0x80;
                case 3 -> result | 0x40;
                case 4 -> result | 0x20;
                case 5 -> result | 0x10;
                case 6 -> result | 8;
                case 7 -> result | 4;
                case 8 -> result | 2;
                case 9 -> result | 1;
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        return result;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PosixFilePermission.values().length];
            try {
                nArray[PosixFilePermission.OWNER_READ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.OWNER_WRITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.OWNER_EXECUTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.GROUP_READ.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.GROUP_WRITE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.GROUP_EXECUTE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.OTHERS_READ.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.OTHERS_WRITE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PosixFilePermission.OTHERS_EXECUTE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

