/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing;

import digital.pragmatech.testing.TestStatus;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class TestExecutionTracker {
    private final Map<String, TestClassMetrics> classMetrics = new ConcurrentHashMap<String, TestClassMetrics>();
    private final AtomicInteger totalTestClasses = new AtomicInteger(0);
    private final AtomicInteger totalTestMethods = new AtomicInteger(0);
    private Instant overallStartTime;
    private Instant overallEndTime;

    public void startTracking() {
        this.overallStartTime = Instant.now();
    }

    public void stopTracking() {
        this.overallEndTime = Instant.now();
    }

    public void recordTestClassStart(String className) {
        this.classMetrics.computeIfAbsent(className, k -> {
            this.totalTestClasses.incrementAndGet();
            return new TestClassMetrics(className);
        }).recordStart();
    }

    public void recordTestClassEnd(String className) {
        TestClassMetrics metrics = this.classMetrics.get(className);
        if (metrics != null) {
            metrics.recordEnd();
        }
    }

    public void recordTestMethodStart(String className, String methodName) {
        TestClassMetrics metrics = this.classMetrics.get(className);
        if (metrics != null) {
            metrics.recordMethodStart(methodName);
            this.totalTestMethods.incrementAndGet();
        }
    }

    public void recordTestMethodEnd(String className, String methodName, TestStatus status) {
        TestClassMetrics metrics = this.classMetrics.get(className);
        if (metrics != null) {
            metrics.recordMethodEnd(methodName, status);
        }
    }

    public Map<String, TestClassMetrics> getClassMetrics() {
        return Collections.unmodifiableMap(this.classMetrics);
    }

    public int getTotalTestClasses() {
        return this.totalTestClasses.get();
    }

    public int getTotalTestMethods() {
        return this.totalTestMethods.get();
    }

    public Duration getOverallDuration() {
        if (this.overallStartTime != null && this.overallEndTime != null) {
            return Duration.between(this.overallStartTime, this.overallEndTime);
        }
        return Duration.ZERO;
    }

    public static class TestClassMetrics {
        private final String className;
        private final Map<String, TestMethodMetrics> methodMetrics = new ConcurrentHashMap<String, TestMethodMetrics>();
        private Instant startTime;
        private Instant endTime;

        public TestClassMetrics(String className) {
            this.className = className;
        }

        public void recordStart() {
            this.startTime = Instant.now();
        }

        public void recordEnd() {
            this.endTime = Instant.now();
        }

        public void recordMethodStart(String methodName) {
            this.methodMetrics.computeIfAbsent(methodName, TestMethodMetrics::new).recordStart();
        }

        public void recordMethodEnd(String methodName, TestStatus status) {
            TestMethodMetrics metrics = this.methodMetrics.get(methodName);
            if (metrics != null) {
                metrics.recordEnd(status);
            }
        }

        public String getClassName() {
            return this.className;
        }

        public Duration getDuration() {
            if (this.startTime != null && this.endTime != null) {
                return Duration.between(this.startTime, this.endTime);
            }
            return Duration.ZERO;
        }

        public Map<String, TestMethodMetrics> getMethodMetrics() {
            return Collections.unmodifiableMap(this.methodMetrics);
        }

        public int getTotalMethods() {
            return this.methodMetrics.size();
        }

        public long getPassedMethods() {
            return this.methodMetrics.values().stream().filter(m -> m.getStatus() == TestStatus.PASSED).count();
        }

        public long getFailedMethods() {
            return this.methodMetrics.values().stream().filter(m -> m.getStatus() == TestStatus.FAILED).count();
        }
    }

    public static class TestMethodMetrics {
        private final String methodName;
        private Instant startTime;
        private Instant endTime;
        private TestStatus status;

        public TestMethodMetrics(String methodName) {
            this.methodName = methodName;
        }

        public void recordStart() {
            this.startTime = Instant.now();
        }

        public void recordEnd(TestStatus status) {
            this.endTime = Instant.now();
            this.status = status;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Duration getDuration() {
            if (this.startTime != null && this.endTime != null) {
                return Duration.between(this.startTime, this.endTime);
            }
            return Duration.ZERO;
        }

        public TestStatus getStatus() {
            return this.status;
        }
    }
}

