/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing.reporting;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import digital.pragmatech.testing.ContextCacheEntry;
import digital.pragmatech.testing.ContextCacheTracker;
import digital.pragmatech.testing.ContextIdGenerator;
import digital.pragmatech.testing.SpringContextStatistics;
import digital.pragmatech.testing.TestExecutionTracker;
import digital.pragmatech.testing.TestStatus;
import digital.pragmatech.testing.TimelineData;
import digital.pragmatech.testing.reporting.TestClassExecutionData;
import digital.pragmatech.testing.reporting.TestExecutionData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.test.context.MergedContextConfiguration;

public class TemplateHelpers {
    public static long countTestsByStatus(Map<String, TestExecutionTracker.TestClassMetrics> classMetrics, String statusName) {
        TestStatus status = TestStatus.valueOf(statusName);
        return classMetrics.values().stream().flatMap(classMetric -> classMetric.getMethodMetrics().values().stream()).filter(methodMetric -> methodMetric.getStatus() == status).count();
    }

    public String getContextId(Object configuration) {
        if (configuration instanceof MergedContextConfiguration) {
            return ContextIdGenerator.getContextId((MergedContextConfiguration)configuration);
        }
        return "context-unknown";
    }

    public static class JsonHelper {
        private static final ObjectMapper objectMapper = JsonHelper.createObjectMapper();

        private static ObjectMapper createObjectMapper() {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            return mapper;
        }

        public String toJson(Object object) {
            try {
                return objectMapper.writeValueAsString(object);
            }
            catch (Exception e) {
                return "[]";
            }
        }

        public String timelineEventsToJson(TimelineData timelineData) {
            if (timelineData == null || timelineData.events() == null) {
                return "[]";
            }
            return this.toJson(timelineData.events());
        }

        public String contextStatisticsToJson(ContextCacheTracker contextCacheTracker) {
            if (contextCacheTracker == null) {
                return "[]";
            }
            List contextStatistics = contextCacheTracker.getAllEntries().stream().filter(ContextCacheEntry::isCreated).map(this::mapContextEntryToStatistics).collect(Collectors.toList());
            return this.toJson(contextStatistics);
        }

        private Map<String, Object> mapContextEntryToStatistics(ContextCacheEntry entry) {
            HashMap<String, Object> statistics = new HashMap<String, Object>();
            String contextKey = ContextIdGenerator.getContextId(entry.getConfiguration());
            statistics.put("contextKey", contextKey);
            statistics.put("loadDuration", entry.getContextLoadTimeMs());
            statistics.put("initialLoadTime", entry.getCreationTime() != null ? Long.valueOf(entry.getCreationTime().getEpochSecond()) : null);
            statistics.put("lastUsedTime", entry.getLastUsedTime() != null ? Long.valueOf(entry.getLastUsedTime().getEpochSecond()) : null);
            statistics.put("numberOfBeans", entry.getBeanDefinitionCount());
            statistics.put("testClasses", new ArrayList<String>(entry.getTestClasses()));
            statistics.put("testMethods", this.getTestMethodsForContext(entry));
            statistics.put("contextConfiguration", this.mapContextConfiguration(entry));
            return statistics;
        }

        private List<String> getTestMethodsForContext(ContextCacheEntry entry) {
            return new ArrayList<String>(entry.getTestMethods());
        }

        private Map<String, Object> mapContextConfiguration(ContextCacheEntry entry) {
            HashMap<String, Object> config = new HashMap<String, Object>();
            if (entry.getConfiguration() != null) {
                MergedContextConfiguration mergedConfig = entry.getConfiguration();
                config.put("testClass", entry.getTestClasses().isEmpty() ? null : entry.getTestClasses().iterator().next());
                config.put("locations", Arrays.asList(mergedConfig.getLocations()));
                config.put("classes", Arrays.stream(mergedConfig.getClasses()).map(Class::getName).collect(Collectors.toList()));
                config.put("contextInitializerClasses", mergedConfig.getContextInitializerClasses().stream().map(Class::getName).collect(Collectors.toList()));
                config.put("activeProfiles", Arrays.asList(mergedConfig.getActiveProfiles()));
                config.put("propertySourceLocations", Arrays.asList(mergedConfig.getPropertySourceLocations()));
                config.put("propertySourceProperties", Arrays.asList(mergedConfig.getPropertySourceProperties()));
                config.put("contextCustomizers", mergedConfig.getContextCustomizers().stream().map(customizer -> customizer.getClass().getName()).collect(Collectors.toList()));
                config.put("contextLoader", mergedConfig.getContextLoader() != null ? mergedConfig.getContextLoader().getClass().getName() : null);
                config.put("parent", mergedConfig.getParent() != null ? ContextIdGenerator.getContextId(mergedConfig.getParent()) : null);
            }
            return config;
        }
    }

    public static class CacheKeyProcessor {
        public Map<String, Set<String>> aggregateCacheKeys(List<TestClassExecutionData> testClassData) {
            HashMap<String, Set<String>> allCacheKeys = new HashMap<String, Set<String>>();
            for (TestClassExecutionData classData : testClassData) {
                SpringContextStatistics stats = classData.contextStatistics();
                if (stats == null) continue;
                Map<String, Set<String>> classCacheKeys = stats.getCacheKeyToTestClasses();
                for (Map.Entry<String, Set<String>> entry : classCacheKeys.entrySet()) {
                    String cacheKey = entry.getKey();
                    allCacheKeys.computeIfAbsent(cacheKey, k -> new HashSet()).add(classData.className());
                }
            }
            return allCacheKeys;
        }

        public Map<String, SpringContextStatistics.CacheKeyInfo> aggregateCacheKeyInfo(List<TestClassExecutionData> testClassData) {
            HashMap<String, SpringContextStatistics.CacheKeyInfo> allCacheKeyInfo = new HashMap<String, SpringContextStatistics.CacheKeyInfo>();
            for (TestClassExecutionData classData : testClassData) {
                SpringContextStatistics stats = classData.contextStatistics();
                if (stats == null) continue;
                Map<String, SpringContextStatistics.CacheKeyInfo> classCacheKeyInfo = stats.getCacheKeyInfoMap();
                for (Map.Entry<String, SpringContextStatistics.CacheKeyInfo> entry : classCacheKeyInfo.entrySet()) {
                    int i;
                    String cacheKey = entry.getKey();
                    SpringContextStatistics.CacheKeyInfo info = entry.getValue();
                    SpringContextStatistics.CacheKeyInfo existing = (SpringContextStatistics.CacheKeyInfo)allCacheKeyInfo.get(cacheKey);
                    if (existing == null) {
                        allCacheKeyInfo.put(cacheKey, new SpringContextStatistics.CacheKeyInfo(cacheKey));
                        existing = (SpringContextStatistics.CacheKeyInfo)allCacheKeyInfo.get(cacheKey);
                    }
                    for (i = 0; i < info.getHits(); ++i) {
                        existing.incrementHits();
                    }
                    for (i = 0; i < info.getMisses(); ++i) {
                        existing.incrementMisses();
                    }
                }
            }
            return allCacheKeyInfo;
        }
    }

    public static class ConfigurationHelper {
        private final ContextCacheTracker contextCacheTracker;

        public ConfigurationHelper(ContextCacheTracker contextCacheTracker) {
            this.contextCacheTracker = contextCacheTracker;
        }

        public Map<String, ContextConfigurationInfo> getConfigurations() {
            HashMap<String, ContextConfigurationInfo> configurations = new HashMap<String, ContextConfigurationInfo>();
            if (this.contextCacheTracker != null) {
                for (ContextCacheEntry entry : this.contextCacheTracker.getAllEntries()) {
                    String configId = ContextIdGenerator.getContextId(entry.getConfiguration()).replace("context-", "config-");
                    ContextConfigurationInfo configInfo = new ContextConfigurationInfo();
                    configInfo.id = configId;
                    configInfo.testClasses = new HashSet<String>(entry.getTestClasses());
                    configInfo.configuration = entry.getConfigurationSummary();
                    configurations.put(configId, configInfo);
                }
            }
            return configurations;
        }

        public static class ContextConfigurationInfo {
            public String id;
            public Set<String> testClasses;
            public Map<String, Object> configuration;
        }
    }

    public static class SummaryCalculator {
        public long getTotalTests(List<TestClassExecutionData> testClassData) {
            return testClassData.stream().mapToLong(TestClassExecutionData::getTotalTests).sum();
        }

        public long getPassedTests(List<TestClassExecutionData> testClassData) {
            return testClassData.stream().mapToLong(TestClassExecutionData::getPassedTests).sum();
        }

        public long getFailedTests(List<TestClassExecutionData> testClassData) {
            return testClassData.stream().mapToLong(TestClassExecutionData::getFailedTests).sum();
        }

        public long getDisabledTests(List<TestClassExecutionData> testClassData) {
            return testClassData.stream().mapToLong(TestClassExecutionData::getDisabledTests).sum();
        }

        public long getAbortedTests(List<TestClassExecutionData> testClassData) {
            return testClassData.stream().mapToLong(TestClassExecutionData::getAbortedTests).sum();
        }

        public long getTotalExecutionTime(List<TestClassExecutionData> testClassData) {
            return testClassData.stream().flatMap(classData -> classData.testExecutions().values().stream()).filter(testData -> testData.getDuration() != null).mapToLong(testData -> testData.getDuration().toMillis()).sum();
        }

        public long getClassExecutionTime(TestClassExecutionData classData) {
            return classData.testExecutions().values().stream().filter(testData -> testData.getDuration() != null).mapToLong(testData -> testData.getDuration().toMillis()).sum();
        }
    }

    public static class ClassNameComparator
    implements Comparator<TestClassExecutionData> {
        @Override
        public int compare(TestClassExecutionData a, TestClassExecutionData b) {
            return a.className().compareTo(b.className());
        }
    }

    public static class TestClassSorter {
        public List<TestClassExecutionData> sortTestClasses(List<TestClassExecutionData> testClasses) {
            return testClasses.stream().sorted((a, b) -> a.className().compareTo(b.className())).collect(Collectors.toList());
        }
    }

    public static class TestMethodSorter {
        public List<TestExecutionData> sortTestMethods(Collection<TestExecutionData> testMethods) {
            return testMethods.stream().sorted((a, b) -> {
                if (a.getStatus() == TestStatus.FAILED && b.getStatus() != TestStatus.FAILED) {
                    return -1;
                }
                if (b.getStatus() == TestStatus.FAILED && a.getStatus() != TestStatus.FAILED) {
                    return 1;
                }
                return a.getTestMethodName().compareTo(b.getTestMethodName());
            }).collect(Collectors.toList());
        }
    }

    public static class ErrorFormatter {
        public String formatError(Throwable throwable) {
            StackTraceElement[] stackTrace;
            if (throwable == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(throwable.getClass().getSimpleName()).append(": ");
            if (throwable.getMessage() != null) {
                sb.append(throwable.getMessage());
            }
            if ((stackTrace = throwable.getStackTrace()).length > 0) {
                sb.append("\n\nStack trace (first 5 lines):");
                for (int i = 0; i < Math.min(5, stackTrace.length); ++i) {
                    sb.append("\n  at ").append(stackTrace[i].toString());
                }
                if (stackTrace.length > 5) {
                    sb.append("\n  ... ").append(stackTrace.length - 5).append(" more");
                }
            }
            return sb.toString();
        }
    }

    public static class StatusIconHelper {
        public String getStatusIcon(TestStatus status) {
            if (status == null) {
                return "\u2753";
            }
            return switch (status) {
                default -> throw new IncompatibleClassChangeError();
                case TestStatus.PASSED -> "\u2705";
                case TestStatus.FAILED -> "\u274c";
                case TestStatus.DISABLED -> "\u23f8\ufe0f";
                case TestStatus.ABORTED -> "\u26a0\ufe0f";
                case TestStatus.RUNNING -> "\ud83d\udd04";
                case TestStatus.PENDING -> "\u23f3";
            };
        }
    }

    public static class StatusColorHelper {
        public String getClassStatusColor(TestClassExecutionData classData) {
            if (classData.getFailedTests() > 0L) {
                return "#e74c3c";
            }
            if (classData.getAbortedTests() > 0L) {
                return "#f39c12";
            }
            if (classData.getDisabledTests() > 0L && classData.getPassedTests() == 0L) {
                return "#95a5a6";
            }
            return "#27ae60";
        }
    }

    public static class ClassNameHelper {
        public String getSimpleClassName(String fullClassName) {
            int lastDot = fullClassName.lastIndexOf(46);
            return lastDot >= 0 ? fullClassName.substring(lastDot + 1) : fullClassName;
        }

        public String getPackageName(String fullClassName) {
            int lastDot = fullClassName.lastIndexOf(46);
            return lastDot >= 0 ? fullClassName.substring(0, lastDot) : "";
        }
    }

    public static class DurationFormatter {
        public String format(long millis) {
            if (millis < 1000L) {
                return millis + "ms";
            }
            if (millis < 60000L) {
                return String.format("%.1fs", (double)millis / 1000.0);
            }
            return String.format("%.1fm", (double)millis / 60000.0);
        }
    }

    public static class TestStatusCounter {
        public long countTestsByStatus(Map<String, TestExecutionTracker.TestClassMetrics> classMetrics, String statusName) {
            return TemplateHelpers.countTestsByStatus(classMetrics, statusName);
        }
    }
}

