/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing.reporting.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import digital.pragmatech.testing.ContextCacheTracker;
import digital.pragmatech.testing.SpringContextCacheAccessor;
import digital.pragmatech.testing.TestExecutionTracker;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReportGenerator {
    private static final Logger logger = LoggerFactory.getLogger(JsonReportGenerator.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonReportGenerator() {
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public void generateJsonReport(Path reportDir, TestExecutionTracker executionTracker, SpringContextCacheAccessor.CacheStatistics cacheStats, ContextCacheTracker contextCacheTracker) {
        try {
            Files.createDirectories(reportDir, new FileAttribute[0]);
            String uniqueId = UUID.randomUUID().toString();
            String jsonFileName = String.format("spring-test-profiler-%s.json", uniqueId);
            Path jsonFile = reportDir.resolve(jsonFileName);
            ReportData reportData = new ReportData(executionTracker, cacheStats, contextCacheTracker);
            this.objectMapper.writeValue(jsonFile.toFile(), (Object)reportData);
            logger.info("Successfully generated JSON report: {}", (Object)jsonFile.toAbsolutePath());
        }
        catch (IOException e) {
            logger.error("Failed to generate JSON report", (Throwable)e);
        }
    }

    private record ReportData(TestExecutionTracker executionTracker, SpringContextCacheAccessor.CacheStatistics cacheStats, ContextCacheTracker contextCacheTracker) {
    }
}

