/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class BeanCreationProfiler
implements BeanPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BeanCreationProfiler.class);
    private final String contextId;
    private final Map<String, BeanCreationMetric> beanMetrics = new ConcurrentHashMap<String, BeanCreationMetric>();
    private final Map<String, Instant> beanStartTimes = new ConcurrentHashMap<String, Instant>();
    private final AtomicLong beanCreationOrder = new AtomicLong(0L);
    private final AtomicLong totalBeansCreated = new AtomicLong(0L);
    private final AtomicLong totalCreationTimeMs = new AtomicLong(0L);
    private volatile long slowestBeanTimeMs = 0L;
    private volatile String slowestBeanName = null;

    public BeanCreationProfiler(String contextId) {
        this.contextId = contextId;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.beanStartTimes.put(beanName, Instant.now());
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Instant endTime = Instant.now();
        Instant startTime = this.beanStartTimes.remove(beanName);
        if (startTime != null) {
            long creationTimeMs = Duration.between(startTime, endTime).toMillis();
            long order = this.beanCreationOrder.incrementAndGet();
            BeanCreationMetric metric = new BeanCreationMetric(beanName, bean.getClass().getName(), startTime, endTime, creationTimeMs, order);
            this.beanMetrics.put(beanName, metric);
            this.totalBeansCreated.incrementAndGet();
            this.totalCreationTimeMs.addAndGet(creationTimeMs);
            if (creationTimeMs > this.slowestBeanTimeMs) {
                this.slowestBeanTimeMs = creationTimeMs;
                this.slowestBeanName = beanName;
            }
            if (creationTimeMs > 100L) {
                logger.debug("Slow bean creation: {} took {}ms (order: {})", new Object[]{beanName, creationTimeMs, order});
            }
        }
        return bean;
    }

    public BeanCreationMetrics getMetrics() {
        return new BeanCreationMetrics(this.contextId, this.totalBeansCreated.get(), this.totalCreationTimeMs.get(), this.slowestBeanName, this.slowestBeanTimeMs, new ArrayList<BeanCreationMetric>(this.beanMetrics.values()));
    }

    public BeanCreationMetric getBeanMetric(String beanName) {
        return this.beanMetrics.get(beanName);
    }

    public List<BeanCreationMetric> getSlowestBeans(int limit) {
        return this.beanMetrics.values().stream().sorted((a, b) -> Long.compare(b.getCreationTimeMs(), a.getCreationTimeMs())).limit(limit).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static class BeanCreationMetric {
        private final String beanName;
        private final String beanClass;
        private final Instant startTime;
        private final Instant endTime;
        private final long creationTimeMs;
        private final long creationOrder;

        public BeanCreationMetric(String beanName, String beanClass, Instant startTime, Instant endTime, long creationTimeMs, long creationOrder) {
            this.beanName = beanName;
            this.beanClass = beanClass;
            this.startTime = startTime;
            this.endTime = endTime;
            this.creationTimeMs = creationTimeMs;
            this.creationOrder = creationOrder;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public String getBeanClass() {
            return this.beanClass;
        }

        public Instant getStartTime() {
            return this.startTime;
        }

        public Instant getEndTime() {
            return this.endTime;
        }

        public long getCreationTimeMs() {
            return this.creationTimeMs;
        }

        public long getCreationOrder() {
            return this.creationOrder;
        }
    }

    public static class BeanCreationMetrics {
        private final String contextId;
        private final long totalBeansCreated;
        private final long totalCreationTimeMs;
        private final String slowestBeanName;
        private final long slowestBeanTimeMs;
        private final List<BeanCreationMetric> allBeans;

        public BeanCreationMetrics(String contextId, long totalBeansCreated, long totalCreationTimeMs, String slowestBeanName, long slowestBeanTimeMs, List<BeanCreationMetric> allBeans) {
            this.contextId = contextId;
            this.totalBeansCreated = totalBeansCreated;
            this.totalCreationTimeMs = totalCreationTimeMs;
            this.slowestBeanName = slowestBeanName;
            this.slowestBeanTimeMs = slowestBeanTimeMs;
            this.allBeans = Collections.unmodifiableList(allBeans);
        }

        public String getContextId() {
            return this.contextId;
        }

        public long getTotalBeansCreated() {
            return this.totalBeansCreated;
        }

        public long getTotalCreationTimeMs() {
            return this.totalCreationTimeMs;
        }

        public String getSlowestBeanName() {
            return this.slowestBeanName;
        }

        public long getSlowestBeanTimeMs() {
            return this.slowestBeanTimeMs;
        }

        public List<BeanCreationMetric> getAllBeans() {
            return this.allBeans;
        }

        public double getAverageCreationTimeMs() {
            return this.totalBeansCreated > 0L ? (double)this.totalCreationTimeMs / (double)this.totalBeansCreated : 0.0;
        }
    }
}

