/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.test.context.MergedContextConfiguration;

public class ContextCacheEntry {
    private final MergedContextConfiguration configuration;
    private final Set<String> testClasses = ConcurrentHashMap.newKeySet();
    private volatile boolean created = false;
    private volatile Instant creationTime;
    private volatile Instant lastUsedTime;
    private volatile Instant firstUsedTime;
    private final AtomicInteger hitCount = new AtomicInteger(0);
    private volatile MergedContextConfiguration nearestContext;
    private volatile int beanDefinitionCount = 0;
    private volatile Set<String> beanDefinitionNames = ConcurrentHashMap.newKeySet();
    private volatile long contextLoadTimeMs = 0L;
    private final List<Instant> accessTimes = new CopyOnWriteArrayList<Instant>();

    public ContextCacheEntry(MergedContextConfiguration configuration) {
        this.configuration = configuration;
    }

    public void addTestClass(String testClassName) {
        this.testClasses.add(testClassName);
    }

    public void recordCreation() {
        this.recordCreation(0L);
    }

    public void recordCreation(long loadTimeMs) {
        Instant now;
        this.created = true;
        this.contextLoadTimeMs = loadTimeMs;
        this.creationTime = now = Instant.now();
        this.firstUsedTime = now;
        this.lastUsedTime = now;
        this.accessTimes.add(now);
    }

    public void recordCacheHit() {
        Instant now;
        this.hitCount.incrementAndGet();
        this.lastUsedTime = now = Instant.now();
        this.accessTimes.add(now);
        if (this.firstUsedTime == null) {
            this.firstUsedTime = now;
        }
    }

    public void setNearestContext(MergedContextConfiguration nearestContext) {
        this.nearestContext = nearestContext;
    }

    public void setBeanDefinitions(String[] beanNames) {
        this.beanDefinitionCount = beanNames.length;
        this.beanDefinitionNames.clear();
        this.beanDefinitionNames.addAll(Arrays.asList(beanNames));
    }

    public MergedContextConfiguration getConfiguration() {
        return this.configuration;
    }

    public Set<String> getTestClasses() {
        return Collections.unmodifiableSet(this.testClasses);
    }

    public boolean isCreated() {
        return this.created;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getLastUsedTime() {
        return this.lastUsedTime;
    }

    public Instant getFirstUsedTime() {
        return this.firstUsedTime;
    }

    public int getHitCount() {
        return this.hitCount.get();
    }

    public List<Instant> getAccessTimes() {
        return Collections.unmodifiableList(this.accessTimes);
    }

    public long getAgeInMillis() {
        if (this.creationTime == null) {
            return -1L;
        }
        return Duration.between(this.creationTime, Instant.now()).toMillis();
    }

    public long getLifespanInMillis() {
        if (this.firstUsedTime == null || this.lastUsedTime == null) {
            return 0L;
        }
        return Duration.between(this.firstUsedTime, this.lastUsedTime).toMillis();
    }

    public long getTimeSinceLastUseInMillis() {
        if (this.lastUsedTime == null) {
            return -1L;
        }
        return Duration.between(this.lastUsedTime, Instant.now()).toMillis();
    }

    public Optional<MergedContextConfiguration> getNearestContext() {
        return Optional.ofNullable(this.nearestContext);
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionCount;
    }

    public Set<String> getBeanDefinitionNames() {
        return Collections.unmodifiableSet(this.beanDefinitionNames);
    }

    public long getContextLoadTimeMs() {
        return this.contextLoadTimeMs;
    }

    public Map<String, Object> getConfigurationSummary() {
        LinkedHashMap<String, Object> summary = new LinkedHashMap<String, Object>();
        if (this.configuration != null) {
            summary.put("configurationClasses", Arrays.stream(this.configuration.getClasses()).map(Class::getSimpleName).collect(Collectors.toList()));
            summary.put("activeProfiles", Arrays.asList(this.configuration.getActiveProfiles()));
            summary.put("contextLoader", this.configuration.getContextLoader().getClass().getSimpleName());
            summary.put("properties", this.configuration.getPropertySourceProperties().length + " properties");
            summary.put("parentContext", this.configuration.getParent());
            summary.put("contextCustomizers", this.configuration.getContextCustomizers());
            summary.put("locations", String.join((CharSequence)",", this.configuration.getLocations()));
            summary.put("contextInitializers", this.configuration.getContextInitializerClasses().stream().map(Class::getSimpleName).collect(Collectors.toList()));
            summary.put("beanDefinitionCount", this.beanDefinitionCount);
        }
        return summary;
    }
}

