/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing;

import digital.pragmatech.testing.BeanCreationProfiler;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ContextProfileData {
    private final String contextId;
    private final Instant startTime;
    private final long startMemoryBytes;
    private volatile Instant endTime;
    private volatile long endMemoryBytes;
    private volatile long totalLoadTimeMs;
    private volatile long memoryUsedMB;
    private volatile int beanDefinitionCount;
    private volatile BeanCreationProfiler.BeanCreationMetrics beanCreationMetrics;
    private final Map<String, Instant> lifecyclePhases = new ConcurrentHashMap<String, Instant>();
    private final Map<String, Object> metadata = new ConcurrentHashMap<String, Object>();

    public ContextProfileData(String contextId, Instant startTime, long startMemoryBytes) {
        this.contextId = contextId;
        this.startTime = startTime;
        this.startMemoryBytes = startMemoryBytes;
    }

    public void recordPhase(String phaseName, Instant timestamp) {
        this.lifecyclePhases.put(phaseName, timestamp);
    }

    public Instant getPhaseTime(String phaseName) {
        return this.lifecyclePhases.get(phaseName);
    }

    public Map<String, Instant> getAllPhases() {
        return new ConcurrentHashMap<String, Instant>(this.lifecyclePhases);
    }

    public long getPhaseElapsedMs(String phaseName) {
        Instant phaseTime = this.lifecyclePhases.get(phaseName);
        if (phaseTime != null) {
            return Duration.between(this.startTime, phaseTime).toMillis();
        }
        return -1L;
    }

    public long getBeanDefinitionRegistrationTimeMs() {
        return this.getPhaseElapsedMs("BeanDefinitionRegistration");
    }

    public long getContextRefreshTimeMs() {
        return this.getPhaseElapsedMs("ContextRefreshedEvent");
    }

    public void setMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    public Object getMetadata(String key) {
        return this.metadata.get(key);
    }

    public List<BeanCreationProfiler.BeanCreationMetric> getSlowestBeans(int limit) {
        if (this.beanCreationMetrics != null) {
            return this.beanCreationMetrics.getAllBeans().stream().sorted((a, b) -> Long.compare(b.getCreationTimeMs(), a.getCreationTimeMs())).limit(limit).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        }
        return new ArrayList<BeanCreationProfiler.BeanCreationMetric>();
    }

    public double getBeanCreationEfficiency() {
        if (this.beanCreationMetrics != null && this.totalLoadTimeMs > 0L) {
            return (double)this.beanCreationMetrics.getTotalCreationTimeMs() / (double)this.totalLoadTimeMs;
        }
        return 0.0;
    }

    public double getMemoryEfficiencyMBPerBean() {
        if (this.beanCreationMetrics != null && this.beanCreationMetrics.getTotalBeansCreated() > 0L) {
            return (double)this.memoryUsedMB / (double)this.beanCreationMetrics.getTotalBeansCreated();
        }
        return 0.0;
    }

    public ContextProfileSummary getSummary() {
        return new ContextProfileSummary(this.contextId, this.totalLoadTimeMs, this.memoryUsedMB, this.beanDefinitionCount, this.beanCreationMetrics != null ? this.beanCreationMetrics.getTotalBeansCreated() : 0L, this.beanCreationMetrics != null ? this.beanCreationMetrics.getSlowestBeanTimeMs() : 0L, this.beanCreationMetrics != null ? this.beanCreationMetrics.getSlowestBeanName() : null, this.getBeanCreationEfficiency(), this.getMemoryEfficiencyMBPerBean());
    }

    public String getContextId() {
        return this.contextId;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public long getStartMemoryBytes() {
        return this.startMemoryBytes;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Instant endTime) {
        this.endTime = endTime;
    }

    public long getEndMemoryBytes() {
        return this.endMemoryBytes;
    }

    public void setEndMemory(long endMemoryBytes) {
        this.endMemoryBytes = endMemoryBytes;
    }

    public long getTotalLoadTimeMs() {
        return this.totalLoadTimeMs;
    }

    public void setTotalLoadTimeMs(long totalLoadTimeMs) {
        this.totalLoadTimeMs = totalLoadTimeMs;
    }

    public long getMemoryUsedMB() {
        return this.memoryUsedMB;
    }

    public void setMemoryUsedMB(long memoryUsedMB) {
        this.memoryUsedMB = memoryUsedMB;
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionCount;
    }

    public void setBeanDefinitionCount(int beanDefinitionCount) {
        this.beanDefinitionCount = beanDefinitionCount;
    }

    public BeanCreationProfiler.BeanCreationMetrics getBeanCreationMetrics() {
        return this.beanCreationMetrics;
    }

    public void setBeanCreationMetrics(BeanCreationProfiler.BeanCreationMetrics beanCreationMetrics) {
        this.beanCreationMetrics = beanCreationMetrics;
    }

    public static class ContextProfileSummary {
        private final String contextId;
        private final long totalLoadTimeMs;
        private final long memoryUsedMB;
        private final int beanDefinitionCount;
        private final long beansCreated;
        private final long slowestBeanTimeMs;
        private final String slowestBeanName;
        private final double beanCreationEfficiency;
        private final double memoryEfficiencyMBPerBean;

        public ContextProfileSummary(String contextId, long totalLoadTimeMs, long memoryUsedMB, int beanDefinitionCount, long beansCreated, long slowestBeanTimeMs, String slowestBeanName, double beanCreationEfficiency, double memoryEfficiencyMBPerBean) {
            this.contextId = contextId;
            this.totalLoadTimeMs = totalLoadTimeMs;
            this.memoryUsedMB = memoryUsedMB;
            this.beanDefinitionCount = beanDefinitionCount;
            this.beansCreated = beansCreated;
            this.slowestBeanTimeMs = slowestBeanTimeMs;
            this.slowestBeanName = slowestBeanName;
            this.beanCreationEfficiency = beanCreationEfficiency;
            this.memoryEfficiencyMBPerBean = memoryEfficiencyMBPerBean;
        }

        public String getContextId() {
            return this.contextId;
        }

        public long getTotalLoadTimeMs() {
            return this.totalLoadTimeMs;
        }

        public long getMemoryUsedMB() {
            return this.memoryUsedMB;
        }

        public int getBeanDefinitionCount() {
            return this.beanDefinitionCount;
        }

        public long getBeansCreated() {
            return this.beansCreated;
        }

        public long getSlowestBeanTimeMs() {
            return this.slowestBeanTimeMs;
        }

        public String getSlowestBeanName() {
            return this.slowestBeanName;
        }

        public double getBeanCreationEfficiency() {
            return this.beanCreationEfficiency;
        }

        public double getMemoryEfficiencyMBPerBean() {
            return this.memoryEfficiencyMBPerBean;
        }
    }
}

