/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing.reporting.html;

import digital.pragmatech.testing.ContextCacheTracker;
import digital.pragmatech.testing.OptimizationStatistics;
import digital.pragmatech.testing.SpringContextCacheAccessor;
import digital.pragmatech.testing.TestExecutionTracker;
import digital.pragmatech.testing.TimelineData;
import digital.pragmatech.testing.reporting.TemplateHelpers;
import digital.pragmatech.testing.reporting.json.JsonReportGenerator;
import digital.pragmatech.testing.util.BuildToolDetection;
import digital.pragmatech.testing.util.VersionInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class TestExecutionReporter {
    private static final Logger logger = LoggerFactory.getLogger(TestExecutionReporter.class);
    private static final String REPORT_DIR_NAME = "spring-test-profiler";
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
    private final TemplateEngine templateEngine = this.createTemplateEngine();
    private final JsonReportGenerator jsonReportGenerator = new JsonReportGenerator();

    public void generateReport(TestExecutionTracker executionTracker, SpringContextCacheAccessor.CacheStatistics cacheStats, ContextCacheTracker contextCacheTracker) {
        boolean jsonReportingEnabled = Boolean.parseBoolean(System.getProperty("spring.test.insight.json.beta", "false"));
        try {
            BuildToolDetection.BuildTool buildTool = BuildToolDetection.getDetectedBuildTool();
            Path reportDir = this.determineReportDirectory(buildTool);
            Files.createDirectories(reportDir, new FileAttribute[0]);
            if (jsonReportingEnabled) {
                this.jsonReportGenerator.generateJsonReport(reportDir, executionTracker, cacheStats, contextCacheTracker);
            } else {
                String timestamp = LocalDateTime.now().format(TIMESTAMP_FORMATTER);
                String reportFileName = "test-profiler-report-" + timestamp + ".html";
                Path reportFile = reportDir.resolve(reportFileName);
                String htmlContent = this.generateHtmlWithThymeleaf(buildTool.name(), executionTracker, cacheStats, contextCacheTracker);
                Files.write(reportFile, htmlContent.getBytes(), new OpenOption[0]);
                logger.info("Spring Test Profiler report generated for {} build tool: {}", (Object)buildTool.name(), (Object)reportFile.toAbsolutePath());
                Path latestLink = reportDir.resolve("latest.html");
                Files.deleteIfExists(latestLink);
                Files.write(latestLink, htmlContent.getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            logger.error("Failed to generate Spring Test Profiler report", (Throwable)e);
        }
    }

    private Path determineReportDirectory(BuildToolDetection.BuildTool buildTool) {
        String customDir = System.getProperty("pragmatech.spring.test.insight.report.dir");
        if (customDir != null && !customDir.trim().isEmpty()) {
            return Paths.get(customDir, new String[0]);
        }
        return Paths.get(switch (buildTool) {
            case BuildToolDetection.BuildTool.MAVEN -> "target";
            case BuildToolDetection.BuildTool.GRADLE -> "build";
            default -> Files.exists(Paths.get("target", new String[0]), new LinkOption[0]) ? "target" : (Files.exists(Paths.get("build", new String[0]), new LinkOption[0]) ? "build" : ".");
        }, REPORT_DIR_NAME);
    }

    private TemplateEngine createTemplateEngine() {
        TemplateEngine engine = new TemplateEngine();
        ClassLoaderTemplateResolver resolver = new ClassLoaderTemplateResolver();
        resolver.setTemplateMode(TemplateMode.HTML);
        resolver.setPrefix("/templates/");
        resolver.setSuffix(".html");
        resolver.setCacheable(false);
        resolver.setCharacterEncoding("UTF-8");
        engine.setTemplateResolver((ITemplateResolver)resolver);
        return engine;
    }

    private String generateHtmlWithThymeleaf(String buildTool, TestExecutionTracker executionTracker, SpringContextCacheAccessor.CacheStatistics cacheStats, ContextCacheTracker contextCacheTracker) {
        try {
            Context context = new Context();
            context.setVariable("phase", (Object)buildTool);
            context.setVariable("generatedAt", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            context.setVariable("executionTracker", (Object)executionTracker);
            context.setVariable("cacheStats", (Object)cacheStats);
            context.setVariable("contextCacheTracker", (Object)contextCacheTracker);
            context.setVariable("executionEnvironment", (Object)"maven");
            context.setVariable("executionTimestamp", (Object)LocalDateTime.now());
            context.setVariable("timeZone", (Object)ZoneId.systemDefault().getId());
            context.setVariable("extensionVersion", (Object)VersionInfo.getVersion());
            Map<String, TestExecutionTracker.TestClassMetrics> classMetrics = executionTracker.getClassMetrics();
            long passedTests = TemplateHelpers.countTestsByStatus(classMetrics, "PASSED");
            long failedTests = TemplateHelpers.countTestsByStatus(classMetrics, "FAILED");
            long disabledTests = TemplateHelpers.countTestsByStatus(classMetrics, "DISABLED");
            long abortedTests = TemplateHelpers.countTestsByStatus(classMetrics, "ABORTED");
            context.setVariable("passedTests", (Object)passedTests);
            context.setVariable("failedTests", (Object)failedTests);
            context.setVariable("disabledTests", (Object)disabledTests);
            context.setVariable("abortedTests", (Object)abortedTests);
            int totalTestMethods = executionTracker.getTotalTestMethods();
            double successRate = totalTestMethods > 0 ? (double)passedTests * 100.0 / (double)totalTestMethods : 0.0;
            context.setVariable("successRate", (Object)successRate);
            if (contextCacheTracker != null) {
                OptimizationStatistics optimizationStats = contextCacheTracker.calculateOptimizationStatistics();
                context.setVariable("optimizationStats", (Object)optimizationStats);
                TimelineData timelineData = contextCacheTracker.getTimelineData();
                context.setVariable("timelineData", (Object)timelineData);
            }
            String cssContent = this.loadCssContent();
            context.setVariable("cssContent", (Object)cssContent);
            this.registerHelperBeans(context, contextCacheTracker);
            String result = this.templateEngine.process("report", (IContext)context);
            logger.info("Successfully generated HTML with Thymeleaf templates");
            return result;
        }
        catch (Exception e) {
            logger.error("Failed to generate HTML with Thymeleaf ", (Throwable)e);
            throw new RuntimeException("Report generation failed", e);
        }
    }

    private void registerHelperBeans(Context context, ContextCacheTracker contextCacheTracker) {
        context.setVariable("durationFormatter", (Object)new TemplateHelpers.DurationFormatter());
        context.setVariable("classNameHelper", (Object)new TemplateHelpers.ClassNameHelper());
        context.setVariable("statusColorHelper", (Object)new TemplateHelpers.StatusColorHelper());
        context.setVariable("statusIconHelper", (Object)new TemplateHelpers.StatusIconHelper());
        context.setVariable("errorFormatter", (Object)new TemplateHelpers.ErrorFormatter());
        context.setVariable("testMethodSorter", (Object)new TemplateHelpers.TestMethodSorter());
        context.setVariable("testClassSorter", (Object)new TemplateHelpers.TestClassSorter());
        context.setVariable("classNameComparator", (Object)new TemplateHelpers.ClassNameComparator());
        context.setVariable("cacheKeyProcessor", (Object)new TemplateHelpers.CacheKeyProcessor());
        context.setVariable("summaryCalculator", (Object)new TemplateHelpers.SummaryCalculator());
        context.setVariable("configurationHelper", (Object)new TemplateHelpers.ConfigurationHelper(contextCacheTracker));
        context.setVariable("testStatusCounter", (Object)new TemplateHelpers.TestStatusCounter());
        context.setVariable("jsonHelper", (Object)new TemplateHelpers.JsonHelper());
    }

    private String loadCssContent() {
        String string;
        block9: {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("static/css/spring-test-profiler.css");
            try {
                if (inputStream == null) {
                    throw new RuntimeException("CSS file not found in classpath: static/css/spring-test-profiler.css");
                }
                string = new String(inputStream.readAllBytes());
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Could not load CSS file. Report generation will fail.", (Throwable)e);
                    throw new RuntimeException("CSS file not found", e);
                }
            }
            inputStream.close();
        }
        return string;
    }
}

