/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber.digester.rules;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.AbstractRule;
import org.apache.asn1.ber.primitives.PrimitiveUtils;
import org.apache.asn1.ber.primitives.UniversalTag;

public class PrimitiveIntDecodeRule
extends AbstractRule {
    private final byte[] value = new byte[4];
    private int pos;
    private int length;
    private final TagEnum tag;

    public PrimitiveIntDecodeRule() {
        this.tag = UniversalTag.INTEGER;
    }

    public PrimitiveIntDecodeRule(TagEnum tag) {
        this.tag = tag;
    }

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        if (id != this.tag.getTagId()) {
            throw new IllegalArgumentException("Expecting " + this.tag.getName() + " with an id of " + this.tag.getTagId() + " but instead got a tag id of " + id);
        }
    }

    public void length(int length) {
        if (length > 4 || length < 0) {
            throw new IllegalArgumentException("The target primitive for this rule can only hold integers of 32 bits or 4 bytes.  The length of the field however is " + length);
        }
        this.length = length;
    }

    public void value(ByteBuffer buf) {
        if (buf == null) {
            return;
        }
        while (buf.hasRemaining() && this.pos + 1 <= this.length) {
            this.value[this.pos] = buf.get();
            ++this.pos;
        }
    }

    public void finish() {
        int numba = PrimitiveUtils.decodeInt(this.value, 0, this.length);
        if (this.getDigester() != null) {
            this.getDigester().pushInt(numba);
        }
        this.pos = 0;
        this.length = 0;
    }

    boolean equals(byte bite, int ii) {
        return this.value[ii] == bite;
    }
}

