/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleEventConsumer;
import org.apache.asn1.codec.stateful.AbstractStatefulEncoder;

public class BEREncoder
extends AbstractStatefulEncoder
implements TupleEventConsumer {
    private static final int DEFAULT_BUFSZ = 32;
    private ByteBuffer buf = null;

    public BEREncoder() {
        this(32);
    }

    public BEREncoder(int bufSz) {
        this.buf = ByteBuffer.allocateDirect(bufSz);
    }

    public void encode(Object obj) {
        throw new UnsupportedOperationException("This encoder receives tuples ONLY via callback methods");
    }

    public void tag(Tuple tlv) {
        if (this.buf.remaining() >= tlv.getTagLength()) {
            tlv.setTag(this.buf, tlv.getTagLength());
        } else {
            this.buf.flip();
            this.encodeOccurred(this.buf);
            this.buf.clear();
            tlv.setTag(this.buf, tlv.getTagLength());
        }
    }

    public void length(Tuple tlv) {
        if (this.buf.remaining() >= tlv.getLengthLength()) {
            tlv.setLength(this.buf, tlv.getLengthLength());
        } else {
            this.buf.flip();
            this.encodeOccurred(this.buf);
            this.buf.clear();
            tlv.setLength(this.buf, tlv.getLengthLength());
        }
    }

    public void chunkedValue(Tuple tlv, ByteBuffer chunk) {
        if (this.buf.position() > 0) {
            this.buf.flip();
            this.encodeOccurred(this.buf);
            this.buf.clear();
        }
        this.encodeOccurred(tlv.getLastValueChunk());
    }

    public void finish(Tuple tlv) {
        if (tlv.isPrimitive()) {
            return;
        }
        if (tlv.isIndefinite()) {
            if (this.buf.remaining() < 2) {
                this.buf.flip();
                this.encodeOccurred(this.buf);
                this.buf.clear();
            }
            this.buf.put((byte)0);
            this.buf.put((byte)0);
            this.buf.flip();
            this.encodeOccurred(this.buf);
            this.buf.clear();
        }
    }
}

