/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.asn1.ber.Tag;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.TypeClass;
import org.apache.commons.lang.ArrayUtils;

public class Tuple {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(ArrayUtils.EMPTY_BYTE_ARRAY);
    private static final int BIT_5 = 32;
    private static final int BIT_6 = 64;
    private static final int BIT_7 = 128;
    private static final int BIT_13 = 16384;
    private static final int BIT_15 = 65536;
    private static final int BIT_20 = 0x200000;
    private static final int BIT_23 = 0x1000000;
    private static final int BIT_27 = 0x10000000;
    int rawTag = 0;
    int id = 0;
    boolean isPrimitive = true;
    TypeClass typeClass = TypeClass.APPLICATION;
    int length = 0;
    ByteBuffer valueChunk = EMPTY_BUFFER;
    int index = -1;
    int valueIndex = -1;

    public Tuple() {
    }

    public Tuple(int id, int length) {
        this(id, length, TypeClass.APPLICATION);
    }

    public Tuple(int id, int length, TypeClass typeClass) {
        this.id = id;
        this.length = length;
        this.valueChunk = EMPTY_BUFFER;
        this.isPrimitive = false;
        if (typeClass != null) {
            this.typeClass = typeClass;
        }
    }

    public Tuple(int id, int length, boolean isPrimitive, TypeClass typeClass) {
        this.id = id;
        this.length = length;
        this.valueChunk = EMPTY_BUFFER;
        isPrimitive = false;
        if (typeClass != null) {
            this.typeClass = typeClass;
        }
    }

    public Tuple(int id, TypeClass typeClass) {
        this.id = id;
        this.isPrimitive = false;
        this.valueChunk = EMPTY_BUFFER;
        this.length = -2;
        if (typeClass != null) {
            this.typeClass = typeClass;
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.rawTag = Tag.setIntEncodedId(this.rawTag, id);
    }

    public int getRawTag() {
        return this.rawTag;
    }

    public void setRawTag(int rawTag) {
        this.rawTag = rawTag;
        this.id = Tag.getTagId(rawTag);
        this.isPrimitive = !Tag.isRawTagConstructed(rawTag);
        this.typeClass = TypeClass.getTypeClass(rawTag >> 24);
    }

    public void setTag(TagEnum tag) {
        this.rawTag = tag.getValue();
        this.id = tag.getTagId();
        this.isPrimitive = !Tag.isRawTagConstructed(tag.getValue());
        this.typeClass = tag.getTypeClass();
    }

    public void setTag(TagEnum tag, boolean isPrimitive) {
        this.rawTag = tag.getValue();
        this.id = tag.getTagId();
        this.isPrimitive = isPrimitive;
        this.typeClass = tag.getTypeClass();
    }

    public int getRawPrimitiveTag() {
        return this.rawTag & 0xDFFFFFFF;
    }

    public boolean isIndefinite() {
        return this.length == -2;
    }

    public boolean isIndefiniteTerminator() {
        return this.isPrimitive && this.id == 0 && this.length <= 0 && this.typeClass.equals((Object)TypeClass.UNIVERSAL);
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public TypeClass getTypeClass() {
        return this.typeClass;
    }

    public ByteBuffer getLastValueChunk() {
        return this.valueChunk;
    }

    public void setLastValueChunk(ByteBuffer buf) {
        this.valueChunk = buf;
    }

    public int size() {
        if (this.length == -2) {
            return this.getTagLength() + this.getLengthLength();
        }
        return this.getTagLength() + this.getLengthLength() + this.length;
    }

    public void clear() {
        this.id = 0;
        this.index = 0;
        this.rawTag = 0;
        this.isPrimitive = true;
        this.length = -1;
        this.typeClass = TypeClass.APPLICATION;
        this.valueChunk = EMPTY_BUFFER;
        this.valueIndex = -1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Tuple) {
            Tuple t = (Tuple)o;
            if (t.id != this.id) {
                return false;
            }
            if (t.isPrimitive != this.isPrimitive) {
                return false;
            }
            if (t.length != this.length) {
                return false;
            }
            return t.typeClass == this.typeClass;
        }
        return false;
    }

    public Object clone() {
        Tuple t = new Tuple();
        t.id = this.id;
        t.rawTag = this.rawTag;
        t.isPrimitive = this.isPrimitive;
        t.typeClass = this.typeClass;
        t.length = this.length;
        ByteBuffer bb = this.valueChunk;
        ByteBuffer cloned = ByteBuffer.allocate(bb.capacity());
        int oldPos = bb.position();
        bb.rewind();
        cloned.put(bb);
        cloned.limit(bb.limit());
        bb.position(oldPos);
        cloned.rewind();
        t.valueChunk = cloned;
        t.index = this.index;
        t.valueIndex = this.valueIndex;
        return t;
    }

    public ByteBuffer toEncodedBuffer(List valueChunks) {
        ByteBuffer octets = null;
        int tagLength = this.getTagLength();
        int lengthLength = this.getLengthLength();
        int total = tagLength + lengthLength;
        if (this.isPrimitive) {
            total += this.length;
        }
        octets = ByteBuffer.allocate(total);
        this.setTag(octets, tagLength);
        this.setLength(octets, lengthLength);
        if (this.isPrimitive) {
            for (int ii = 0; ii < valueChunks.size(); ++ii) {
                octets.put((ByteBuffer)valueChunks.get(ii));
            }
        }
        return (ByteBuffer)octets.flip();
    }

    public void setTag(ByteBuffer octets, int tagLength) {
        if (tagLength >= 6) {
            throw new IllegalArgumentException("cannot support id's as large as " + this.id + " unless we start using longs for the id");
        }
        byte octet = (byte)this.typeClass.getValue();
        int i = octets.position();
        if (!this.isPrimitive) {
            octet = (byte)(octet | 0x20);
        }
        if (this.id < 31) {
            octets.put((byte)(octet | this.id & 0x1F));
            return;
        }
        octets.put((byte)(octet | 0x1F));
        ++i;
        switch (tagLength - 1) {
            case 5: {
                octets.put((byte)(this.id >> 21 & 0x7F | 0x80));
                ++i;
            }
            case 4: {
                octets.put((byte)(this.id >> 21 & 0x7F | 0x80));
                ++i;
            }
            case 3: {
                octets.put((byte)(this.id >> 14 & 0x7F | 0x80));
                ++i;
            }
            case 2: {
                octets.put((byte)(this.id >> 7 & 0x7F | 0x80));
                ++i;
            }
            case 1: {
                octets.put((byte)(this.id & 0x7F));
            }
        }
    }

    public void setValueLength(int length) {
        this.length = length;
    }

    public void setLength(ByteBuffer octets, int lengthBytes) {
        if (lengthBytes >= 6) {
            throw new IllegalArgumentException("cannot support lengths larger than a max integer using " + lengthBytes + " bytes unless we start using longs or BigIntegers for " + "the length");
        }
        if (this.length == -2) {
            octets.put((byte)-128);
            return;
        }
        if (lengthBytes == 1) {
            octets.put((byte)this.length);
            return;
        }
        octets.put((byte)(0x80 | lengthBytes - 1));
        int ii = 0;
        int shift = lengthBytes - 2 << 3;
        while (ii <= lengthBytes - 2) {
            octets.put(octets.position() + ii, (byte)((255 << shift & this.length) >> shift));
            ++ii;
            shift -= 8;
        }
        octets.position(octets.position() + lengthBytes - 1);
    }

    public int getTagLength() {
        if (this.id < 31) {
            return 1;
        }
        if (this.id < 64) {
            return 2;
        }
        if (this.id < 16384) {
            return 3;
        }
        if (this.id < 0x200000) {
            return 4;
        }
        if (this.id < 0x10000000) {
            return 5;
        }
        throw new IllegalArgumentException("cannot support id's larger than " + this.id + " unless we start using longs for the id");
    }

    public int getLengthLength() {
        if (this.length == -2) {
            return 1;
        }
        if (this.length < 0) {
            throw new IllegalArgumentException("integer overflow makes id negative with a value of " + this.id + " - unless we start using longs for" + " the id there you've hit a limitation");
        }
        if (this.length < 128) {
            return 1;
        }
        if (this.length < 256) {
            return 2;
        }
        if (this.length < 65536) {
            return 3;
        }
        if (this.length < 0x1000000) {
            return 4;
        }
        return 5;
    }
}

