/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber.primitives;

public class PrimitiveUtils {
    private static final int ONE_BYTE_MAX = 127;
    private static final int ONE_BYTE_MIN = -128;
    private static final int TWO_BYTE_MAX = Short.MAX_VALUE;
    private static final int TWO_BYTE_MIN = Short.MIN_VALUE;
    private static final int THREE_BYTE_MAX = 0x7FFFFF;
    private static final int THREE_BYTE_MIN = -8388608;
    private static final int FOUR_BYTE_MAX = Integer.MAX_VALUE;
    private static final int FOUR_BYTE_MIN = Integer.MIN_VALUE;
    private static final byte[] TRUE_ARRAY = new byte[]{-1};
    private static final byte[] FALSE_ARRAY = new byte[]{0};

    public static boolean berDecodeBoolean(byte value) {
        return value != 0;
    }

    public static byte encodeBooleanAsByte(boolean bool) {
        return bool ? (byte)-1 : 0;
    }

    public static byte[] encodeBoolean(boolean bool) {
        return bool ? TRUE_ARRAY : FALSE_ARRAY;
    }

    public static boolean derCerDecodeBoolean(byte value) {
        if (value == 0) {
            return false;
        }
        if (value == 255) {
            return true;
        }
        String msg = "For DER and CER encodings of boolean values the only  permisable values are 0x00 for false and 0xFF for true. A value of " + value + " is not allowed!";
        throw new IllegalArgumentException(msg);
    }

    public static byte[] encodeInt(int source) {
        byte[] encoded = null;
        if (source >= -128 && source <= 127) {
            encoded = new byte[]{(byte)source};
        } else if (source >= Short.MIN_VALUE && source <= Short.MAX_VALUE) {
            encoded = new byte[2];
            encoded[1] = (byte)source;
            encoded[0] = (byte)(source >> 8);
        } else if (source >= -8388608 && source <= 0x7FFFFF) {
            encoded = new byte[3];
            encoded[2] = (byte)source;
            encoded[1] = (byte)(source >> 8);
            encoded[0] = (byte)(source >> 16);
        } else if (source >= Integer.MIN_VALUE && source <= Integer.MAX_VALUE) {
            encoded = new byte[4];
            encoded[3] = (byte)source;
            encoded[2] = (byte)(source >> 8);
            encoded[1] = (byte)(source >> 16);
            encoded[0] = (byte)(source >> 24);
        }
        return encoded;
    }

    public static int decodeInt(byte[] bites, int offset, int length) {
        int value = 0;
        if (length == 0) {
            return 0;
        }
        switch (length) {
            case 1: {
                if ((bites[offset + 0] & 0x80) == 128) {
                    value |= bites[offset + 0] | 0xFFFFFF00;
                    break;
                }
                value |= bites[offset + 0] & 0xFF;
                break;
            }
            case 2: {
                value = (bites[offset + 0] & 0x80) == 128 ? (value |= bites[offset + 0] << 8 | 0xFFFF0000) : (value |= bites[offset + 0] << 8);
                value |= bites[offset + 1] & 0xFF;
                break;
            }
            case 3: {
                value = (bites[offset + 0] & 0x80) == 128 ? (value |= bites[offset + 0] << 16 | 0xFF000000) : (value |= bites[offset + 0] << 16);
                value |= bites[offset + 1] << 8 & 0xFF00;
                value |= bites[offset + 2] & 0xFF;
                break;
            }
            case 4: {
                value |= bites[offset + 0] << 24 & 0xFF000000;
                value |= bites[offset + 1] << 16 & 0xFF0000;
                value |= bites[offset + 2] << 8 & 0xFF00;
                value |= bites[offset + 3] & 0xFF;
                break;
            }
            default: {
                throw new IllegalArgumentException("Length should be in range [0-4]");
            }
        }
        return value;
    }
}

