/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber.primitives;

import java.util.List;
import java.util.Map;
import org.apache.asn1.ber.TagEnum;
import org.apache.commons.lang.enum.EnumUtils;

public class UniversalTag
extends TagEnum {
    private static final int RESERVED0_VAL = 0;
    private static final int BOOLEAN_VAL = 0x1000000;
    private static final int INTEGER_VAL = 0x2000000;
    private static final int BIT_STRING_VAL = 0x3000000;
    private static final int OCTET_STRING_VAL = 0x4000000;
    private static final int NULL_VAL = 0x5000000;
    private static final int OBJECT_IDENTIFIER_VAL = 0x6000000;
    private static final int OBJECT_DESCRIPTOR_VAL = 0x7000000;
    private static final int EXTERNAL_INSTANCE_OF_VAL = 0x8000000;
    private static final int REAL_VAL = 0x9000000;
    private static final int ENUMERATED_VAL = 0xA000000;
    private static final int EMBEDDED_PDV_VAL = 0xB000000;
    private static final int UTF8_STRING_VAL = 0xC000000;
    private static final int RELATIVE_OID_VAL = 0xD000000;
    private static final int RESERVED14_VAL = 0xE000000;
    private static final int RESERVED15_VAL = 0xF000000;
    private static final int SEQUENCE_SEQUENCE_OF_VAL = 0x10000000;
    private static final int SET_SET_OF_VAL = 0x11000000;
    private static final int NUMERIC_STRING_VAL = 0x12000000;
    private static final int PRINTABLE_STRING_VAL = 0x13000000;
    private static final int TELETEX_STRING_VAL = 0x14000000;
    private static final int VIDEOTEX_STRING_VAL = 0x15000000;
    private static final int IA5_STRING_VAL = 0x16000000;
    private static final int UTC_TIME_VAL = 0x17000000;
    private static final int GENERALIZED_TIME_VAL = 0x18000000;
    private static final int GRAPHIC_STRING_VAL = 0x19000000;
    private static final int VISIBLE_STRING_VAL = 0x1A000000;
    private static final int GENERAL_STRING_VAL = 0x1B000000;
    private static final int UNIVERSAL_STRING_VAL = 0x1C000000;
    private static final int CHARACTER_STRING_VAL = 0x1D000000;
    private static final int BMP_STRING_VAL = 0x1E000000;
    private static final int RESERVED31_VAL = 0x1F000000;
    private static final int RESERVED0_ID = 0;
    private static final int BOOLEAN_ID = 1;
    private static final int INTEGER_ID = 2;
    private static final int BIT_STRING_ID = 3;
    private static final int OCTET_STRING_ID = 4;
    private static final int NULL_ID = 5;
    private static final int OBJECT_IDENTIFIER_ID = 6;
    private static final int OBJECT_DESCRIPTOR_ID = 7;
    private static final int EXTERNAL_INSTANCE_OF_ID = 8;
    private static final int REAL_ID = 9;
    private static final int ENUMERATED_ID = 10;
    private static final int EMBEDDED_PDV_ID = 11;
    private static final int UTF8_STRING_ID = 12;
    private static final int RELATIVE_OID_ID = 13;
    private static final int RESERVED14_ID = 14;
    private static final int RESERVED15_ID = 15;
    private static final int SEQUENCE_SEQUENCE_OF_ID = 16;
    private static final int SET_SET_OF_ID = 17;
    private static final int NUMERIC_STRING_ID = 18;
    private static final int PRINTABLE_STRING_ID = 19;
    private static final int TELETEX_STRING_ID = 20;
    private static final int VIDEOTEX_STRING_ID = 21;
    private static final int IA5_STRING_ID = 22;
    private static final int UTC_TIME_ID = 23;
    private static final int GENERALIZED_TIME_ID = 24;
    private static final int GRAPHIC_STRING_ID = 25;
    private static final int VISIBLE_STRING_ID = 26;
    private static final int GENERAL_STRING_ID = 27;
    private static final int UNIVERSAL_STRING_ID = 28;
    private static final int CHARACTER_STRING_ID = 29;
    private static final int BMP_STRING_ID = 30;
    private static final int RESERVED31_ID = 31;
    public static final UniversalTag BOOLEAN = new UniversalTag("BOOLEAN", 0x1000000, 1);
    public static final UniversalTag RESERVED0 = new UniversalTag("RESERVED0", 0, 0);
    public static final UniversalTag INTEGER = new UniversalTag("INTEGER", 0x2000000, 2);
    public static final UniversalTag BIT_STRING = new UniversalTag("BIT_STRING", 0x3000000, 3);
    public static final UniversalTag OCTET_STRING = new UniversalTag("OCTET_STRING", 0x4000000, 4);
    public static final UniversalTag NULL = new UniversalTag("NULL", 0x5000000, 5);
    public static final UniversalTag OBJECT_IDENTIFIER = new UniversalTag("OBJECT_IDENTIFIER", 0x6000000, 6);
    public static final UniversalTag OBJECT_DESCRIPTOR = new UniversalTag("OBJECT_DESCRIPTOR", 0x7000000, 7);
    public static final UniversalTag EXTERNAL_INSTANCE_OF = new UniversalTag("EXTERNAL_INSTANCE_OF", 0x8000000, 8);
    public static final UniversalTag REAL = new UniversalTag("REAL", 0x9000000, 9);
    public static final UniversalTag ENUMERATED = new UniversalTag("ENUMERATED", 0xA000000, 10);
    public static final UniversalTag EMBEDDED_PDV = new UniversalTag("EMBEDDED_PDV", 0xB000000, 11);
    public static final UniversalTag UTF8_STRING = new UniversalTag("UTF8_STRING", 0xC000000, 12);
    public static final UniversalTag RELATIVE_OID = new UniversalTag("RELATIVE_OID", 0xD000000, 13);
    public static final UniversalTag RESERVED14 = new UniversalTag("RESERVED14", 0xE000000, 14);
    public static final UniversalTag RESERVED15 = new UniversalTag("RESERVED15", 0xF000000, 15);
    public static final UniversalTag SEQUENCE_SEQUENCE_OF = new UniversalTag("SEQUENCE_SEQUENCE_OF", 0x10000000, 16);
    public static final UniversalTag SET_SET_OF = new UniversalTag("SET_SET_OF", 0x11000000, 17);
    public static final UniversalTag NUMERIC_STRING = new UniversalTag("NUMERIC_STRING", 0x12000000, 18);
    public static final UniversalTag PRINTABLE_STRING = new UniversalTag("PRINTABLE_STRING", 0x13000000, 19);
    public static final UniversalTag TELETEX_STRING = new UniversalTag("TELETEX_STRING", 0x14000000, 20);
    public static final UniversalTag VIDEOTEX_STRING = new UniversalTag("VIDEOTEX_STRING", 0x15000000, 21);
    public static final UniversalTag IA5_STRING = new UniversalTag("IA5_STRING", 0x16000000, 22);
    public static final UniversalTag UTC_TIME = new UniversalTag("UTC_TIME", 0x17000000, 23);
    public static final UniversalTag GENERALIZED_TIME = new UniversalTag("GENERALIZED_TIME", 0x18000000, 24);
    public static final UniversalTag GRAPHIC_STRING = new UniversalTag("GRAPHIC_STRING", 0x19000000, 25);
    public static final UniversalTag VISIBLE_STRING = new UniversalTag("VISIBLE_STRING", 0x1A000000, 26);
    public static final UniversalTag GENERAL_STRING = new UniversalTag("GENERAL_STRING", 0x1B000000, 27);
    public static final UniversalTag UNIVERSAL_STRING = new UniversalTag("UNIVERSAL_STRING", 0x1C000000, 28);
    public static final UniversalTag CHARACTER_STRING = new UniversalTag("CHARACTER_STRING", 0x1D000000, 29);
    public static final UniversalTag BMP_STRING = new UniversalTag("BMP_STRING", 0x1E000000, 30);
    public static final UniversalTag RESERVED31 = new UniversalTag("RESERVED31", 0x1F000000, 31);

    private UniversalTag(String name, int value, int id) {
        super(name, value, id);
    }

    public static List list() {
        return EnumUtils.getEnumList((Class)UniversalTag.class);
    }

    public static Map map() {
        return EnumUtils.getEnumMap((Class)UniversalTag.class);
    }

    public static UniversalTag getUniversalTag(int value) {
        UniversalTag type = null;
        switch (value &= 0xDFFFFFFF) {
            case 0: {
                type = RESERVED0;
                break;
            }
            case 0x1000000: {
                type = BOOLEAN;
                break;
            }
            case 0x2000000: {
                type = INTEGER;
                break;
            }
            case 0x3000000: {
                type = BIT_STRING;
                break;
            }
            case 0x4000000: {
                type = OCTET_STRING;
                break;
            }
            case 0x5000000: {
                type = NULL;
                break;
            }
            case 0x6000000: {
                type = OBJECT_IDENTIFIER;
                break;
            }
            case 0x7000000: {
                type = OBJECT_DESCRIPTOR;
                break;
            }
            case 0x8000000: {
                type = EXTERNAL_INSTANCE_OF;
                break;
            }
            case 0x9000000: {
                type = REAL;
                break;
            }
            case 0xA000000: {
                type = ENUMERATED;
                break;
            }
            case 0xB000000: {
                type = EMBEDDED_PDV;
                break;
            }
            case 0xC000000: {
                type = UTF8_STRING;
                break;
            }
            case 0xD000000: {
                type = RELATIVE_OID;
                break;
            }
            case 0xE000000: {
                type = RESERVED14;
                break;
            }
            case 0xF000000: {
                type = RESERVED15;
                break;
            }
            case 0x10000000: {
                type = SEQUENCE_SEQUENCE_OF;
                break;
            }
            case 0x11000000: {
                type = SET_SET_OF;
                break;
            }
            case 0x12000000: {
                type = NUMERIC_STRING;
                break;
            }
            case 0x13000000: {
                type = PRINTABLE_STRING;
                break;
            }
            case 0x14000000: {
                type = TELETEX_STRING;
                break;
            }
            case 0x15000000: {
                type = VIDEOTEX_STRING;
                break;
            }
            case 0x16000000: {
                type = IA5_STRING;
                break;
            }
            case 0x17000000: {
                type = UTC_TIME;
                break;
            }
            case 0x18000000: {
                type = GENERALIZED_TIME;
                break;
            }
            case 0x19000000: {
                type = GRAPHIC_STRING;
                break;
            }
            case 0x1A000000: {
                type = VISIBLE_STRING;
                break;
            }
            case 0x1B000000: {
                type = GENERAL_STRING;
                break;
            }
            case 0x1C000000: {
                type = UNIVERSAL_STRING;
                break;
            }
            case 0x1D000000: {
                type = CHARACTER_STRING;
                break;
            }
            case 0x1E000000: {
                type = BMP_STRING;
                break;
            }
            case 0x1F000000: {
                type = RESERVED31;
                break;
            }
            default: {
                String msg = value < 31 && value > -1 ? "Looks like you're using an id instead of a tag" : "Tag value of " + value + " not recognized";
                throw new IllegalArgumentException(msg);
            }
        }
        return type;
    }

    public static UniversalTag getUniversalTagById(int id) {
        UniversalTag type = null;
        switch (id) {
            case 0: {
                type = RESERVED0;
                break;
            }
            case 1: {
                type = BOOLEAN;
                break;
            }
            case 2: {
                type = INTEGER;
                break;
            }
            case 3: {
                type = BIT_STRING;
                break;
            }
            case 4: {
                type = OCTET_STRING;
                break;
            }
            case 5: {
                type = NULL;
                break;
            }
            case 6: {
                type = OBJECT_IDENTIFIER;
                break;
            }
            case 7: {
                type = OBJECT_DESCRIPTOR;
                break;
            }
            case 8: {
                type = EXTERNAL_INSTANCE_OF;
                break;
            }
            case 9: {
                type = REAL;
                break;
            }
            case 10: {
                type = ENUMERATED;
                break;
            }
            case 11: {
                type = EMBEDDED_PDV;
                break;
            }
            case 12: {
                type = UTF8_STRING;
                break;
            }
            case 13: {
                type = RELATIVE_OID;
                break;
            }
            case 14: {
                type = RESERVED14;
                break;
            }
            case 15: {
                type = RESERVED15;
                break;
            }
            case 16: {
                type = SEQUENCE_SEQUENCE_OF;
                break;
            }
            case 17: {
                type = SET_SET_OF;
                break;
            }
            case 18: {
                type = NUMERIC_STRING;
                break;
            }
            case 19: {
                type = PRINTABLE_STRING;
                break;
            }
            case 20: {
                type = TELETEX_STRING;
                break;
            }
            case 21: {
                type = VIDEOTEX_STRING;
                break;
            }
            case 22: {
                type = IA5_STRING;
                break;
            }
            case 23: {
                type = UTC_TIME;
                break;
            }
            case 24: {
                type = GENERALIZED_TIME;
                break;
            }
            case 25: {
                type = GRAPHIC_STRING;
                break;
            }
            case 26: {
                type = VISIBLE_STRING;
                break;
            }
            case 27: {
                type = GENERAL_STRING;
                break;
            }
            case 28: {
                type = UNIVERSAL_STRING;
                break;
            }
            case 29: {
                type = CHARACTER_STRING;
                break;
            }
            case 30: {
                type = BMP_STRING;
                break;
            }
            case 31: {
                type = RESERVED31;
                break;
            }
            default: {
                String msg = id > 31 || id < 0 ? "Looks like you're using a tag instead of an id" : "Id of " + id + " not recognized as a universal id";
                throw new IllegalArgumentException(msg);
            }
        }
        return type;
    }
}

