/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.protocol.ProtocolFilter;
import org.apache.mina.protocol.ProtocolFilterChain;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolSession;

public abstract class AbstractProtocolFilterChain
implements ProtocolFilterChain {
    private final Map name2entry = new HashMap();
    private final Map filter2entry = new IdentityHashMap();
    private final Entry head = new Entry(null, null, "head", this.createHeadFilter());
    private final Entry tail = new Entry(this.head, null, "tail", this.createTailFilter());

    protected AbstractProtocolFilterChain() {
        this.head.nextEntry = this.tail;
    }

    protected ProtocolFilter createHeadFilter() {
        return new ProtocolFilter(){

            public void sessionOpened(ProtocolFilter.NextFilter nextFilter, ProtocolSession session) {
                nextFilter.sessionOpened(session);
            }

            public void sessionClosed(ProtocolFilter.NextFilter nextFilter, ProtocolSession session) {
                nextFilter.sessionClosed(session);
            }

            public void sessionIdle(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, IdleStatus status) {
                nextFilter.sessionIdle(session, status);
            }

            public void exceptionCaught(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Throwable cause) {
                nextFilter.exceptionCaught(session, cause);
            }

            public void messageReceived(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
                nextFilter.messageReceived(session, message);
            }

            public void messageSent(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
                nextFilter.messageSent(session, message);
            }

            public void filterWrite(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
                AbstractProtocolFilterChain.this.doWrite(session, message);
            }
        };
    }

    protected ProtocolFilter createTailFilter() {
        return new ProtocolFilter(){

            public void sessionOpened(ProtocolFilter.NextFilter nextFilter, ProtocolSession session) throws Exception {
                session.getHandler().sessionOpened(session);
            }

            public void sessionClosed(ProtocolFilter.NextFilter nextFilter, ProtocolSession session) throws Exception {
                session.getHandler().sessionClosed(session);
            }

            public void sessionIdle(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, IdleStatus status) throws Exception {
                session.getHandler().sessionIdle(session, status);
            }

            public void exceptionCaught(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Throwable cause) throws Exception {
                session.getHandler().exceptionCaught(session, cause);
            }

            public void messageReceived(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Object message) throws Exception {
                ProtocolHandler handler = session.getHandler();
                handler.messageReceived(session, message);
            }

            public void messageSent(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Object message) throws Exception {
                session.getHandler().messageSent(session, message);
            }

            public void filterWrite(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Object message) throws Exception {
                nextFilter.filterWrite(session, message);
            }
        };
    }

    public ProtocolFilter getChild(String name) {
        Entry e = (Entry)this.name2entry.get(name);
        if (e == null) {
            return null;
        }
        return e.filter;
    }

    public synchronized void addFirst(String name, ProtocolFilter filter) {
        this.checkAddable(name);
        this.register(this.head, name, filter);
    }

    public synchronized void addLast(String name, ProtocolFilter filter) {
        this.checkAddable(name);
        this.register(this.tail.prevEntry, name, filter);
    }

    public synchronized void addBefore(String baseName, String name, ProtocolFilter filter) {
        Entry baseEntry = this.checkOldName(baseName);
        this.checkAddable(name);
        this.register(baseEntry, name, filter);
    }

    public synchronized void addAfter(String baseName, String name, ProtocolFilter filter) {
        Entry baseEntry = this.checkOldName(baseName);
        this.checkAddable(name);
        this.register(baseEntry.prevEntry, name, filter);
    }

    public synchronized void remove(String name) {
        Entry entry = this.checkOldName(name);
        Entry prevEntry = entry.prevEntry;
        Entry nextEntry = entry.nextEntry;
        prevEntry.nextEntry = nextEntry;
        nextEntry.prevEntry = prevEntry;
        this.name2entry.remove(name);
        ProtocolFilter filter = entry.filter;
        this.filter2entry.remove(filter);
    }

    public synchronized void clear() {
        Iterator it = new ArrayList(this.name2entry.keySet()).iterator();
        while (it.hasNext()) {
            this.remove((String)it.next());
        }
    }

    private void register(Entry prevEntry, String name, ProtocolFilter filter) {
        Entry newEntry = new Entry(prevEntry, prevEntry.nextEntry, name, filter);
        prevEntry.nextEntry.prevEntry = newEntry;
        prevEntry.nextEntry = newEntry;
        this.name2entry.put(name, newEntry);
        this.filter2entry.put(filter, newEntry);
    }

    private Entry checkOldName(String baseName) {
        Entry e = (Entry)this.name2entry.get(baseName);
        if (e == null) {
            throw new IllegalArgumentException("Unknown interceptor name:" + baseName);
        }
        return e;
    }

    private void checkAddable(String name) {
        if (this.name2entry.containsKey(name)) {
            throw new IllegalArgumentException("Other interceptor is using name '" + name + "'");
        }
    }

    public void sessionOpened(ProtocolSession session) {
        Entry head = this.head;
        this.callNextSessionOpened(head, session);
    }

    private void callNextSessionOpened(Entry entry, ProtocolSession session) {
        try {
            entry.filter.sessionOpened(entry.nextFilter, session);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void sessionClosed(ProtocolSession session) {
        Entry head = this.head;
        this.callNextSessionClosed(head, session);
    }

    private void callNextSessionClosed(Entry entry, ProtocolSession session) {
        try {
            entry.filter.sessionClosed(entry.nextFilter, session);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void sessionIdle(ProtocolSession session, IdleStatus status) {
        Entry head = this.head;
        this.callNextSessionIdle(head, session, status);
    }

    private void callNextSessionIdle(Entry entry, ProtocolSession session, IdleStatus status) {
        try {
            entry.filter.sessionIdle(entry.nextFilter, session, status);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void messageReceived(ProtocolSession session, Object message) {
        Entry head = this.head;
        this.callNextMessageReceived(head, session, message);
    }

    private void callNextMessageReceived(Entry entry, ProtocolSession session, Object message) {
        try {
            entry.filter.messageReceived(entry.nextFilter, session, message);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void messageSent(ProtocolSession session, Object message) {
        Entry head = this.head;
        this.callNextMessageSent(head, session, message);
    }

    private void callNextMessageSent(Entry entry, ProtocolSession session, Object message) {
        try {
            entry.filter.messageSent(entry.nextFilter, session, message);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void exceptionCaught(ProtocolSession session, Throwable cause) {
        Entry head = this.head;
        this.callNextExceptionCaught(head, session, cause);
    }

    private void callNextExceptionCaught(Entry entry, ProtocolSession session, Throwable cause) {
        try {
            entry.filter.exceptionCaught(entry.nextFilter, session, cause);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void filterWrite(ProtocolSession session, Object message) {
        Entry tail = this.tail;
        this.callPreviousFilterWrite(tail, session, message);
    }

    private void callPreviousFilterWrite(Entry entry, ProtocolSession session, Object message) {
        if (message == null) {
            return;
        }
        try {
            entry.filter.filterWrite(entry.nextFilter, session, message);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public List getChildren() {
        ArrayList<ProtocolFilter> list = new ArrayList<ProtocolFilter>();
        Entry e = this.head.nextEntry;
        while (e != this.tail) {
            list.add(e.filter);
            e = e.nextEntry;
        }
        return list;
    }

    public List getChildrenReversed() {
        ArrayList<ProtocolFilter> list = new ArrayList<ProtocolFilter>();
        Entry e = this.tail.prevEntry;
        while (e != this.head) {
            list.add(e.filter);
            e = e.prevEntry;
        }
        return list;
    }

    protected abstract void doWrite(ProtocolSession var1, Object var2);

    private class Entry {
        private Entry prevEntry;
        private Entry nextEntry;
        private final String name;
        private final ProtocolFilter filter;
        private final ProtocolFilter.NextFilter nextFilter;

        private Entry(Entry prevEntry, Entry nextEntry, String name, ProtocolFilter filter) {
            if (filter == null) {
                throw new NullPointerException("filter");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.prevEntry = prevEntry;
            this.nextEntry = nextEntry;
            this.name = name;
            this.filter = filter;
            this.nextFilter = new ProtocolFilter.NextFilter(){

                public void sessionOpened(ProtocolSession session) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractProtocolFilterChain.this.callNextSessionOpened(nextEntry, session);
                }

                public void sessionClosed(ProtocolSession session) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractProtocolFilterChain.this.callNextSessionClosed(nextEntry, session);
                }

                public void sessionIdle(ProtocolSession session, IdleStatus status) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractProtocolFilterChain.this.callNextSessionIdle(nextEntry, session, status);
                }

                public void exceptionCaught(ProtocolSession session, Throwable cause) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractProtocolFilterChain.this.callNextExceptionCaught(nextEntry, session, cause);
                }

                public void messageReceived(ProtocolSession session, Object message) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractProtocolFilterChain.this.callNextMessageReceived(nextEntry, session, message);
                }

                public void messageSent(ProtocolSession session, Object message) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractProtocolFilterChain.this.callNextMessageSent(nextEntry, session, message);
                }

                public void filterWrite(ProtocolSession session, Object message) {
                    Entry nextEntry = Entry.this.prevEntry;
                    AbstractProtocolFilterChain.this.callPreviousFilterWrite(nextEntry, session, message);
                }
            };
        }

        public String getName() {
            return this.name;
        }

        public ProtocolFilter getFilter() {
            return this.filter;
        }
    }
}

