/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.codec;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.protocol.ProtocolDecoder;
import org.apache.mina.protocol.ProtocolDecoderOutput;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.ProtocolViolationException;

public abstract class CumulativeProtocolDecoder
implements ProtocolDecoder {
    private ByteBuffer buf;

    protected CumulativeProtocolDecoder(int defaultCapacity) {
        this.buf = ByteBuffer.allocate(defaultCapacity);
        this.buf.setAutoExpand(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ProtocolSession session, ByteBuffer in, ProtocolDecoderOutput out) throws ProtocolViolationException {
        block5: {
            if (session.getTransportType().isStateless()) {
                throw new IllegalStateException("This decoder doesn't work for stateless transport types.");
            }
            ByteBuffer buf = this.buf;
            buf.put(in);
            buf.flip();
            try {
                int oldPos;
                do {
                    oldPos = buf.position();
                    if (this.doDecode(session, buf, out)) continue;
                    break block5;
                } while (buf.position() != oldPos);
                throw new IllegalStateException("doDecode() can't return true when buffer is not consumed.");
            }
            finally {
                buf.compact();
            }
        }
    }

    protected abstract boolean doDecode(ProtocolSession var1, ByteBuffer var2, ProtocolDecoderOutput var3) throws ProtocolViolationException;
}

