/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.kdc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.crypto.RandomKey;
import org.apache.kerberos.crypto.checksum.RsaMd5Checksum;
import org.apache.kerberos.crypto.encryption.EncryptionEngine;
import org.apache.kerberos.crypto.encryption.EncryptionEngineFactory;
import org.apache.kerberos.crypto.encryption.EncryptionType;
import org.apache.kerberos.exceptions.ErrorType;
import org.apache.kerberos.exceptions.KerberosException;
import org.apache.kerberos.io.decoder.ApplicationRequestDecoder;
import org.apache.kerberos.io.decoder.AuthorizationDataDecoder;
import org.apache.kerberos.io.encoder.EncTgsRepPartEncoder;
import org.apache.kerberos.io.encoder.EncTicketPartEncoder;
import org.apache.kerberos.io.encoder.KdcReqBodyEncoder;
import org.apache.kerberos.messages.ApplicationRequest;
import org.apache.kerberos.messages.KdcReply;
import org.apache.kerberos.messages.KdcRequest;
import org.apache.kerberos.messages.TicketGrantReply;
import org.apache.kerberos.messages.components.Authenticator;
import org.apache.kerberos.messages.components.EncTicketPart;
import org.apache.kerberos.messages.components.EncTicketPartModifier;
import org.apache.kerberos.messages.components.Ticket;
import org.apache.kerberos.messages.value.AuthorizationData;
import org.apache.kerberos.messages.value.Checksum;
import org.apache.kerberos.messages.value.EncryptedData;
import org.apache.kerberos.messages.value.EncryptionKey;
import org.apache.kerberos.messages.value.KerberosTime;
import org.apache.kerberos.messages.value.LastRequest;
import org.apache.kerberos.messages.value.PreAuthenticationDataType;
import org.apache.kerberos.service.KdcConfiguration;
import org.apache.kerberos.service.KerberosService;
import org.apache.kerberos.store.PrincipalStore;

public class TicketGrantingService
extends KerberosService {
    public TicketGrantingService(KdcConfiguration config, PrincipalStore store) {
        super(config, store);
    }

    public TicketGrantReply getReplyFor(KdcRequest request) throws KerberosException, IOException {
        ApplicationRequest authHeader = this.getAuthHeader(request);
        Ticket tgt = authHeader.getTicket();
        Authenticator authenticator = this.verifyAuthHeader(authHeader, tgt);
        this.verifyTicket(tgt, request.getServerPrincipal());
        EncryptionKey sessionKey = new RandomKey().getNewSessionKey();
        EncryptionType eType = this.getBestEncryptionType(request.getEType());
        Ticket newTicket = this.getNewTicket(request, tgt, sessionKey, authenticator);
        TicketGrantReply reply = this.getReply(tgt, newTicket, sessionKey, request);
        if (authenticator.getSubSessionKey() != null) {
            EncryptionKey subKey = authenticator.getSubSessionKey();
            this.encryptReplyPart(reply, subKey);
        } else {
            this.encryptReplyPart(reply, tgt.getSessionKey());
        }
        return reply;
    }

    private ApplicationRequest getAuthHeader(KdcRequest request) throws KerberosException, IOException {
        if (request.getPreAuthData()[0].getDataType() != PreAuthenticationDataType.PA_TGS_REQ) {
            throw new KerberosException(ErrorType.KDC_ERR_PADATA_TYPE_NOSUPP);
        }
        byte[] undecodedAuthHeader = request.getPreAuthData()[0].getDataValue();
        ApplicationRequestDecoder decoder = new ApplicationRequestDecoder();
        ApplicationRequest authHeader = decoder.decode(undecodedAuthHeader);
        return authHeader;
    }

    private void verifyBodyChecksum(Checksum authChecksum, KdcRequest request) throws KerberosException {
        if (authChecksum == null) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_INAPP_CKSUM);
        }
        KdcReqBodyEncoder encoder = new KdcReqBodyEncoder();
        byte[] bytes = null;
        try {
            bytes = encoder.encode(request);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        RsaMd5Checksum digester = new RsaMd5Checksum();
        Checksum newChecksum = new Checksum(digester.checksumType(), digester.calculateChecksum(bytes));
        boolean equal = newChecksum.equals((Object)authChecksum);
        if (!equal) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_MODIFIED);
        }
    }

    private Ticket getNewTicket(KdcRequest request, Ticket tgt, EncryptionKey sessionKey, Authenticator authenticator) throws KerberosException {
        KerberosPrincipal ticketPrincipal = request.getServerPrincipal();
        EncTicketPartModifier newTicketBody = new EncTicketPartModifier();
        newTicketBody.setClientAddresses(tgt.getClientAddresses());
        this.processFlags(request, tgt, newTicketBody);
        newTicketBody.setSessionKey(sessionKey);
        newTicketBody.setClientPrincipal(tgt.getClientPrincipal());
        AuthorizationData authData = this.processAuthorizationData(request, authenticator, tgt);
        newTicketBody.setAuthorizationData(authData);
        this.processTransited(newTicketBody, tgt);
        this.processTimes(request, newTicketBody, tgt);
        EncryptionKey serverKey = this.getServerKey(request.getServerPrincipal());
        EncTicketPart ticketPart = newTicketBody.getEncTicketPart();
        EncryptedData encryptedData = this.encryptTicketPart(ticketPart, serverKey, request);
        Ticket newTicket = new Ticket(ticketPrincipal, encryptedData);
        newTicket.setEncTicketPart(ticketPart);
        return newTicket;
    }

    private void processFlags(KdcRequest request, Ticket tgt, EncTicketPartModifier newTicketBody) throws KerberosException {
        if (request.getOption(1)) {
            if (!tgt.getFlag(1)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(1);
        }
        if (request.getOption(2)) {
            if (!tgt.getFlag(1)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(2);
            newTicketBody.setClientAddresses(request.getAddresses());
        }
        if (tgt.getFlag(2)) {
            newTicketBody.setFlag(2);
        }
        if (request.getOption(3)) {
            if (!tgt.getFlag(3)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(3);
        }
        if (request.getOption(4)) {
            if (!tgt.getFlag(3)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(4);
            newTicketBody.setClientAddresses(request.getAddresses());
        }
        if (request.getOption(5)) {
            if (!tgt.getFlag(5)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(5);
        }
        if (request.getOption(6)) {
            if (!tgt.getFlag(5)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(6);
            newTicketBody.setFlag(7);
            if (!this.config.isPostdateAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setStartTime(request.getFrom());
        }
        if (request.getOption(31)) {
            if (!tgt.getFlag(7)) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (tgt.getStartTime().greaterThan(new KerberosTime())) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_NYV);
            }
            this.echoTicket(newTicketBody, tgt);
            newTicketBody.clearFlag(7);
        }
        if (request.getOption(0) || request.getOption(27)) {
            throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
        }
    }

    private void processTimes(KdcRequest request, EncTicketPartModifier newTicketBody, Ticket tgt) throws KerberosException {
        ArrayList<KerberosTime> minimizer;
        KerberosTime now = new KerberosTime();
        newTicketBody.setAuthTime(tgt.getAuthTime());
        KerberosTime renewalTime = null;
        if (request.getOption(30)) {
            if (!tgt.getFlag(8)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            if (tgt.getRenewTill().greaterThan(now)) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_EXPIRED);
            }
            this.echoTicket(newTicketBody, tgt);
            newTicketBody.setStartTime(now);
            long oldLife = tgt.getEndTime().getTime() - tgt.getStartTime().getTime();
            newTicketBody.setEndTime(new KerberosTime(Math.min(tgt.getRenewTill().getTime(), now.getTime() + oldLife)));
        } else {
            newTicketBody.setStartTime(now);
            KerberosTime till = request.getTill().isZero() ? KerberosTime.INFINITY : request.getTill();
            minimizer = new ArrayList<KerberosTime>();
            minimizer.add(till);
            minimizer.add(new KerberosTime(now.getTime() + this.config.getMaximumTicketLifetime()));
            minimizer.add(tgt.getEndTime());
            KerberosTime minTime = (KerberosTime)Collections.min(minimizer);
            newTicketBody.setEndTime(minTime);
            if (request.getOption(27) && minTime.lessThan(request.getTill()) && tgt.getFlag(8)) {
                request.setOption(8);
                long rtime = Math.min(request.getTill().getTime(), tgt.getRenewTill().getTime());
                renewalTime = new KerberosTime(rtime);
            }
        }
        if (renewalTime == null) {
            renewalTime = request.getRtime();
        }
        KerberosTime rtime = renewalTime != null && renewalTime.isZero() ? KerberosTime.INFINITY : renewalTime;
        if (request.getOption(8) && tgt.getFlag(8)) {
            newTicketBody.setFlag(8);
            minimizer = new ArrayList();
            if (rtime != null) {
                minimizer.add(rtime);
            }
            minimizer.add(new KerberosTime(now.getTime() + this.config.getMaximumRenewableLifetime()));
            minimizer.add(tgt.getRenewTill());
            newTicketBody.setRenewTill((KerberosTime)Collections.min(minimizer));
        }
    }

    private AuthorizationData processAuthorizationData(KdcRequest request, Authenticator authHeader, Ticket tgt) throws KerberosException {
        AuthorizationData authData = null;
        if (request.getEncAuthorizationData() != null) {
            try {
                EncryptionEngine engine = EncryptionEngineFactory.getEncryptionEngineFor((EncryptionKey)authHeader.getSubSessionKey());
                byte[] decryptedAuthData = engine.getDecryptedData(authHeader.getSubSessionKey(), request.getEncAuthorizationData());
                AuthorizationDataDecoder decoder = new AuthorizationDataDecoder();
                authData = decoder.decode(decryptedAuthData);
            }
            catch (KerberosException e) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
            }
            catch (IOException ioe) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
            }
            AuthorizationData ticketData = tgt.getAuthorizationData();
            authData.add(ticketData);
        }
        return authData;
    }

    private void processTransited(EncTicketPartModifier newTicketBody, Ticket tgt) {
        newTicketBody.setTransitedEncoding(tgt.getTransitedEncoding());
    }

    private EncryptedData encryptTicketPart(EncTicketPart newTicketBody, EncryptionKey serverKey, KdcRequest request) throws KerberosException {
        byte[] encodedTicket = null;
        EncTicketPartEncoder encoder = new EncTicketPartEncoder();
        try {
            encodedTicket = encoder.encode(newTicketBody);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (request.getOption(28)) {
            // empty if block
        }
        EncryptionEngine engine = EncryptionEngineFactory.getEncryptionEngineFor((EncryptionKey)serverKey);
        return engine.getEncryptedData(serverKey, encodedTicket);
    }

    private void encryptReplyPart(TicketGrantReply reply, EncryptionKey key) {
        EncTgsRepPartEncoder encoder = new EncTgsRepPartEncoder();
        try {
            byte[] plainText = encoder.encode((KdcReply)reply);
            EncryptionEngine engine = EncryptionEngineFactory.getEncryptionEngineFor((EncryptionKey)key);
            EncryptedData cipherText = engine.getEncryptedData(key, plainText);
            reply.setEncPart(cipherText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TicketGrantReply getReply(Ticket tgt, Ticket newTicket, EncryptionKey sessionKey, KdcRequest request) {
        TicketGrantReply reply = new TicketGrantReply();
        reply.setClientPrincipal(tgt.getClientPrincipal());
        reply.setTicket(newTicket);
        reply.setKey(sessionKey);
        reply.setNonce(request.getNonce());
        reply.setLastRequest(new LastRequest());
        reply.setFlags(newTicket.getFlags());
        reply.setClientAddresses(newTicket.getClientAddresses());
        reply.setAuthTime(newTicket.getAuthTime());
        reply.setStartTime(newTicket.getStartTime());
        reply.setEndTime(newTicket.getEndTime());
        reply.setServerPrincipal(newTicket.getServerPrincipal());
        if (newTicket.getFlag(8)) {
            reply.setRenewTill(newTicket.getRenewTill());
        }
        return reply;
    }
}

