/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.protocol;

import java.io.IOException;
import org.apache.kerberos.exceptions.ErrorType;
import org.apache.kerberos.exceptions.KerberosException;
import org.apache.kerberos.kdc.AuthenticationService;
import org.apache.kerberos.kdc.ErrorService;
import org.apache.kerberos.kdc.TicketGrantingService;
import org.apache.kerberos.messages.AuthenticationReply;
import org.apache.kerberos.messages.ErrorMessage;
import org.apache.kerberos.messages.KdcRequest;
import org.apache.kerberos.messages.TicketGrantReply;
import org.apache.kerberos.service.KdcConfiguration;
import org.apache.kerberos.store.PrincipalStore;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolSession;

public class KerberosProtocolHandler
implements ProtocolHandler {
    private AuthenticationService authService;
    private TicketGrantingService tgsService;
    private ErrorService errorService;

    public KerberosProtocolHandler(KdcConfiguration config, PrincipalStore store) {
        this.errorService = new ErrorService(config);
        this.authService = new AuthenticationService(config, store);
        this.tgsService = new TicketGrantingService(config, store);
    }

    public void sessionOpened(ProtocolSession session) {
        System.out.println(session.getRemoteAddress() + " OPENED");
    }

    public void sessionClosed(ProtocolSession session) {
        System.out.println(session.getRemoteAddress() + " CLOSED");
    }

    public void sessionIdle(ProtocolSession session, IdleStatus status) {
        System.out.println(session.getRemoteAddress() + " IDLE(" + status + ")");
    }

    public void exceptionCaught(ProtocolSession session, Throwable cause) {
        System.out.println(session.getRemoteAddress() + " EXCEPTION");
        cause.printStackTrace(System.out);
        session.close();
    }

    public void messageReceived(ProtocolSession session, Object message) {
        System.out.println(session.getRemoteAddress() + " RCVD: " + message);
        try {
            KdcRequest request = (KdcRequest)message;
            int messageType = request.getMessageType().getOrdinal();
            switch (messageType) {
                case 10: {
                    AuthenticationReply authReply = this.authService.getReplyFor(request);
                    session.write((Object)authReply);
                    break;
                }
                case 12: {
                    TicketGrantReply ticketReply = this.tgsService.getReplyFor(request);
                    session.write((Object)ticketReply);
                    break;
                }
                case 11: 
                case 13: {
                    throw new KerberosException(ErrorType.KRB_AP_ERR_BADDIRECTION);
                }
                default: {
                    throw new KerberosException(ErrorType.KRB_AP_ERR_MSG_TYPE);
                }
            }
        }
        catch (KerberosException ke) {
            System.out.println("Returning error message:  " + ke.getMessage());
            ErrorMessage errorMessage = this.errorService.getReplyFor(ke);
            session.write((Object)errorMessage);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void messageSent(ProtocolSession session, Object message) {
        System.out.println(session.getRemoteAddress() + " SENT: " + message);
    }
}

