/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.protocol;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kerberos.exceptions.ErrorType;
import org.apache.kerberos.exceptions.KerberosException;
import org.apache.kerberos.kdc.AuthenticationService;
import org.apache.kerberos.kdc.ErrorService;
import org.apache.kerberos.kdc.TicketGrantingService;
import org.apache.kerberos.messages.AuthenticationReply;
import org.apache.kerberos.messages.ErrorMessage;
import org.apache.kerberos.messages.KdcRequest;
import org.apache.kerberos.messages.TicketGrantReply;
import org.apache.kerberos.service.KdcConfiguration;
import org.apache.kerberos.store.PrincipalStore;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolSession;

public class KerberosProtocolHandler
implements ProtocolHandler {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$kerberos$protocol$KerberosProtocolHandler == null ? (class$org$apache$kerberos$protocol$KerberosProtocolHandler = KerberosProtocolHandler.class$("org.apache.kerberos.protocol.KerberosProtocolHandler")) : class$org$apache$kerberos$protocol$KerberosProtocolHandler));
    private AuthenticationService authService;
    private TicketGrantingService tgsService;
    private ErrorService errorService;
    static /* synthetic */ Class class$org$apache$kerberos$protocol$KerberosProtocolHandler;

    public KerberosProtocolHandler(KdcConfiguration config, PrincipalStore store) {
        this.errorService = new ErrorService(config);
        this.authService = new AuthenticationService(config, store);
        this.tgsService = new TicketGrantingService(config, store);
    }

    public void sessionCreated(ProtocolSession session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(session.getRemoteAddress() + " CREATED"));
        }
    }

    public void sessionOpened(ProtocolSession session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(session.getRemoteAddress() + " OPENED"));
        }
    }

    public void sessionClosed(ProtocolSession session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(session.getRemoteAddress() + " CLOSED"));
        }
    }

    public void sessionIdle(ProtocolSession session, IdleStatus status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(session.getRemoteAddress() + " IDLE(" + status + ")"));
        }
    }

    public void exceptionCaught(ProtocolSession session, Throwable cause) {
        log.error((Object)(session.getRemoteAddress() + " EXCEPTION"), cause);
        session.close();
    }

    public void messageReceived(ProtocolSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(session.getRemoteAddress() + " RCVD: " + message));
        }
        try {
            KdcRequest request = (KdcRequest)message;
            int messageType = request.getMessageType().getOrdinal();
            switch (messageType) {
                case 10: {
                    AuthenticationReply authReply = this.authService.getReplyFor(request);
                    session.write((Object)authReply);
                    break;
                }
                case 12: {
                    TicketGrantReply ticketReply = this.tgsService.getReplyFor(request);
                    session.write((Object)ticketReply);
                    break;
                }
                case 11: 
                case 13: {
                    throw new KerberosException(ErrorType.KRB_AP_ERR_BADDIRECTION);
                }
                default: {
                    throw new KerberosException(ErrorType.KRB_AP_ERR_MSG_TYPE);
                }
            }
        }
        catch (KerberosException ke) {
            log.error((Object)("Returning error message:  " + ke.getMessage()), (Throwable)ke);
            ErrorMessage errorMessage = this.errorService.getReplyFor(ke);
            session.write((Object)errorMessage);
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
        }
    }

    public void messageSent(ProtocolSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(session.getRemoteAddress() + " SENT: " + message));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

