/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.authz;

import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.common.exception.LdapNoPermissionException;
import org.apache.ldap.common.name.DnParser;
import org.apache.ldap.common.name.NameComponentNormalizer;
import org.apache.ldap.server.SystemPartition;
import org.apache.ldap.server.db.ResultFilteringEnumeration;
import org.apache.ldap.server.db.SearchResultFilter;
import org.apache.ldap.server.interceptor.BaseInterceptor;
import org.apache.ldap.server.interceptor.InterceptorContext;
import org.apache.ldap.server.interceptor.NextInterceptor;
import org.apache.ldap.server.invocation.Delete;
import org.apache.ldap.server.invocation.HasEntry;
import org.apache.ldap.server.invocation.Invocation;
import org.apache.ldap.server.invocation.List;
import org.apache.ldap.server.invocation.Lookup;
import org.apache.ldap.server.invocation.LookupWithAttrIds;
import org.apache.ldap.server.invocation.Modify;
import org.apache.ldap.server.invocation.ModifyMany;
import org.apache.ldap.server.invocation.ModifyRN;
import org.apache.ldap.server.invocation.Move;
import org.apache.ldap.server.invocation.MoveAndModifyRN;
import org.apache.ldap.server.invocation.Search;
import org.apache.ldap.server.jndi.ServerContext;
import org.apache.ldap.server.schema.AttributeTypeRegistry;
import org.apache.ldap.server.schema.ConcreteNameComponentNormalizer;

public class AuthorizationService
extends BaseInterceptor {
    private static final Name ADMIN_DN = SystemPartition.getAdminDn();
    private static final Name USER_BASE_DN = SystemPartition.getUsersBaseDn();
    private static final Name GROUP_BASE_DN = SystemPartition.getGroupsBaseDn();
    private DnParser dnParser;

    public void init(InterceptorContext ctx) throws NamingException {
        AttributeTypeRegistry atr = ctx.getGlobalRegistries().getAttributeTypeRegistry();
        this.dnParser = new DnParser((NameComponentNormalizer)new ConcreteNameComponentNormalizer(atr));
    }

    public void destroy() {
    }

    public void process(NextInterceptor nextInterceptor, Invocation call) throws NamingException {
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, Delete call) throws NamingException {
        Name name = call.getName();
        Name principalDn = BaseInterceptor.getPrincipal(call).getDn();
        if (name.toString().equals("")) {
            String msg = "The rootDSE cannot be deleted!";
            throw new LdapNoPermissionException(msg);
        }
        if (name == ADMIN_DN || name.equals(ADMIN_DN)) {
            String msg = "User " + principalDn;
            msg = String.valueOf(msg) + " does not have permission to delete the admin account.";
            msg = String.valueOf(msg) + " No one not even the admin can delete this account!";
            throw new LdapNoPermissionException(msg);
        }
        if (name.size() > 2 && name.startsWith(USER_BASE_DN) && !principalDn.equals(ADMIN_DN)) {
            String msg = "User " + principalDn;
            msg = String.valueOf(msg) + " does not have permission to delete the user account: ";
            msg = String.valueOf(msg) + name + ". Only the admin can delete user accounts.";
            throw new LdapNoPermissionException(msg);
        }
        if (name.size() > 2 && name.startsWith(GROUP_BASE_DN) && !principalDn.equals(ADMIN_DN)) {
            String msg = "User " + principalDn;
            msg = String.valueOf(msg) + " does not have permission to delete the group entry: ";
            msg = String.valueOf(msg) + name + ". Only the admin can delete groups.";
            throw new LdapNoPermissionException(msg);
        }
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, HasEntry call) throws NamingException {
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, Modify call) throws NamingException {
        this.protectModifyAlterations(call, call.getName());
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, ModifyMany call) throws NamingException {
        this.protectModifyAlterations(call, call.getName());
        nextInterceptor.process(call);
    }

    private void protectModifyAlterations(Invocation call, Name dn) throws LdapNoPermissionException {
        Name principalDn = BaseInterceptor.getPrincipal(call).getDn();
        if (dn.toString().equals("")) {
            String msg = "The rootDSE cannot be modified!";
            throw new LdapNoPermissionException(msg);
        }
        if (!principalDn.equals(ADMIN_DN)) {
            if (dn == ADMIN_DN || dn.equals(ADMIN_DN)) {
                String msg = "User " + principalDn;
                msg = String.valueOf(msg) + " does not have permission to modify the admin account.";
                throw new LdapNoPermissionException(msg);
            }
            if (dn.size() > 2 && dn.startsWith(USER_BASE_DN)) {
                String msg = "User " + principalDn;
                msg = String.valueOf(msg) + " does not have permission to modify the account of the";
                msg = String.valueOf(msg) + " user " + dn + ".\nEven the owner of an account cannot";
                msg = String.valueOf(msg) + " modify it.\nUser accounts can only be modified by the";
                msg = String.valueOf(msg) + " administrator.";
                throw new LdapNoPermissionException(msg);
            }
            if (dn.size() > 2 && dn.startsWith(GROUP_BASE_DN)) {
                String msg = "User " + principalDn;
                msg = String.valueOf(msg) + " does not have permission to modify the group entry ";
                msg = String.valueOf(msg) + dn + ".\nGroups can only be modified by the admin.";
                throw new LdapNoPermissionException(msg);
            }
        }
    }

    protected void process(NextInterceptor nextInterceptor, ModifyRN call) throws NamingException {
        this.protectDnAlterations(call, call.getName());
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, Move call) throws NamingException {
        this.protectDnAlterations(call, call.getName());
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, MoveAndModifyRN call) throws NamingException {
        this.protectDnAlterations(call, call.getName());
        nextInterceptor.process(call);
    }

    private void protectDnAlterations(Invocation call, Name dn) throws LdapNoPermissionException {
        Name principalDn = BaseInterceptor.getPrincipal(call).getDn();
        if (dn.toString().equals("")) {
            String msg = "The rootDSE cannot be moved or renamed!";
            throw new LdapNoPermissionException(msg);
        }
        if (dn == ADMIN_DN || dn.equals(ADMIN_DN)) {
            String msg = "User '" + principalDn;
            msg = String.valueOf(msg) + "' does not have permission to move or rename the admin";
            msg = String.valueOf(msg) + " account.  No one not even the admin can move or";
            msg = String.valueOf(msg) + " rename " + dn + "!";
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && dn.startsWith(USER_BASE_DN) && !principalDn.equals(ADMIN_DN)) {
            String msg = "User '" + principalDn;
            msg = String.valueOf(msg) + "' does not have permission to move or rename the user";
            msg = String.valueOf(msg) + " account: " + dn + ". Only the admin can move or";
            msg = String.valueOf(msg) + " rename user accounts.";
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && dn.startsWith(GROUP_BASE_DN) && !principalDn.equals(ADMIN_DN)) {
            String msg = "User " + principalDn;
            msg = String.valueOf(msg) + " does not have permission to move or rename the group entry ";
            msg = String.valueOf(msg) + dn + ".\nGroups can only be moved or renamed by the admin.";
            throw new LdapNoPermissionException(msg);
        }
    }

    protected void process(NextInterceptor nextInterceptor, Lookup call) throws NamingException {
        super.process(nextInterceptor, call);
        Attributes attributes = (Attributes)call.getReturnValue();
        if (attributes == null) {
            return;
        }
        Attributes retval = (Attributes)attributes.clone();
        LdapContext ctx = (LdapContext)call.getContextStack().peek();
        this.protectLookUp(ctx, call.getName());
        call.setReturnValue(retval);
    }

    protected void process(NextInterceptor nextInterceptor, LookupWithAttrIds call) throws NamingException {
        super.process(nextInterceptor, call);
        Attributes attributes = (Attributes)call.getReturnValue();
        if (attributes == null) {
            return;
        }
        Attributes retval = (Attributes)attributes.clone();
        LdapContext ctx = (LdapContext)call.getContextStack().peek();
        this.protectLookUp(ctx, call.getName());
        call.setReturnValue(retval);
    }

    private void protectLookUp(LdapContext ctx, Name dn) throws NamingException {
        Name principalDn = ((ServerContext)((Object)ctx)).getPrincipal().getDn();
        if (!principalDn.equals(ADMIN_DN)) {
            if (dn.size() > 2 && dn.startsWith(USER_BASE_DN)) {
                if (dn.toString().equals(principalDn.toString())) {
                    return;
                }
                String msg = "Access to user account '" + dn + "' not permitted";
                msg = String.valueOf(msg) + " for user '" + principalDn + "'.  Only the admin can";
                msg = String.valueOf(msg) + " access user account information";
                throw new LdapNoPermissionException(msg);
            }
            if (dn.size() > 2 && dn.startsWith(GROUP_BASE_DN)) {
                if (dn.toString().equals(principalDn.toString())) {
                    return;
                }
                String msg = "Access to group '" + dn + "' not permitted";
                msg = String.valueOf(msg) + " for user '" + principalDn + "'.  Only the admin can";
                msg = String.valueOf(msg) + " access group information";
                throw new LdapNoPermissionException(msg);
            }
            if (dn.equals(ADMIN_DN)) {
                if (dn.toString().equals(principalDn.toString())) {
                    return;
                }
                String msg = "Access to admin account not permitted for user '";
                msg = String.valueOf(msg) + principalDn + "'.  Only the admin can";
                msg = String.valueOf(msg) + " access admin account information";
                throw new LdapNoPermissionException(msg);
            }
        }
    }

    protected void process(NextInterceptor nextInterceptor, Search call) throws NamingException {
        super.process(nextInterceptor, call);
        SearchControls searchControls = call.getControls();
        if (searchControls.getReturningAttributes() != null) {
            return;
        }
        LdapContext ctx = (LdapContext)call.getContextStack().peek();
        NamingEnumeration e = (NamingEnumeration)call.getReturnValue();
        ResultFilteringEnumeration retval = new ResultFilteringEnumeration(e, searchControls, ctx, new SearchResultFilter(){

            public boolean accept(LdapContext ctx, SearchResult result, SearchControls controls) throws NamingException {
                return AuthorizationService.this.isSearchable(ctx, result);
            }
        });
        call.setReturnValue(retval);
    }

    protected void process(NextInterceptor nextInterceptor, List call) throws NamingException {
        super.process(nextInterceptor, call);
        LdapContext ctx = (LdapContext)call.getContextStack().peek();
        NamingEnumeration e = (NamingEnumeration)call.getReturnValue();
        ResultFilteringEnumeration retval = new ResultFilteringEnumeration(e, null, ctx, new SearchResultFilter(){

            public boolean accept(LdapContext ctx, SearchResult result, SearchControls controls) throws NamingException {
                return AuthorizationService.this.isSearchable(ctx, result);
            }
        });
        call.setReturnValue(retval);
    }

    private boolean isSearchable(LdapContext ctx, SearchResult result) throws NamingException {
        Name dn;
        DnParser dnParser = this.dnParser;
        synchronized (dnParser) {
            dn = this.dnParser.parse(result.getName());
        }
        Name principalDn = ((ServerContext)((Object)ctx)).getPrincipal().getDn();
        if (!principalDn.equals(ADMIN_DN)) {
            if (dn.size() > 2 && (dn.startsWith(USER_BASE_DN) || dn.startsWith(GROUP_BASE_DN))) {
                return false;
            }
            if (dn.equals(ADMIN_DN)) {
                return false;
            }
        }
        return true;
    }
}

