/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db;

import java.math.BigInteger;
import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.ldap.common.filter.AssertionNode;
import org.apache.ldap.common.filter.BranchNode;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.LeafNode;
import org.apache.ldap.common.filter.PresenceNode;
import org.apache.ldap.common.filter.ScopeNode;
import org.apache.ldap.common.filter.SimpleNode;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.Index;
import org.apache.ldap.server.db.Optimizer;

public class DefaultOptimizer
implements Optimizer {
    private static final BigInteger MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private Database db;

    public DefaultOptimizer(Database db) {
        this.db = db;
    }

    public void annotate(ExprNode node) throws NamingException {
        BigInteger count;
        block16: {
            block17: {
                block15: {
                    count = MAX;
                    if (!(node instanceof ScopeNode)) break block15;
                    count = this.getScopeScan((ScopeNode)node);
                    break block16;
                }
                if (node instanceof AssertionNode) break block16;
                if (!node.isLeaf()) break block17;
                LeafNode leaf = (LeafNode)node;
                switch (leaf.getAssertionType()) {
                    case 5: {
                        count = this.getEqualityScan((SimpleNode)leaf);
                        break block16;
                    }
                    case 0: {
                        count = this.getEqualityScan((SimpleNode)leaf);
                        break block16;
                    }
                    case 6: {
                        count = this.getFullScan(leaf);
                        break block16;
                    }
                    case 3: {
                        count = this.getGreaterLessScan((SimpleNode)leaf, true);
                        break block16;
                    }
                    case 4: {
                        count = this.getGreaterLessScan((SimpleNode)leaf, false);
                        break block16;
                    }
                    case 1: {
                        count = this.getPresenceScan((PresenceNode)leaf);
                        break block16;
                    }
                    case 2: {
                        count = this.getFullScan(leaf);
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized leaf node");
                    }
                }
            }
            BranchNode bnode = (BranchNode)node;
            switch (bnode.getOperator()) {
                case 10: {
                    count = this.getConjunctionScan(bnode);
                    break;
                }
                case 11: {
                    count = this.getNegationScan(bnode);
                    break;
                }
                case 9: {
                    count = this.getDisjunctionScan(bnode);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized branch node type");
                }
            }
        }
        if (count.compareTo(BigInteger.ZERO) < 0) {
            count = MAX;
        }
        node.set((Object)"count", (Object)count);
    }

    private BigInteger getConjunctionScan(BranchNode node) throws NamingException {
        BigInteger count = BigInteger.valueOf(Integer.MAX_VALUE);
        ArrayList children = node.getChildren();
        int ii = 0;
        while (ii < children.size()) {
            ExprNode child = (ExprNode)children.get(ii);
            this.annotate(child);
            count = ((BigInteger)child.get((Object)"count")).min(count);
            ++ii;
        }
        return count;
    }

    private BigInteger getNegationScan(BranchNode node) throws NamingException {
        ExprNode onlyChild = (ExprNode)node.getChildren().get(0);
        this.annotate(onlyChild);
        if (onlyChild.isLeaf() && !(onlyChild instanceof ScopeNode) && !(onlyChild instanceof AssertionNode) && !(onlyChild instanceof PresenceNode)) {
            LeafNode leaf = (LeafNode)onlyChild;
            Index idx = this.db.getUserIndex(leaf.getAttribute());
            return BigInteger.valueOf(idx.count());
        }
        return BigInteger.valueOf(this.db.count());
    }

    private BigInteger getDisjunctionScan(BranchNode node) throws NamingException {
        ArrayList children = node.getChildren();
        BigInteger total = BigInteger.ZERO;
        int ii = 0;
        while (ii < children.size()) {
            ExprNode child = (ExprNode)children.get(ii);
            this.annotate(child);
            total = total.add((BigInteger)child.get((Object)"count"));
            ++ii;
        }
        return total;
    }

    private BigInteger getEqualityScan(SimpleNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            return BigInteger.valueOf(idx.count(node.getValue()));
        }
        return MAX;
    }

    private BigInteger getGreaterLessScan(SimpleNode node, boolean isGreaterThan) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            int count = idx.count(node.getValue(), isGreaterThan);
            return BigInteger.valueOf(count);
        }
        return MAX;
    }

    private BigInteger getFullScan(LeafNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            int count = idx.count();
            return BigInteger.valueOf(count);
        }
        return MAX;
    }

    private BigInteger getPresenceScan(PresenceNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getExistanceIndex();
            int count = idx.count(node.getAttribute());
            return BigInteger.valueOf(count);
        }
        return MAX;
    }

    private BigInteger getScopeScan(ScopeNode node) throws NamingException {
        switch (node.getScope()) {
            case 0: {
                return BigInteger.ONE;
            }
            case 1: {
                BigInteger id = this.db.getEntryId(node.getBaseDn());
                return BigInteger.valueOf(this.db.getChildCount(id));
            }
            case 2: {
                return BigInteger.valueOf(this.db.count());
            }
        }
        throw new IllegalArgumentException("Unrecognized search scope value for filter scope node");
    }
}

