/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db;

import java.math.BigInteger;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.ldap.common.filter.BranchNode;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.ScopeNode;
import org.apache.ldap.common.message.DerefAliasesEnum;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.DefaultOptimizer;
import org.apache.ldap.server.db.ExpressionEnumerator;
import org.apache.ldap.server.db.ExpressionEvaluator;
import org.apache.ldap.server.db.IndexRecord;
import org.apache.ldap.server.db.Optimizer;
import org.apache.ldap.server.db.SearchEngine;

public class DefaultSearchEngine
implements SearchEngine {
    private final Optimizer optimizer;
    private Database db;
    private ExpressionEvaluator evaluator;
    private ExpressionEnumerator enumerator;

    public DefaultSearchEngine(Database db, ExpressionEvaluator evaluator, ExpressionEnumerator enumerator) {
        this.db = db;
        this.evaluator = evaluator;
        this.enumerator = enumerator;
        this.optimizer = new DefaultOptimizer(db);
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public NamingEnumeration search(Name base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        Object effectiveBase = null;
        BigInteger baseId = this.db.getEntryId(base.toString());
        String aliasedBase = (String)this.db.getAliasIndex().reverseLookup(baseId);
        DerefAliasesEnum mode = DerefAliasesEnum.getEnum((Map)env);
        effectiveBase = aliasedBase == null || !mode.derefFindingBase() ? base : (aliasedBase != null ? new LdapName(aliasedBase) : base);
        BranchNode root = new BranchNode(10);
        ScopeNode node = new ScopeNode(env, effectiveBase.toString(), searchCtls.getSearchScope());
        root.getChildren().add(node);
        root.getChildren().add(filter);
        this.optimizer.annotate((ExprNode)root);
        return this.enumerator.enumerate((ExprNode)root);
    }

    public boolean evaluate(ExprNode ilter, BigInteger id) throws NamingException {
        IndexRecord rec = new IndexRecord();
        rec.setEntryId(id);
        return this.evaluator.evaluate(ilter, rec);
    }
}

