/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db;

import java.util.Comparator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.ldap.common.NotImplementedException;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.LeafNode;
import org.apache.ldap.common.filter.PresenceNode;
import org.apache.ldap.common.filter.ScopeNode;
import org.apache.ldap.common.filter.SimpleNode;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.schema.MatchingRule;
import org.apache.ldap.common.schema.Normalizer;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.Evaluator;
import org.apache.ldap.server.db.Index;
import org.apache.ldap.server.db.IndexRecord;
import org.apache.ldap.server.db.ScopeEvaluator;
import org.apache.ldap.server.db.SubstringEvaluator;
import org.apache.ldap.server.schema.AttributeTypeRegistry;
import org.apache.ldap.server.schema.OidRegistry;

public class LeafEvaluator
implements Evaluator {
    private static final int EQUALITY_MATCH = 0;
    private static final int ORDERING_MATCH = 1;
    private static final int SUBSTRING_MATCH = 3;
    private Database db;
    private OidRegistry oidRegistry;
    private AttributeTypeRegistry attributeTypeRegistry;
    private SubstringEvaluator substringEvaluator;
    private ScopeEvaluator scopeEvaluator;

    public LeafEvaluator(Database db, OidRegistry oidRegistry, AttributeTypeRegistry attributeTypeRegistry, ScopeEvaluator scopeEvaluator, SubstringEvaluator substringEvaluator) {
        this.db = db;
        this.oidRegistry = oidRegistry;
        this.attributeTypeRegistry = attributeTypeRegistry;
        this.scopeEvaluator = scopeEvaluator;
        this.substringEvaluator = substringEvaluator;
    }

    public ScopeEvaluator getScopeEvaluator() {
        return this.scopeEvaluator;
    }

    public SubstringEvaluator getSubstringEvaluator() {
        return this.substringEvaluator;
    }

    public boolean evaluate(ExprNode node, IndexRecord record) throws NamingException {
        if (node instanceof ScopeNode) {
            return this.scopeEvaluator.evaluate(node, record);
        }
        switch (((LeafNode)node).getAssertionType()) {
            case 5: {
                return this.evalEquality((SimpleNode)node, record);
            }
            case 0: {
                return this.evalEquality((SimpleNode)node, record);
            }
            case 6: {
                throw new NotImplementedException();
            }
            case 3: {
                return this.evalGreater((SimpleNode)node, record, true);
            }
            case 4: {
                return this.evalGreater((SimpleNode)node, record, false);
            }
            case 1: {
                String attrId = ((PresenceNode)node).getAttribute();
                return this.evalPresence(attrId, record);
            }
            case 2: {
                return this.substringEvaluator.evaluate(node, record);
            }
        }
        throw new NamingException("Unrecognized leaf node type: " + ((LeafNode)node).getAssertionType());
    }

    /*
     * Unable to fully structure code
     */
    private boolean evalGreater(SimpleNode node, IndexRecord record, boolean isGreater) throws NamingException {
        block6: {
            attrId = node.getAttribute();
            id = record.getEntryId();
            if (this.db.hasUserIndexOn(attrId)) {
                idx = this.db.getUserIndex(attrId);
                if (isGreater) {
                    return idx.hasValue(node.getValue(), id, true);
                }
                return idx.hasValue(node.getValue(), id, false);
            }
            if (record.getAttributes() == null) {
                record.setAttributes(this.db.lookup(id));
            }
            if ((attr = record.getAttributes().get(attrId)) == null) {
                return false;
            }
            normalizer = this.getNormalizer(attrId);
            comparator = this.getComparator(attrId);
            filterValue = normalizer.normalize((Object)node.getValue());
            list = attr.getAll();
            if (!isGreater) ** GOTO lbl25
            while (list.hasMore()) {
                value = normalizer.normalize(list.next());
                if (comparator.compare(value, filterValue) > 0) continue;
                return true;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                value = normalizer.normalize(list.next());
                if (comparator.compare(value, filterValue) < 0) continue;
                return true;
lbl25:
                // 2 sources

                ** while (list.hasMore())
            }
        }
        return false;
    }

    private boolean evalPresence(String attrId, IndexRecord rec) throws NamingException {
        Attributes attrs;
        if (this.db.hasUserIndexOn(attrId)) {
            Index idx = this.db.getExistanceIndex();
            return idx.hasValue(attrId, rec.getEntryId());
        }
        if (rec.getAttributes() == null) {
            rec.setAttributes(this.db.lookup(rec.getEntryId()));
        }
        if ((attrs = rec.getAttributes()) == null) {
            return false;
        }
        return attrs.get(attrId) != null;
    }

    private boolean evalEquality(SimpleNode node, IndexRecord rec) throws NamingException {
        Attribute attr;
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            return idx.hasValue(node.getValue(), rec.getEntryId());
        }
        Normalizer normalizer = this.getNormalizer(node.getAttribute());
        Comparator comparator = this.getComparator(node.getAttribute());
        if (rec.getAttributes() == null) {
            rec.setAttributes(this.db.lookup(rec.getEntryId()));
        }
        if ((attr = rec.getAttributes().get(node.getAttribute())) == null) {
            return false;
        }
        if (attr.contains(node.getValue())) {
            return true;
        }
        Object filterValue = normalizer.normalize((Object)node.getValue());
        if (attr.contains(filterValue)) {
            return true;
        }
        NamingEnumeration<?> list = attr.getAll();
        while (list.hasMore()) {
            Object value = normalizer.normalize(list.next());
            if (comparator.compare(value, filterValue) != 0) continue;
            return true;
        }
        return false;
    }

    private Comparator getComparator(String attrId) throws NamingException {
        MatchingRule mrule = this.getMatchingRule(attrId, 0);
        return mrule.getComparator();
    }

    private Normalizer getNormalizer(String attrId) throws NamingException {
        MatchingRule mrule = this.getMatchingRule(attrId, 0);
        return mrule.getNormalizer();
    }

    private MatchingRule getMatchingRule(String attrId, int matchType) throws NamingException {
        MatchingRule mrule = null;
        String oid = this.oidRegistry.getOid(attrId);
        AttributeType type = this.attributeTypeRegistry.lookup(oid);
        switch (matchType) {
            case 0: {
                mrule = type.getEquality();
                break;
            }
            case 3: {
                mrule = type.getSubstr();
                break;
            }
            case 1: {
                mrule = type.getOrdering();
                break;
            }
            default: {
                throw new NamingException("Unknown match type: " + matchType);
            }
        }
        return mrule;
    }
}

