/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db;

import java.math.BigInteger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.ScopeNode;
import org.apache.ldap.common.util.SingletonEnumeration;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.DisjunctionEnumeration;
import org.apache.ldap.server.db.Enumerator;
import org.apache.ldap.server.db.Index;
import org.apache.ldap.server.db.IndexAssertion;
import org.apache.ldap.server.db.IndexAssertionEnumeration;
import org.apache.ldap.server.db.IndexEnumeration;
import org.apache.ldap.server.db.IndexRecord;
import org.apache.ldap.server.db.ScopeEvaluator;

public class ScopeEnumerator
implements Enumerator {
    private Database db = null;
    private ScopeEvaluator evaluator = null;

    public ScopeEnumerator(Database db, ScopeEvaluator evaluator) {
        this.db = db;
        this.evaluator = evaluator;
    }

    public NamingEnumeration enumerate(ExprNode node) throws NamingException {
        ScopeNode snode = (ScopeNode)node;
        BigInteger id = this.db.getEntryId(snode.getBaseDn());
        switch (snode.getScope()) {
            case 0: {
                IndexRecord record = new IndexRecord();
                record.setEntryId(id);
                record.setIndexKey(snode.getBaseDn());
                return new SingletonEnumeration((Object)record);
            }
            case 1: {
                return this.enumerateChildren(snode.getBaseDn(), snode.getDerefAliases().derefInSearching());
            }
            case 2: {
                return this.enumerateDescendants(snode);
            }
        }
        throw new NamingException("Unrecognized search scope!");
    }

    private NamingEnumeration enumerateChildren(String dn, boolean deref) throws NamingException {
        Index idx = this.db.getHierarchyIndex();
        BigInteger id = this.db.getEntryId(dn);
        IndexEnumeration children = idx.listIndices(id);
        if (!deref) {
            return children;
        }
        idx = this.db.getOneAliasIndex();
        IndexEnumeration aliasIntroduced = idx.listIndices(id);
        IndexAssertionEnumeration nonAliasChildren = new IndexAssertionEnumeration(children, new AssertNotAlias());
        NamingEnumeration[] all = new NamingEnumeration[]{nonAliasChildren, aliasIntroduced};
        return new DisjunctionEnumeration(all);
    }

    private NamingEnumeration enumerateDescendants(final ScopeNode node) throws NamingException {
        Index idx = null;
        if (!node.getDerefAliases().derefInSearching()) {
            idx = this.db.getNdnIndex();
            IndexEnumeration underlying = idx.listIndices();
            return new IndexAssertionEnumeration(underlying, new AssertDescendant(node));
        }
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord rec) throws NamingException {
                return ScopeEnumerator.this.evaluator.evaluate((ExprNode)node, rec);
            }
        };
        idx = this.db.getNdnIndex();
        IndexEnumeration underlying = idx.listIndices();
        return new IndexAssertionEnumeration(underlying, assertion);
    }

    class AssertDescendant
    implements IndexAssertion {
        private final ScopeNode scope;

        AssertDescendant(ScopeNode node) {
            this.scope = node;
        }

        public boolean assertCandidate(IndexRecord record) throws NamingException {
            String dn = ScopeEnumerator.this.db.getEntryDn(record.getEntryId());
            return dn.endsWith(this.scope.getBaseDn());
        }
    }

    class AssertNotAlias
    implements IndexAssertion {
        AssertNotAlias() {
        }

        public boolean assertCandidate(IndexRecord record) throws NamingException {
            Index aliasIdx = ScopeEnumerator.this.db.getAliasIndex();
            return aliasIdx.reverseLookup(record.getEntryId()) == null;
        }
    }
}

