/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.SubstringNode;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.schema.Normalizer;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.Enumerator;
import org.apache.ldap.server.db.Index;
import org.apache.ldap.server.db.IndexAssertion;
import org.apache.ldap.server.db.IndexAssertionEnumeration;
import org.apache.ldap.server.db.IndexEnumeration;
import org.apache.ldap.server.db.IndexRecord;
import org.apache.ldap.server.db.SubstringEvaluator;
import org.apache.ldap.server.schema.AttributeTypeRegistry;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class SubstringEnumerator
implements Enumerator {
    private final Database db;
    private final SubstringEvaluator evaluator;
    private final AttributeTypeRegistry attributeTypeRegistry;

    public SubstringEnumerator(Database db, AttributeTypeRegistry attributeTypeRegistry, SubstringEvaluator evaluator) {
        this.db = db;
        this.evaluator = evaluator;
        this.attributeTypeRegistry = attributeTypeRegistry;
    }

    public NamingEnumeration enumerate(final ExprNode node) throws NamingException {
        RE regex = null;
        Index idx = null;
        SubstringNode snode = (SubstringNode)node;
        AttributeType type = this.attributeTypeRegistry.lookup(snode.getAttribute());
        Normalizer normalizer = type.getSubstr().getNormalizer();
        if (this.db.hasUserIndexOn(snode.getAttribute())) {
            try {
                regex = snode.getRegex(normalizer);
            }
            catch (RESyntaxException e) {
                NamingException ne = new NamingException("SubstringNode '" + node + "' had incorrect syntax");
                ne.setRootCause(e);
                throw ne;
            }
            idx = this.db.getUserIndex(snode.getAttribute());
            if (snode.getInitial() == null) {
                return idx.listIndices(regex);
            }
            return idx.listIndices(regex, snode.getInitial());
        }
        IndexEnumeration underlying = this.db.getNdnIndex().listIndices();
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord record) throws NamingException {
                return SubstringEnumerator.this.evaluator.evaluate(node, record);
            }
        };
        return new IndexAssertionEnumeration(underlying, assertion);
    }
}

