/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db.jdbm;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import jdbm.RecordManager;
import jdbm.helper.CachePolicy;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.ldap.common.MultiException;
import org.apache.ldap.common.exception.LdapNameNotFoundException;
import org.apache.ldap.common.exception.LdapSchemaViolationException;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.schema.Normalizer;
import org.apache.ldap.common.util.NamespaceTools;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.Index;
import org.apache.ldap.server.db.IndexAssertion;
import org.apache.ldap.server.db.IndexAssertionEnumeration;
import org.apache.ldap.server.db.IndexEnumeration;
import org.apache.ldap.server.db.IndexNotFoundException;
import org.apache.ldap.server.db.IndexRecord;
import org.apache.ldap.server.db.jdbm.JdbmIndex;
import org.apache.ldap.server.db.jdbm.JdbmMasterTable;

public class JdbmDatabase
implements Database {
    private final RecordManager recMan;
    private final Name upSuffix;
    private final Name normSuffix;
    private final String wkdir;
    private final JdbmMasterTable master;
    private final Map indices;
    private final Map sysIndices;
    private boolean closed = false;
    private Index ndnIdx;
    private Index updnIdx;
    private Index existanceIdx;
    private Index hierarchyIdx;
    private Index oneAliasIdx;
    private Index subAliasIdx;
    private Index aliasIdx;

    public JdbmDatabase(Name upSuffix, Name normSuffix, String wkdirPath) throws NamingException {
        this.upSuffix = upSuffix;
        this.normSuffix = normSuffix;
        this.wkdir = wkdirPath;
        try {
            String path = String.valueOf(wkdirPath) + File.separator + "master";
            BaseRecordManager base = new BaseRecordManager(path);
            base.disableTransactions();
            this.recMan = new CacheRecordManager((RecordManager)base, (CachePolicy)new MRU(1000));
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Could not initialize RecordManager");
            ne.setRootCause(e);
            throw ne;
        }
        this.master = new JdbmMasterTable(this.recMan);
        this.indices = new HashMap();
        this.sysIndices = new HashMap();
    }

    public void addIndexOn(AttributeType spec) throws NamingException {
        JdbmIndex idx = new JdbmIndex(spec, this.wkdir);
        this.indices.put(spec.getName().toLowerCase(), idx);
    }

    public Index getExistanceIndex() {
        return this.existanceIdx;
    }

    public void setExistanceIndexOn(AttributeType attrType) throws NamingException {
        if (this.existanceIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.existanceIdx = new JdbmIndex(attrType, this.wkdir);
        this.sysIndices.put(attrType.getName().toLowerCase(), this.existanceIdx);
    }

    public Index getHierarchyIndex() {
        return this.hierarchyIdx;
    }

    public void setHierarchyIndexOn(AttributeType attrType) throws NamingException {
        if (this.hierarchyIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.hierarchyIdx = new JdbmIndex(attrType, this.wkdir);
        this.sysIndices.put(attrType.getName().toLowerCase(), this.hierarchyIdx);
    }

    public Index getAliasIndex() {
        return this.aliasIdx;
    }

    public void setAliasIndexOn(AttributeType attrType) throws NamingException {
        if (this.aliasIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.aliasIdx = new JdbmIndex(attrType, this.wkdir);
        this.sysIndices.put(attrType.getName().toLowerCase(), this.aliasIdx);
    }

    public Index getOneAliasIndex() {
        return this.oneAliasIdx;
    }

    public void setOneAliasIndexOn(AttributeType attrType) throws NamingException {
        if (this.oneAliasIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.oneAliasIdx = new JdbmIndex(attrType, this.wkdir);
        this.sysIndices.put(attrType.getName().toLowerCase(), this.oneAliasIdx);
    }

    public Index getSubAliasIndex() {
        return this.subAliasIdx;
    }

    public void setSubAliasIndexOn(AttributeType attrType) throws NamingException {
        if (this.subAliasIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.subAliasIdx = new JdbmIndex(attrType, this.wkdir);
        this.sysIndices.put(attrType.getName().toLowerCase(), this.subAliasIdx);
    }

    public Index getUpdnIndex() {
        return this.updnIdx;
    }

    public void setUpdnIndexOn(AttributeType attrType) throws NamingException {
        if (this.updnIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.updnIdx = new JdbmIndex(attrType, this.wkdir);
        this.sysIndices.put(attrType.getName().toLowerCase(), this.updnIdx);
    }

    public Index getNdnIndex() {
        return this.ndnIdx;
    }

    public void setNdnIndexOn(AttributeType attrType) throws NamingException {
        if (this.ndnIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.ndnIdx = new JdbmIndex(attrType, this.wkdir);
        this.sysIndices.put(attrType.getName().toLowerCase(), this.ndnIdx);
    }

    public Iterator getUserIndices() {
        return this.indices.keySet().iterator();
    }

    public Iterator getSystemIndices() {
        return this.sysIndices.keySet().iterator();
    }

    public boolean hasUserIndexOn(String attribute) {
        return this.indices.containsKey(attribute) || this.indices.containsKey(attribute.toLowerCase());
    }

    public boolean hasSystemIndexOn(String attribute) {
        return this.sysIndices.containsKey(attribute) || this.sysIndices.containsKey(attribute.toLowerCase());
    }

    public Index getUserIndex(String attribute) throws IndexNotFoundException {
        String lowerCased = attribute.toLowerCase();
        if (this.indices.containsKey(attribute)) {
            return (Index)this.indices.get(attribute);
        }
        if (this.indices.containsKey(lowerCased)) {
            return (Index)this.indices.get(lowerCased);
        }
        throw new IndexNotFoundException("An index on attribute " + attribute + " does not exist!");
    }

    public Index getSystemIndex(String indexName) throws IndexNotFoundException {
        String lowerCased = indexName.toLowerCase();
        if (this.sysIndices.containsKey(indexName)) {
            return (Index)this.sysIndices.get(indexName);
        }
        if (this.sysIndices.containsKey(lowerCased)) {
            return (Index)this.sysIndices.get(lowerCased);
        }
        throw new IndexNotFoundException("A system index by the name of " + indexName + " does not exist!");
    }

    public BigInteger getEntryId(String dn) throws NamingException {
        return this.ndnIdx.forwardLookup(dn);
    }

    public String getEntryDn(BigInteger id) throws NamingException {
        return (String)this.ndnIdx.reverseLookup(id);
    }

    public BigInteger getParentId(String dn) throws NamingException {
        BigInteger childId = this.ndnIdx.forwardLookup(dn);
        return (BigInteger)this.hierarchyIdx.reverseLookup(childId);
    }

    public BigInteger getParentId(BigInteger childId) throws NamingException {
        return (BigInteger)this.hierarchyIdx.reverseLookup(childId);
    }

    public String getEntryUpdn(BigInteger id) throws NamingException {
        return (String)this.updnIdx.reverseLookup(id);
    }

    public String getEntryUpdn(String dn) throws NamingException {
        BigInteger id = this.ndnIdx.forwardLookup(dn);
        return (String)this.updnIdx.reverseLookup(id);
    }

    public int count() throws NamingException {
        return this.master.count();
    }

    private void dropAliasIndices(BigInteger aliasId) throws NamingException {
        String targetDn = (String)this.aliasIdx.reverseLookup(aliasId);
        BigInteger targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        Name ancestorDn = new LdapName(aliasDn).getSuffix(1);
        BigInteger ancestorId = this.getEntryId(ancestorDn.toString());
        this.oneAliasIdx.drop(ancestorId, targetId);
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals(this.upSuffix)) {
            ancestorDn = ancestorDn.getSuffix(1);
            ancestorId = this.getEntryId(ancestorDn.toString());
            this.subAliasIdx.drop(ancestorId, targetId);
        }
        this.aliasIdx.drop(aliasId);
    }

    private void addAliasIndices(BigInteger aliasId, Name aliasDn, String aliasTarget) throws NamingException {
        LdapName targetDn = null;
        BigInteger targetId = null;
        Normalizer normalizer = null;
        Name ancestorDn = null;
        BigInteger ancestorId = null;
        normalizer = this.oneAliasIdx.getAttribute().getEquality().getNormalizer();
        targetDn = new LdapName((String)normalizer.normalize((Object)aliasTarget));
        if (aliasDn.startsWith((Name)targetDn)) {
            if (aliasDn.equals(targetDn)) {
                throw new NamingException("[36] aliasDereferencingProblem - attempt to create alias to itself.");
            }
            throw new NamingException("[36] aliasDereferencingProblem - attempt to create alias with cycle to relative " + aliasTarget + " not allowed from descendent alias " + aliasDn);
        }
        if (!targetDn.startsWith(this.upSuffix)) {
            throw new NamingException("[36] aliasDereferencingProblem - the alias points to an entry outside of the " + this.upSuffix + " namingContext to an object whose existance cannot be" + " determined.");
        }
        targetId = this.ndnIdx.forwardLookup(targetDn.toString());
        if (targetId == null) {
            throw new NamingException("[33] aliasProblem - the alias when dereferenced would not name a known object the aliasedObjectName must be set to a valid existing entry.");
        }
        if (this.aliasIdx.reverseLookup(targetId) != null) {
            throw new NamingException("[36] aliasDereferencingProblem - the alias points to another alias.  Alias chaining is not supported by this backend.");
        }
        this.aliasIdx.add(aliasTarget, aliasId);
        ancestorDn = aliasDn.getSuffix(1);
        ancestorId = this.getEntryId(ancestorDn.toString());
        if (!NamespaceTools.isSibling((Name)targetDn, (Name)aliasDn)) {
            this.oneAliasIdx.add(ancestorId, targetId);
        }
        while (!ancestorDn.equals(this.upSuffix) && ancestorId != null) {
            if (!NamespaceTools.isDescendant((Name)ancestorDn, (Name)targetDn)) {
                this.subAliasIdx.add(ancestorId, targetId);
            }
            ancestorDn = ancestorDn.getSuffix(1);
            ancestorId = this.getEntryId(ancestorDn.toString());
        }
    }

    public void add(String updn, Name dn, Attributes entry) throws NamingException {
        BigInteger parentId = null;
        BigInteger id = this.master.getNextId();
        parentId = dn.equals(this.normSuffix) ? BigInteger.ZERO : this.getEntryId(dn.getSuffix(1).toString());
        if (parentId == null) {
            throw new LdapNameNotFoundException("Id for parent '" + dn.getSuffix(1).toString() + "' not found!");
        }
        Attribute objectClass = entry.get("objectClass");
        if (objectClass == null) {
            String msg = "Entry " + updn + " contains no objectClass attribute: " + entry;
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECTCLASSVIOLATION);
        }
        if (entry.get("objectClass").contains("alias")) {
            this.addAliasIndices(id, dn, (String)entry.get("aliasedObjectName").get());
        }
        this.ndnIdx.add(dn.toString(), id);
        this.updnIdx.add(updn, id);
        this.hierarchyIdx.add(parentId, id);
        NamingEnumeration<String> list = entry.getIDs();
        while (list.hasMore()) {
            String attribute = list.next();
            if (!this.hasUserIndexOn(attribute)) continue;
            Index idx = this.getUserIndex(attribute);
            NamingEnumeration<?> values = entry.get(attribute).getAll();
            while (values.hasMore()) {
                idx.add(values.next(), id);
            }
            this.existanceIdx.add(attribute.toLowerCase(), id);
        }
        this.master.put(entry, id);
    }

    public Attributes lookup(BigInteger id) throws NamingException {
        return this.master.get(id);
    }

    public void delete(BigInteger id) throws NamingException {
        Attributes entry = this.lookup(id);
        BigInteger parentId = this.getParentId(id);
        NamingEnumeration<String> attrs = entry.getIDs();
        if (entry.get("objectClass").contains("alias")) {
            this.dropAliasIndices(id);
        }
        this.ndnIdx.drop(id);
        this.updnIdx.drop(id);
        this.hierarchyIdx.drop(id);
        if (!parentId.equals(BigInteger.ZERO)) {
            this.hierarchyIdx.drop(parentId, id);
        }
        while (attrs.hasMore()) {
            String attr = attrs.next();
            if (!this.hasUserIndexOn(attr)) continue;
            Index index = this.getUserIndex(attr);
            NamingEnumeration<?> values = entry.get(attr).getAll();
            while (values.hasMore()) {
                index.drop(values.next(), id);
            }
            this.existanceIdx.drop(attr.toLowerCase(), id);
        }
        this.master.delete(id);
    }

    public NamingEnumeration list(BigInteger id) throws NamingException {
        return this.hierarchyIdx.listIndices(id);
    }

    public int getChildCount(BigInteger id) throws NamingException {
        return this.hierarchyIdx.count(id);
    }

    public Name getSuffix() {
        return this.upSuffix;
    }

    public Attributes getSuffixEntry() throws NamingException {
        BigInteger id = this.getEntryId(this.upSuffix.toString());
        if (id == null) {
            return null;
        }
        return this.lookup(id);
    }

    public void sync() throws NamingException {
        ArrayList<Object> array = new ArrayList<Object>();
        array.addAll(this.indices.values());
        array.add(this.ndnIdx);
        array.add(this.updnIdx);
        array.add(this.aliasIdx);
        array.add(this.oneAliasIdx);
        array.add(this.subAliasIdx);
        array.add(this.hierarchyIdx);
        array.add(this.existanceIdx);
        Iterator list = array.iterator();
        MultiException rootCause = null;
        while (list.hasNext()) {
            Index idx = (Index)list.next();
            try {
                idx.sync();
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (rootCause == null) {
                    rootCause = new MultiException();
                }
                rootCause.addThrowable(t);
            }
        }
        try {
            this.master.sync();
            this.recMan.commit();
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (rootCause == null) {
                rootCause = new MultiException();
            }
            rootCause.addThrowable(t);
        }
        if (rootCause != null) {
            NamingException ne = new NamingException("Failed to sync all");
            ne.setRootCause((Throwable)rootCause);
            throw ne;
        }
    }

    public synchronized void close() throws NamingException {
        if (this.closed) {
            return;
        }
        ArrayList<Object> array = new ArrayList<Object>();
        array.addAll(this.indices.values());
        if (this.ndnIdx != null) {
            array.add(this.ndnIdx);
        }
        if (this.updnIdx != null) {
            array.add(this.updnIdx);
        }
        if (this.aliasIdx != null) {
            array.add(this.aliasIdx);
        }
        if (this.oneAliasIdx != null) {
            array.add(this.oneAliasIdx);
        }
        if (this.subAliasIdx != null) {
            array.add(this.subAliasIdx);
        }
        if (this.hierarchyIdx != null) {
            array.add(this.hierarchyIdx);
        }
        if (this.existanceIdx != null) {
            array.add(this.existanceIdx);
        }
        Iterator list = array.iterator();
        MultiException rootCause = null;
        while (list.hasNext()) {
            Index index = (Index)list.next();
            try {
                index.close();
            }
            catch (Throwable t) {
                if (rootCause == null) {
                    rootCause = new MultiException();
                }
                rootCause.addThrowable(t);
            }
        }
        try {
            this.master.close();
        }
        catch (Throwable t) {
            if (rootCause == null) {
                rootCause = new MultiException();
            }
            rootCause.addThrowable(t);
        }
        try {
            this.recMan.close();
        }
        catch (Throwable t) {
            if (rootCause == null) {
                rootCause = new MultiException();
            }
            rootCause.addThrowable(t);
        }
        this.closed = true;
        if (rootCause != null) {
            NamingException ne = new NamingException("Failed to close all");
            ne.setRootCause((Throwable)rootCause);
            throw ne;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setProperty(String propertyName, String propertyValue) throws NamingException {
        this.master.setProperty(propertyName, propertyValue);
    }

    public String getProperty(String propertyName) throws NamingException {
        return this.master.getProperty(propertyName);
    }

    public Attributes getIndices(BigInteger id) throws NamingException {
        IndexRecord rec;
        LockableAttributesImpl attributes = new LockableAttributesImpl();
        attributes.put("_nDn", this.getEntryDn(id));
        attributes.put("_upDn", this.getEntryUpdn(id));
        attributes.put("_parent", this.getParentId(id));
        Iterator idxList = this.indices.values().iterator();
        while (idxList.hasNext()) {
            Index index = (Index)idxList.next();
            IndexEnumeration list = index.listReverseIndices(id);
            while (list.hasMore()) {
                rec = (IndexRecord)list.next();
                Object val = rec.getIndexKey();
                attributes.put(index.getAttribute().getName(), val);
            }
        }
        IndexEnumeration list = this.existanceIdx.listReverseIndices(id);
        StringBuffer val = new StringBuffer();
        while (list.hasMore()) {
            rec = (IndexRecord)list.next();
            val.append("_existance[");
            val.append(rec.getIndexKey());
            val.append("]");
            attributes.put(val.toString(), rec.getEntryId());
            val.setLength(0);
        }
        list = this.hierarchyIdx.listIndices(id);
        while (list.hasMore()) {
            rec = (IndexRecord)list.next();
            attributes.put("_child", rec.getEntryId());
        }
        return attributes;
    }

    private void add(BigInteger id, Attributes entry, Attribute mods) throws NamingException {
        if (this.hasUserIndexOn(mods.getID())) {
            Index idx = this.getUserIndex(mods.getID());
            idx.add(mods, id);
            if (!this.existanceIdx.hasValue(mods.getID(), id)) {
                idx.add(mods.getID(), id);
            }
        }
        entry.put(mods);
        if (mods.getID().equals("aliasedObjectName")) {
            String ndnStr = (String)this.ndnIdx.reverseLookup(id);
            this.addAliasIndices(id, (Name)new LdapName(ndnStr), (String)mods.get());
        }
    }

    private void remove(BigInteger id, Attributes entry, Attribute mods) throws NamingException {
        if (this.hasUserIndexOn(mods.getID())) {
            Index idx = this.getUserIndex(mods.getID());
            idx.drop(mods, id);
            if (idx.reverseLookup(id) == null) {
                this.existanceIdx.drop(mods.getID(), id);
            }
        }
        if (mods.size() == 0) {
            entry.remove(mods.getID());
        } else {
            Attribute entryAttr = entry.get(mods.getID());
            NamingEnumeration<?> values = mods.getAll();
            while (values.hasMore()) {
                entryAttr.remove(values.next());
            }
        }
        if (mods.getID().equals("aliasedObjectName")) {
            this.dropAliasIndices(id);
        }
    }

    private void replace(BigInteger id, Attributes entry, Attribute mods) throws NamingException {
        if (this.hasUserIndexOn(mods.getID())) {
            Index idx = this.getUserIndex(mods.getID());
            idx.drop(id);
            idx.add(mods, id);
            if (idx.reverseLookup(id) == null) {
                this.existanceIdx.drop(mods.getID(), id);
            }
        }
        if (mods.getID().equals("aliasedObjectName")) {
            this.dropAliasIndices(id);
        }
        entry.put(mods);
        if (mods.getID().equals("aliasedObjectName")) {
            String ndnStr = (String)this.ndnIdx.reverseLookup(id);
            this.addAliasIndices(id, (Name)new LdapName(ndnStr), (String)mods.get());
        }
    }

    public void modify(Name dn, int modOp, Attributes mods) throws NamingException {
        NamingEnumeration<String> attrs = null;
        BigInteger id = this.getEntryId(dn.toString());
        Attributes entry = this.master.get(id);
        switch (modOp) {
            case 1: {
                attrs = mods.getIDs();
                while (attrs.hasMore()) {
                    String attrId = attrs.next();
                    Attribute attr = mods.get(attrId);
                    this.add(id, entry, attr);
                }
                break;
            }
            case 3: {
                attrs = mods.getIDs();
                while (attrs.hasMore()) {
                    String attrId = attrs.next();
                    Attribute attr = mods.get(attrId);
                    this.remove(id, entry, attr);
                }
                break;
            }
            case 2: {
                attrs = mods.getIDs();
                while (attrs.hasMore()) {
                    String attrId = attrs.next();
                    Attribute attr = mods.get(attrId);
                    this.replace(id, entry, attr);
                }
                break;
            }
            default: {
                throw new NamingException("Unidentified modification operation");
            }
        }
        this.master.put(entry, id);
    }

    public void modify(Name dn, ModificationItem[] mods) throws NamingException {
        BigInteger id = this.getEntryId(dn.toString());
        Attributes entry = this.master.get(id);
        int ii = 0;
        while (ii < mods.length) {
            Attribute attrMods = mods[ii].getAttribute();
            switch (mods[ii].getModificationOp()) {
                case 1: {
                    this.add(id, entry, attrMods);
                    break;
                }
                case 3: {
                    this.remove(id, entry, attrMods);
                    break;
                }
                case 2: {
                    this.replace(id, entry, attrMods);
                    break;
                }
                default: {
                    throw new NamingException("Unidentified modification operation");
                }
            }
            ++ii;
        }
        this.master.put(entry, id);
    }

    public void modifyRdn(Name dn, String newRdn, boolean deleteOldRdn) throws NamingException {
        String newRdnAttr = NamespaceTools.getRdnAttribute((String)newRdn);
        String newRdnValue = NamespaceTools.getRdnValue((String)newRdn);
        BigInteger id = this.getEntryId(dn.toString());
        Attributes entry = this.lookup(id);
        LdapName updn = new LdapName(this.getEntryUpdn(id));
        entry.put(newRdnAttr, newRdnValue);
        if (this.hasUserIndexOn(newRdnAttr)) {
            Index idx = this.getUserIndex(newRdnAttr);
            idx.add(newRdnValue, id);
            if (!this.existanceIdx.hasValue(newRdnAttr, id)) {
                this.existanceIdx.add(newRdnAttr, id);
            }
        }
        if (deleteOldRdn) {
            String oldRdn = updn.get(updn.size() - 1);
            String oldRdnAttr = NamespaceTools.getRdnAttribute((String)oldRdn);
            String oldRdnValue = NamespaceTools.getRdnValue((String)oldRdn);
            entry.get(oldRdnAttr).remove(oldRdnValue);
            if (this.hasUserIndexOn(oldRdnAttr)) {
                Index idx = this.getUserIndex(oldRdnAttr);
                idx.drop(oldRdnValue, id);
                if (idx.reverseLookup(id) == null) {
                    this.existanceIdx.drop(oldRdnAttr, id);
                }
            }
        }
        Name newUpdn = (Name)updn.clone();
        newUpdn.remove(newUpdn.size() - 1);
        newUpdn.add(newUpdn.size(), newRdn);
        this.modifyDn(id, newUpdn, false);
    }

    private void modifyDn(BigInteger id, Name updn, boolean isMove) throws NamingException {
        String aliasTarget = null;
        this.ndnIdx.drop(id);
        this.ndnIdx.add(this.ndnIdx.getNormalized(updn.toString()), id);
        this.updnIdx.drop(id);
        this.updnIdx.add(updn.toString(), id);
        if (isMove && (aliasTarget = (String)this.aliasIdx.reverseLookup(id)) != null) {
            this.addAliasIndices(id, (Name)new LdapName(this.getEntryDn(id)), aliasTarget);
        }
        NamingEnumeration children = this.list(id);
        while (children.hasMore()) {
            IndexRecord rec = (IndexRecord)children.next();
            BigInteger childId = rec.getEntryId();
            Name childUpdn = (Name)updn.clone();
            LdapName oldUpdn = new LdapName(this.getEntryUpdn(childId));
            String rdn = LdapName.getRdn((Name)oldUpdn);
            childUpdn.add(childUpdn.size(), rdn);
            this.modifyDn(childId, childUpdn, isMove);
        }
    }

    public void move(Name oldChildDn, Name newParentDn, String newRdn, boolean deleteOldRdn) throws NamingException {
        this.modifyRdn(oldChildDn, newRdn, deleteOldRdn);
        this.move(oldChildDn, newParentDn);
    }

    public void move(Name oldChildDn, Name newParentDn) throws NamingException {
        BigInteger childId = this.getEntryId(oldChildDn.toString());
        BigInteger newParentId = this.getEntryId(newParentDn.toString());
        BigInteger oldParentId = this.getParentId(childId);
        this.dropMovedAliasIndices(oldChildDn);
        this.hierarchyIdx.drop(oldParentId, childId);
        this.hierarchyIdx.add(newParentId, childId);
        LdapName childUpdn = new LdapName(this.getEntryUpdn(childId));
        String childRdn = childUpdn.get(childUpdn.size() - 1);
        LdapName newUpdn = new LdapName(this.getEntryUpdn(newParentId));
        newUpdn.add(newUpdn.size(), childRdn);
        this.modifyDn(childId, (Name)newUpdn, true);
    }

    private void dropMovedAliasIndices(final Name movedBase) throws NamingException {
        IndexAssertion isBaseDescendant = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord rec) throws NamingException {
                String dn = JdbmDatabase.this.getEntryDn(rec.getEntryId());
                return dn.endsWith(movedBase.toString());
            }
        };
        BigInteger movedBaseId = this.getEntryId(movedBase.toString());
        if (this.aliasIdx.reverseLookup(movedBaseId) != null) {
            this.dropAliasIndices(movedBaseId, movedBase);
        }
        IndexAssertionEnumeration aliases = new IndexAssertionEnumeration(this.aliasIdx.listIndices(movedBase.toString(), true), isBaseDescendant);
        while (aliases.hasMore()) {
            IndexRecord entry = (IndexRecord)aliases.next();
            this.dropAliasIndices(entry.getEntryId(), movedBase);
        }
    }

    private void dropAliasIndices(BigInteger aliasId, Name movedBase) throws NamingException {
        String targetDn = (String)this.aliasIdx.reverseLookup(aliasId);
        BigInteger targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        Name ancestorDn = movedBase.getSuffix(1);
        BigInteger ancestorId = this.getEntryId(ancestorDn.toString());
        if (aliasDn.equals(movedBase.toString())) {
            this.oneAliasIdx.drop(ancestorId, targetId);
        }
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals(this.upSuffix)) {
            ancestorDn = ancestorDn.getSuffix(1);
            ancestorId = this.getEntryId(ancestorDn.toString());
            this.subAliasIdx.drop(ancestorId, targetId);
        }
    }
}

