/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.invocation;

import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.server.BackingStore;
import org.apache.ldap.server.invocation.Invocation;

public class Search
extends Invocation {
    private static final long serialVersionUID = 3258410651234678579L;
    private Name baseName;
    private final Map environment;
    private final ExprNode filter;
    private final SearchControls controls;

    public Search(Name baseName, Map environment, ExprNode filters, SearchControls controls) {
        if (baseName == null) {
            throw new NullPointerException("baseName");
        }
        if (environment == null) {
            throw new NullPointerException("environment");
        }
        if (filters == null) {
            throw new NullPointerException("filter");
        }
        if (controls == null) {
            throw new NullPointerException("controls");
        }
        this.baseName = baseName;
        this.environment = environment;
        this.filter = filters;
        this.controls = controls;
    }

    public Name getBaseName() {
        return this.baseName;
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public ExprNode getFilter() {
        return this.filter;
    }

    public SearchControls getControls() {
        return this.controls;
    }

    protected Object doExecute(BackingStore store) throws NamingException {
        return store.search(this.baseName, this.environment, this.filter, this.controls);
    }

    public void setBaseName(Name baseName) {
        this.baseName = baseName;
    }
}

