/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.jndi;

import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.Control;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import org.apache.ldap.common.exception.LdapNoPermissionException;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.PresenceNode;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.util.NamespaceTools;
import org.apache.ldap.server.ContextPartition;
import org.apache.ldap.server.PartitionNexus;
import org.apache.ldap.server.authn.AuthenticationService;
import org.apache.ldap.server.authn.LdapPrincipal;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.jndi.JavaLdapSupport;
import org.apache.ldap.server.jndi.ProviderNexusAspect;
import org.apache.ldap.server.jndi.ServerLdapContext;

public abstract class ServerContext
implements Context {
    public static final String DELETE_OLD_RDN_PROP = "java.naming.ldap.deleteRDN";
    private final PartitionNexus nexusProxy;
    private final Hashtable env;
    private final LdapName dn;
    private LdapPrincipal principal;

    protected ServerContext(PartitionNexus nexusProxy, Hashtable env) throws NamingException {
        boolean bl;
        this.nexusProxy = nexusProxy;
        this.env = (Hashtable)env.clone();
        if (!env.containsKey("java.naming.provider.url")) {
            String msg = "Expected property java.naming.provider.url";
            msg = String.valueOf(msg) + " but could not find it in env!";
            throw new ConfigurationException(msg);
        }
        String url = (String)env.get("java.naming.provider.url");
        if (url == null) {
            String msg = "Expected value for property java.naming.provider.url";
            msg = String.valueOf(msg) + " but it was set to null in env!";
            throw new ConfigurationException(msg);
        }
        LdapName ldapName = this.dn = new LdapName(url);
        PartitionNexus partitionNexus = nexusProxy;
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            bl = partitionNexus.hasEntry((Name)ldapName);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        if (!bl) {
            throw new NameNotFoundException(this.dn + " does not exist");
        }
    }

    protected ServerContext(LdapPrincipal principal, PartitionNexus nexusProxy, Hashtable env, Name dn) {
        this.dn = (LdapName)dn.clone();
        this.env = (Hashtable)env.clone();
        this.env.put("java.naming.provider.url", dn.toString());
        this.nexusProxy = nexusProxy;
        this.principal = principal;
    }

    public LdapPrincipal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(AuthenticationService.TrustedPrincipalWrapper wrapper) {
        this.principal = wrapper.getPrincipal();
    }

    protected PartitionNexus getNexusProxy() {
        return this.nexusProxy;
    }

    protected Name getDn() {
        return this.dn;
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        return this.dn.toString();
    }

    public Hashtable getEnvironment() {
        return this.env;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext((Name)new LdapName(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        LockableAttributesImpl attributes = new LockableAttributesImpl();
        LdapName target = this.buildTarget(name);
        String rdn = name.get(name.size() - 1);
        String rdnAttribute = NamespaceTools.getRdnAttribute((String)rdn);
        String rdnValue = NamespaceTools.getRdnValue((String)rdn);
        attributes.put(rdnAttribute, rdnValue);
        attributes.put("objectClass", "javaContainer");
        attributes.put("objectClass", "top");
        LockableAttributesImpl lockableAttributesImpl = attributes;
        LdapName ldapName = target;
        String string = target.toString();
        PartitionNexus partitionNexus = this.nexusProxy;
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            partitionNexus.add(string, (Name)ldapName, (Attributes)lockableAttributesImpl);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        ServerLdapContext ctx = new ServerLdapContext(this.principal, this.nexusProxy, this.env, (Name)target);
        Control[] controls = (Control[])((ServerLdapContext)this).getRequestControls().clone();
        ctx.setRequestControls(controls);
        return ctx;
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext((Name)new LdapName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        LdapName target = this.buildTarget(name);
        if (target.size() == 0) {
            throw new LdapNoPermissionException("can't delete the rootDSE");
        }
        LdapName ldapName = target;
        PartitionNexus partitionNexus = this.nexusProxy;
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            partitionNexus.delete((Name)ldapName);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind((Name)new LdapName(name), obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, this, this.env, null);
        Attributes outAttrs = res.getAttributes();
        if (outAttrs != null) {
            LdapName target = this.buildTarget(name);
            Attributes attributes = outAttrs;
            LdapName ldapName = target;
            String string = target.toString();
            PartitionNexus partitionNexus = this.nexusProxy;
            try {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
                }
                partitionNexus.add(string, (Name)ldapName, attributes);
            }
            finally {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
                }
            }
            return;
        }
        if (obj instanceof Referenceable) {
            obj = ((Referenceable)obj).getReference();
            throw new NamingException("Do not know how to store Referenceables yet!");
        }
        if (obj instanceof Reference) {
            throw new NamingException("Do not know how to store References yet!");
        }
        if (obj instanceof Serializable) {
            LockableAttributesImpl attributes = new LockableAttributesImpl();
            if (outAttrs != null && outAttrs.size() > 0) {
                NamingEnumeration<? extends Attribute> list = outAttrs.getAll();
                while (list.hasMore()) {
                    attributes.put(list.next());
                }
            }
            LdapName target = this.buildTarget(name);
            JavaLdapSupport.serialize((Attributes)attributes, obj);
            LockableAttributesImpl lockableAttributesImpl = attributes;
            LdapName ldapName = target;
            String string = target.toString();
            PartitionNexus partitionNexus = this.nexusProxy;
            try {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
                }
                partitionNexus.add(string, (Name)ldapName, (Attributes)lockableAttributesImpl);
            }
            finally {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
                }
            }
        } else if (obj instanceof DirContext) {
            Object target;
            Attributes attributes = ((DirContext)obj).getAttributes("");
            if (outAttrs != null && outAttrs.size() > 0) {
                target = outAttrs.getAll();
                while (target.hasMore()) {
                    attributes.put((Attribute)target.next());
                }
            }
            target = this.buildTarget(name);
            Attributes attributes2 = attributes;
            Object object = target;
            String string = target.toString();
            PartitionNexus partitionNexus = this.nexusProxy;
            try {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
                }
                partitionNexus.add(string, (Name)object, attributes2);
            }
            finally {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
                }
            }
        } else {
            throw new NamingException("Can't find a way to bind: " + obj);
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename((Name)new LdapName(oldName), (Name)new LdapName(newName));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        LdapName oldDn = this.buildTarget(oldName);
        LdapName newDn = this.buildTarget(newName);
        if (oldDn.size() == 0) {
            throw new LdapNoPermissionException("can't rename the rootDSE");
        }
        Name oldBase = oldName.getSuffix(1);
        Name newBase = newName.getSuffix(1);
        String newRdn = newName.get(newName.size() - 1);
        String oldRdn = oldName.get(oldName.size() - 1);
        boolean delOldRdn = true;
        if (this.env.get(DELETE_OLD_RDN_PROP) != null) {
            String delOldRdnStr = (String)this.env.get(DELETE_OLD_RDN_PROP);
            delOldRdn = !delOldRdnStr.equals("false");
            delOldRdn = delOldRdn || delOldRdnStr.equals("no");
            boolean bl = delOldRdn = delOldRdn || delOldRdnStr.equals("0");
        }
        if (oldName.size() == newName.size() && oldBase.equals(newBase)) {
            boolean bl = delOldRdn;
            String string = newRdn;
            LdapName ldapName = oldDn;
            PartitionNexus partitionNexus = this.nexusProxy;
            try {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
                }
                partitionNexus.modifyRn((Name)ldapName, string, bl);
            }
            finally {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
                }
            }
        }
        Name parent = newDn.getSuffix(1);
        if (newRdn.equalsIgnoreCase(oldRdn)) {
            Name name = parent;
            LdapName ldapName = oldDn;
            PartitionNexus partitionNexus = this.nexusProxy;
            try {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
                }
                partitionNexus.move((Name)ldapName, name);
            }
            finally {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
                }
            }
        }
        boolean bl = delOldRdn;
        String string = newRdn;
        Name name = parent;
        LdapName ldapName = oldDn;
        PartitionNexus partitionNexus = this.nexusProxy;
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            partitionNexus.move((Name)ldapName, name, string, bl);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind((Name)new LdapName(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        boolean bl;
        LdapName target;
        LdapName ldapName = target = this.buildTarget(name);
        PartitionNexus partitionNexus = this.nexusProxy;
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            bl = partitionNexus.hasEntry((Name)ldapName);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        if (bl) {
            LdapName ldapName2 = target;
            PartitionNexus partitionNexus2 = this.nexusProxy;
            try {
                if (!(this instanceof ContextPartition) && !(partitionNexus2 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
                }
                partitionNexus2.delete((Name)ldapName2);
            }
            finally {
                if (!(this instanceof ContextPartition) && !(partitionNexus2 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
                }
            }
        }
        this.bind(name, obj);
    }

    public void unbind(String name) throws NamingException {
        this.unbind((Name)new LdapName(name));
    }

    public void unbind(Name name) throws NamingException {
        LdapName ldapName = this.buildTarget(name);
        PartitionNexus partitionNexus = this.nexusProxy;
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            partitionNexus.delete((Name)ldapName);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup((Name)new LdapName(name));
    }

    public Object lookup(Name name) throws NamingException {
        Attributes attributes;
        LdapName target;
        Object obj = null;
        LdapName ldapName = target = this.buildTarget(name);
        PartitionNexus partitionNexus = this.nexusProxy;
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            attributes = partitionNexus.lookup((Name)ldapName);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        Attributes attributes2 = attributes;
        try {
            obj = DirectoryManager.getObjectInstance(null, name, this, this.env, attributes2);
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
        if (obj != null) {
            return obj;
        }
        if (attributes2.get("javaClassName") != null) {
            return JavaLdapSupport.deserialize(attributes2);
        }
        ServerLdapContext ctx = new ServerLdapContext(this.principal, this.nexusProxy, this.env, (Name)target);
        Control[] controls = ((ServerLdapContext)this).getRequestControls();
        if (controls != null) {
            ctx.setRequestControls((Control[])controls.clone());
        }
        return ctx;
    }

    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NameParser getNameParser(String name) throws NamingException {
        return LdapName.getNameParser();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return LdapName.getNameParser();
    }

    public NamingEnumeration list(String name) throws NamingException {
        NamingEnumeration namingEnumeration;
        LdapName ldapName = new LdapName(name);
        ServerContext serverContext = this;
        try {
            if (!(this instanceof ContextPartition) && serverContext instanceof PartitionNexus && !(serverContext instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            namingEnumeration = serverContext.list((Name)ldapName);
        }
        finally {
            if (!(this instanceof ContextPartition) && serverContext instanceof PartitionNexus && !(serverContext instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        return namingEnumeration;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        NamingEnumeration namingEnumeration;
        LdapName ldapName = this.buildTarget(name);
        PartitionNexus partitionNexus = this.nexusProxy;
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            namingEnumeration = partitionNexus.list((Name)ldapName);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        return namingEnumeration;
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings((Name)new LdapName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        NamingEnumeration namingEnumeration;
        LdapName base = this.buildTarget(name);
        PresenceNode filter = new PresenceNode("objectClass");
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(1);
        SearchControls searchControls = ctls;
        PresenceNode presenceNode = filter;
        Hashtable hashtable = this.getEnvironment();
        LdapName ldapName = base;
        PartitionNexus partitionNexus = this.nexusProxy;
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            namingEnumeration = partitionNexus.search((Name)ldapName, hashtable, (ExprNode)presenceNode, searchControls);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        return namingEnumeration;
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName((Name)new LdapName(name), (Name)new LdapName(prefix)).toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (prefix == null || prefix.size() == 0) {
            return name;
        }
        LdapName fqn = this.buildTarget(name);
        String head = prefix.get(0);
        while (fqn.size() > 0) {
            if (fqn.get(0).equalsIgnoreCase(head)) {
                return fqn;
            }
            fqn.remove(0);
        }
        String msg = "The prefix '" + prefix + "' is not an ancestor of this ";
        msg = String.valueOf(msg) + "entry '" + this.dn + "'";
        throw new NamingException(msg);
    }

    LdapName buildTarget(Name relativeName) throws InvalidNameException {
        LdapName target = (LdapName)this.dn.clone();
        target.addAll(target.size(), relativeName);
        return target;
    }
}

