/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.ldap.common.schema.Normalizer;
import org.apache.ldap.server.SystemPartition;
import org.apache.ldap.server.schema.NormalizerRegistry;
import org.apache.ldap.server.schema.NormalizerRegistryMonitor;
import org.apache.ldap.server.schema.NormalizerRegistryMonitorAdapter;
import org.apache.ldap.server.schema.bootstrap.BootstrapNormalizerRegistry;

public class GlobalNormalizerRegistry
implements NormalizerRegistry {
    private final Map normalizers;
    private final Map oidToSchema = new HashMap();
    private NormalizerRegistryMonitor monitor;
    private BootstrapNormalizerRegistry bootstrap;
    private SystemPartition systemPartition;

    public GlobalNormalizerRegistry(SystemPartition systemPartition, BootstrapNormalizerRegistry bootstrap) {
        this.normalizers = new HashMap();
        this.monitor = new NormalizerRegistryMonitorAdapter();
        this.bootstrap = bootstrap;
        if (this.bootstrap == null) {
            throw new NullPointerException("the bootstrap registry cannot be null");
        }
        this.systemPartition = systemPartition;
        if (this.systemPartition == null) {
            throw new NullPointerException("the system partition cannot be null");
        }
    }

    public void setMonitor(NormalizerRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, String oid, Normalizer normalizer) throws NamingException {
        if (this.normalizers.containsKey(oid) || this.bootstrap.hasNormalizer(oid)) {
            NamingException e = new NamingException("Normalizer with OID " + oid + " already registered!");
            this.monitor.registerFailed(oid, normalizer, e);
            throw e;
        }
        this.oidToSchema.put(oid, schema);
        this.normalizers.put(oid, normalizer);
        this.monitor.registered(oid, normalizer);
    }

    public Normalizer lookup(String oid) throws NamingException {
        if (this.normalizers.containsKey(oid)) {
            Normalizer c = (Normalizer)this.normalizers.get(oid);
            this.monitor.lookedUp(oid, c);
            return c;
        }
        if (this.bootstrap.hasNormalizer(oid)) {
            Normalizer c = this.bootstrap.lookup(oid);
            this.monitor.lookedUp(oid, c);
            return c;
        }
        NamingException e = new NamingException("Normalizer not found for OID: " + oid);
        this.monitor.lookupFailed(oid, e);
        throw e;
    }

    public boolean hasNormalizer(String oid) {
        return this.normalizers.containsKey(oid) || this.bootstrap.hasNormalizer(oid);
    }

    public String getSchemaName(String oid) throws NamingException {
        if (!Character.isDigit(oid.charAt(0))) {
            throw new NamingException("OID " + oid + " is not a numeric OID");
        }
        if (this.oidToSchema.containsKey(oid)) {
            return (String)this.oidToSchema.get(oid);
        }
        if (this.bootstrap.hasNormalizer(oid)) {
            return this.bootstrap.getSchemaName(oid);
        }
        throw new NamingException("OID " + oid + " not found in oid to " + "schema name map!");
    }
}

