/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema.bootstrap;

import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.ldap.common.schema.UsageEnum;
import org.apache.ldap.server.schema.bootstrap.AbstractBootstrapProducer;
import org.apache.ldap.server.schema.bootstrap.BootstrapRegistries;
import org.apache.ldap.server.schema.bootstrap.ProducerCallback;
import org.apache.ldap.server.schema.bootstrap.ProducerTypeEnum;

public class CoreAttributeTypeProducer
extends AbstractBootstrapProducer {
    public CoreAttributeTypeProducer() {
        super(ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER);
    }

    public void produce(BootstrapRegistries registries, ProducerCallback cb) throws NamingException {
        ArrayList<String> names = new ArrayList<String>();
        AbstractBootstrapProducer.BootstrapAttributeType attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.6", registries);
        attributeType.setDescription("RFC2256: ISO-3166 country 2-letter code");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("c");
        names.add("countryName");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.6", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.43", registries);
        attributeType.setDescription("RFC2256: initials of some or all of names, but not the surname(s).");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("initials");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.43", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.21", registries);
        attributeType.setDescription("RFC2256: Telex Number");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.52");
        names.clear();
        names.add("telexNumber");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.21", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.9", registries);
        attributeType.setDescription("RFC2256: street address of this object");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(128);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreMatch");
        attributeType.setSubstrId("caseIgnoreSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.15");
        names.clear();
        names.add("street");
        names.add("streetAddress");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.9", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("1.2.840.113549.1.9.1", registries);
        attributeType.setDescription("RFC2459: legacy attribute for email addresses in DNs");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(128);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSubstrId("caseIgnoreIA5SubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("email");
        names.add("emailAddress");
        names.add("pkcs9email");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "1.2.840.113549.1.9.1", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.26", registries);
        attributeType.setDescription("RFC2256: registered postal address");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("postalAddress");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.41");
        names.clear();
        names.add("registeredAddress");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.26", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.5", registries);
        attributeType.setDescription("RFC2256: serial number of the entity");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(64);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreMatch");
        attributeType.setSubstrId("caseIgnoreSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.44");
        names.clear();
        names.add("serialNumber");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.5", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.44", registries);
        attributeType.setDescription("RFC2256: name qualifier indicating a generation");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("generationQualifier");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.44", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("0.9.2342.19200300.100.1.3", registries);
        attributeType.setDescription("RFC1274: RFC822 Mailbox");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(256);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSubstrId("caseIgnoreIA5SubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("mail");
        names.add("rfc822Mailbox");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "0.9.2342.19200300.100.1.3", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.18", registries);
        attributeType.setDescription("RFC2256: Post Office Box");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(40);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreMatch");
        attributeType.setSubstrId("caseIgnoreSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.15");
        names.clear();
        names.add("postOfficeBox");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.18", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.4", registries);
        attributeType.setDescription("RFC2256: last (family) name(s) for which the entity is known by");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("sn");
        names.add("surname");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.4", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.40", registries);
        attributeType.setDescription("RFC2256: X.509 cross certificate pair, use ;binary");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.10");
        names.clear();
        names.add("crossCertificatePair");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.40", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.12", registries);
        attributeType.setDescription("RFC2256: title associated with the entity");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("title");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.12", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.13", registries);
        attributeType.setDescription("RFC2256: descriptive information");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(1024);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreMatch");
        attributeType.setSubstrId("caseIgnoreSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.15");
        names.clear();
        names.add("description");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.13", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.8", registries);
        attributeType.setDescription("RFC2256: state or province which this object resides in");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("st");
        names.add("stateOrProvinceName");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.8", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.2", registries);
        attributeType.setDescription("RFC2256: knowledge information");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(32768);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.15");
        names.clear();
        names.add("knowledgeInformation");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.2", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.50", registries);
        attributeType.setDescription("RFC2256: unique member of a group");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("uniqueMemberMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.34");
        names.clear();
        names.add("uniqueMember");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.50", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.29", registries);
        attributeType.setDescription("RFC2256: presentation address");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("presentationAddressMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.43");
        names.clear();
        names.add("presentationAddress");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.29", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.36", registries);
        attributeType.setDescription("RFC2256: X.509 user certificate, use ;binary");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.8");
        names.clear();
        names.add("userCertificate");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.36", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.52", registries);
        attributeType.setDescription("RFC2256: supported algorithms");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.49");
        names.clear();
        names.add("supportedAlgorithms");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.52", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.17", registries);
        attributeType.setDescription("RFC2256: postal code");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(40);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreMatch");
        attributeType.setSubstrId("caseIgnoreSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.15");
        names.clear();
        names.add("postalCode");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.17", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.28", registries);
        attributeType.setDescription("RFC2256: preferred delivery method");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.14");
        names.clear();
        names.add("preferredDeliveryMethod");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.28", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("0.9.2342.19200300.100.1.1", registries);
        attributeType.setDescription("RFC1274: user identifier");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(256);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreMatch");
        attributeType.setSubstrId("caseIgnoreSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.15");
        names.clear();
        names.add("uid");
        names.add("userid");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "0.9.2342.19200300.100.1.1", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.42", registries);
        attributeType.setDescription("RFC2256: first name(s) for which the entity is known by");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("givenName");
        names.add("gn");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.42", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.30", registries);
        attributeType.setDescription("RFC2256: supported application context");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("objectIdentifierMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.38");
        names.clear();
        names.add("supportedApplicationContext");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.30", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.31", registries);
        attributeType.setDescription("RFC2256: member of a group");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("distinguishedName");
        names.clear();
        names.add("member");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.31", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.54", registries);
        attributeType.setDescription("RFC2256: name of DMD");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("dmdName");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.54", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.10", registries);
        attributeType.setDescription("RFC2256: organization this object belongs to");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("o");
        names.add("organizationName");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.10", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.32", registries);
        attributeType.setDescription("RFC2256: owner (of the object)");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("distinguishedName");
        names.clear();
        names.add("owner");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.32", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.48", registries);
        attributeType.setDescription("RFC2256: protocol information");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("protocolInformationMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.42");
        names.clear();
        names.add("protocolInformation");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.48", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.19", registries);
        attributeType.setDescription("RFC2256: Physical Delivery Office Name");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(128);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreMatch");
        attributeType.setSubstrId("caseIgnoreSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.15");
        names.clear();
        names.add("physicalDeliveryOfficeName");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.19", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("0.9.2342.19200300.100.1.37", registries);
        attributeType.setDescription("RFC1274: domain associated with object");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSubstrId("caseIgnoreIA5SubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("associatedDomain");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "0.9.2342.19200300.100.1.37", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.51", registries);
        attributeType.setDescription("RFC2256: house identifier");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(32768);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreMatch");
        attributeType.setSubstrId("caseIgnoreSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.15");
        names.clear();
        names.add("houseIdentifier");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.51", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.22", registries);
        attributeType.setDescription("RFC2256: Teletex Terminal Identifier");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.51");
        names.clear();
        names.add("teletexTerminalIdentifier");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.22", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.25", registries);
        attributeType.setDescription("RFC2256: international ISDN number");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(16);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("numericStringMatch");
        attributeType.setSubstrId("numericStringSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.36");
        names.clear();
        names.add("internationaliSDNNumber");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.25", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.34", registries);
        attributeType.setDescription("RFC2256: DN of related object");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("distinguishedName");
        names.clear();
        names.add("seeAlso");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.34", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.47", registries);
        attributeType.setDescription("RFC2256: enhanced search guide");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.21");
        names.clear();
        names.add("enhancedSearchGuide");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.47", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.24", registries);
        attributeType.setDescription("RFC2256: X.121 Address");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(15);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("numericStringMatch");
        attributeType.setSubstrId("numericStringSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.36");
        names.clear();
        names.add("x121Address");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.24", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.7", registries);
        attributeType.setDescription("RFC2256: locality which this object resides in");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("l");
        names.add("localityName");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.7", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.46", registries);
        attributeType.setDescription("RFC2256: DN qualifier");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreMatch");
        attributeType.setSubstrId("caseIgnoreSubstringsMatch");
        attributeType.setOrderingId("caseIgnoreOrderingMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.44");
        names.clear();
        names.add("dnQualifier");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.46", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.27", registries);
        attributeType.setDescription("RFC2256: destination indicator");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(128);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreMatch");
        attributeType.setSubstrId("caseIgnoreSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.44");
        names.clear();
        names.add("destinationIndicator");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.27", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.16", registries);
        attributeType.setDescription("RFC2256: postal address");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreListMatch");
        attributeType.setSubstrId("caseIgnoreListSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.41");
        names.clear();
        names.add("postalAddress");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.16", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.38", registries);
        attributeType.setDescription("RFC2256: X.509 authority revocation list, use ;binary");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.9");
        names.clear();
        names.add("authorityRevocationList");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.38", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("0.9.2342.19200300.100.1.25", registries);
        attributeType.setDescription("RFC1274/2247: domain component");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSubstrId("caseIgnoreIA5SubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dc");
        names.add("domainComponent");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "0.9.2342.19200300.100.1.25", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.37", registries);
        attributeType.setDescription("RFC2256: X.509 CA certificate, use ;binary");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.8");
        names.clear();
        names.add("cACertificate");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.37", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.15", registries);
        attributeType.setDescription("RFC2256: business category");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(128);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreMatch");
        attributeType.setSubstrId("caseIgnoreSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.15");
        names.clear();
        names.add("businessCategory");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.15", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.33", registries);
        attributeType.setDescription("RFC2256: occupant of role");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("distinguishedName");
        names.clear();
        names.add("roleOccupant");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.33", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.11", registries);
        attributeType.setDescription("RFC2256: organizational unit this object belongs to");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("ou");
        names.add("organizationalUnitName");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.11", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.14", registries);
        attributeType.setDescription("RFC2256: search guide, obsoleted by enhancedSearchGuide");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.25");
        names.clear();
        names.add("searchGuide");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.14", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.23", registries);
        attributeType.setDescription("RFC2256: Facsimile (Fax) Telephone Number");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.22");
        names.clear();
        names.add("facsimileTelephoneNumber");
        names.add("fax");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.23", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.45", registries);
        attributeType.setDescription("RFC2256: X.500 unique identifier");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("bitStringMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.6");
        names.clear();
        names.add("x500UniqueIdentifier");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.45", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.39", registries);
        attributeType.setDescription("RFC2256: X.509 certificate revocation list, use ;binary");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.9");
        names.clear();
        names.add("certificateRevocationList");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.39", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.53", registries);
        attributeType.setDescription("RFC2256: delta revocation list; use ;binary");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.9");
        names.clear();
        names.add("deltaRevocationList");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.53", (Object)attributeType);
        attributeType = AbstractBootstrapProducer.newAttributeType("2.5.4.20", registries);
        attributeType.setDescription("RFC2256: Telephone Number");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(32);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("telephoneNumberMatch");
        attributeType.setSubstrId("telephoneNumberSubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.50");
        names.clear();
        names.add("telephoneNumber");
        attributeType.setNames(names.toArray(AbstractBootstrapProducer.EMPTY));
        cb.schemaObjectProduced(this, "2.5.4.20", (Object)attributeType);
    }
}

