/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.auth.client;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class JwtAuthentication
implements Authentication,
UserDetails {
    private final List<GrantedAuthority> authorities;
    private final Map<String, String> details;

    public String getCredentials() {
        return this.getSubject();
    }

    public Principal getPrincipal() {
        return this;
    }

    public boolean isAuthenticated() {
        return !this.getSubject().isBlank();
    }

    public void setAuthenticated(boolean isAuthenticated) {
        throw new IllegalArgumentException("Authentication is immutable.");
    }

    public String getName() {
        return this.details.getOrDefault("name", "None");
    }

    public String getPassword() {
        return null;
    }

    public String getUsername() {
        return this.getSubject();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    private String getSubject() {
        return Optional.ofNullable(this.details).map(x -> (String)x.get("sub")).orElse("");
    }

    public String getMetaId() {
        return this.details.getOrDefault("mId", "");
    }

    public boolean hasMetaId() {
        return this.details.get("mId") != null;
    }

    JwtAuthentication(List<GrantedAuthority> authorities, Map<String, String> details) {
        this.authorities = authorities;
        this.details = details;
    }

    public static JwtAuthenticationBuilder builder() {
        return new JwtAuthenticationBuilder();
    }

    public List<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtAuthentication)) {
            return false;
        }
        JwtAuthentication other = (JwtAuthentication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection this$authorities = this.getAuthorities();
        Collection other$authorities = other.getAuthorities();
        if (this$authorities == null ? other$authorities != null : !((Object)this$authorities).equals(other$authorities)) {
            return false;
        }
        Object this$details = this.getDetails();
        Object other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !this$details.equals(other$details));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtAuthentication;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection $authorities = this.getAuthorities();
        result = result * 59 + ($authorities == null ? 43 : ((Object)$authorities).hashCode());
        Object $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        return result;
    }

    public String toString() {
        return "JwtAuthentication(authorities=" + (List)this.getAuthorities() + ", details=" + (Map)this.getDetails() + ")";
    }

    public static class JwtAuthenticationBuilder {
        private ArrayList<GrantedAuthority> authorities;
        private Map<String, String> details;

        JwtAuthenticationBuilder() {
        }

        public JwtAuthenticationBuilder authority(GrantedAuthority authority) {
            if (this.authorities == null) {
                this.authorities = new ArrayList();
            }
            this.authorities.add(authority);
            return this;
        }

        public JwtAuthenticationBuilder authorities(Collection<? extends GrantedAuthority> authorities) {
            if (this.authorities == null) {
                this.authorities = new ArrayList();
            }
            this.authorities.addAll(authorities);
            return this;
        }

        public JwtAuthenticationBuilder clearAuthorities() {
            if (this.authorities != null) {
                this.authorities.clear();
            }
            return this;
        }

        public JwtAuthenticationBuilder details(Map<String, String> details) {
            this.details = details;
            return this;
        }

        public JwtAuthentication build() {
            List<GrantedAuthority> authorities;
            switch (this.authorities == null ? 0 : this.authorities.size()) {
                case 0: {
                    authorities = Collections.emptyList();
                    break;
                }
                case 1: {
                    authorities = Collections.singletonList(this.authorities.get(0));
                    break;
                }
                default: {
                    authorities = Collections.unmodifiableList(new ArrayList<GrantedAuthority>(this.authorities));
                }
            }
            return new JwtAuthentication(authorities, this.details);
        }

        public String toString() {
            return "JwtAuthentication.JwtAuthenticationBuilder(authorities=" + this.authorities + ", details=" + this.details + ")";
        }
    }
}

