/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.auth.client;

import dk.acto.auth.client.JwtValidator;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component
public class JwtFilter
extends GenericFilterBean {
    private final JwtValidator validator;

    public JwtFilter(JwtValidator validator) {
        this.validator = validator;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest cast = (HttpServletRequest)request;
        Optional.ofNullable(cast.getHeader("Authorization")).map(this.validator::decodeToken).ifPresent(x -> SecurityContextHolder.getContext().setAuthentication((Authentication)x));
        chain.doFilter(request, response);
    }
}

