/*
 * Decompiled with CFR 0.152.
 */
package dk.acto.auth.client;

import dk.acto.auth.client.JwtAuthentication;
import dk.acto.auth.client.providers.AuthoritiesProvider;
import dk.acto.auth.client.providers.PublicKeyProvider;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class JwtValidator {
    private static final Pattern auth = Pattern.compile("^([Bb]earer\\s+)?(.+)$");
    private final PublicKeyProvider pkp;
    private final AuthoritiesProvider ap;

    public JwtValidator(PublicKeyProvider pkp, AuthoritiesProvider ap) {
        this.pkp = pkp;
        this.ap = ap;
    }

    public JwtAuthentication decodeToken(String authHeader) {
        JwtParser decoder = (JwtParser)Try.of(this.pkp::getPublicKey).map(x -> Base64.getDecoder().decode((String)x)).mapTry((CheckedFunction1 & Serializable)x -> KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec((byte[])x))).map(x -> Jwts.parser().setSigningKey((Key)x)).get();
        Claims claims = (Claims)Try.of((CheckedFunction0 & Serializable)() -> auth.matcher(authHeader)).filter(Matcher::matches).map(x -> x.group(2)).mapTry(arg_0 -> ((JwtParser)decoder).parseClaimsJws(arg_0)).map(Jwt::getBody).getOrNull();
        return Optional.ofNullable(claims).map(c -> JwtAuthentication.builder().details(this.mapClaims(claims)).authorities(this.ap.mapAuthorities((Map<String, Object>)claims)).build()).orElse(null);
    }

    private Map<String, String> mapClaims(Claims claims) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        claims.forEach((k, v) -> result.put((String)k, String.valueOf(v)));
        return result;
    }
}

