/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs;

import java.io.Serializable;
import java.util.ArrayList;

public class Path
implements Serializable {
    ArrayList<String> levels = new ArrayList();

    public Path() {
    }

    public Path(Path parent, String child) {
        this.levels.addAll(parent.levels);
        this.levels.add(child);
    }

    public Path(String path) {
        String[] elements;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path.substring(0, path.length() - 1);
        }
        for (String element : elements = path.split("/")) {
            this.levels.add(element);
        }
    }

    public void addLevel(String level) {
        this.levels.add(level);
    }

    public void addLevel(int index, String level) {
        this.levels.add(index, level);
    }

    public void removeLevel(int levelindex) {
        this.levels.remove(levelindex);
    }

    public Path clone() {
        Path clone = new Path();
        clone.levels.addAll(this.levels);
        return clone;
    }

    public String getLeaf() {
        return this.levels.get(this.levels.size() - 1);
    }

    public int getLevels() {
        return this.levels.size();
    }

    public String getLevel(int levelindex) {
        return this.levels.get(levelindex);
    }

    public String toString() {
        if (this.levels.isEmpty()) {
            return "/";
        }
        StringBuilder buf = new StringBuilder();
        for (String level : this.levels) {
            buf.append("/");
            buf.append(level);
        }
        return buf.toString();
    }

    public boolean equals(Object compareTo) {
        Path otherPath = (Path)compareTo;
        if (otherPath.levels.size() != this.levels.size()) {
            return false;
        }
        for (int i = 0; i < this.levels.size(); ++i) {
            if (this.levels.get(i).equals(otherPath.levels.get(i))) continue;
            return false;
        }
        return true;
    }
}

