/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.cifs;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.File;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.NodeFilter;
import dk.apaq.vfs.impl.cifs.CifsFile;
import dk.apaq.vfs.impl.cifs.CifsFileSystem;
import dk.apaq.vfs.impl.cifs.CifsNode;
import dk.apaq.vfs.impl.cifs.SmbFilterWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CifsDirectory
extends CifsNode
implements Directory {
    public CifsDirectory(CifsFileSystem filesystem, SmbFile file) {
        super(filesystem, file);
    }

    public CifsDirectory(CifsFileSystem filesystem, String url) throws MalformedURLException {
        super(filesystem, url);
    }

    @Override
    public Directory createDirectory(String name) throws IOException {
        SmbFile newDir = new SmbFile(this.innerFile, name + "/");
        newDir.mkdir();
        return new CifsDirectory(this.filesystem, newDir);
    }

    @Override
    public File createFile(String name) throws IOException {
        SmbFile newFile = new SmbFile(this.innerFile, name);
        newFile.createNewFile();
        return new CifsFile(this.filesystem, newFile);
    }

    @Override
    public boolean hasChild(String name) {
        try {
            SmbFile newFile = new SmbFile(this.innerFile, name);
            return newFile.exists();
        }
        catch (SmbException ex) {
            Logger.getLogger(CifsDirectory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(CifsDirectory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(CifsDirectory.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    @Override
    public boolean hasFile(String name) {
        try {
            SmbFile newFile = new SmbFile(this.innerFile, name);
            return newFile.exists() && newFile.isFile();
        }
        catch (SmbException ex) {
            Logger.getLogger(CifsDirectory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(CifsDirectory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(CifsDirectory.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    @Override
    public boolean hasDirectory(String name) {
        try {
            SmbFile newFile = new SmbFile(this.innerFile, name);
            return newFile.exists() && newFile.isDirectory();
        }
        catch (SmbException ex) {
            Logger.getLogger(CifsDirectory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(CifsDirectory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(CifsDirectory.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    @Override
    public Node getChild(String name) throws FileNotFoundException {
        try {
            SmbFile[] files;
            for (SmbFile file : files = this.innerFile.listFiles()) {
                if (!file.getName().equals(name)) continue;
                SmbFile newFile = new SmbFile(this.innerFile, name);
                if (newFile.isFile()) {
                    return new CifsFile(this.filesystem, newFile);
                }
                return new CifsDirectory(this.filesystem, newFile);
            }
            throw new FileNotFoundException("File not found in the directory.");
        }
        catch (SmbException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
        catch (MalformedURLException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
        catch (UnknownHostException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public File getFile(String name) throws FileNotFoundException {
        Node node = this.getChild(name);
        if (node.isDirectory()) {
            throw new FileNotFoundException("The node is not a file, but a directory.");
        }
        return (File)node;
    }

    @Override
    public Directory getDirectory(String name) throws FileNotFoundException {
        try {
            SmbFile newfile = new SmbFile(this.innerFile, name + "/");
            if (!newfile.exists()) {
                throw new FileNotFoundException("File not found.");
            }
            return new CifsDirectory(this.filesystem, newfile);
        }
        catch (SmbException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
        catch (UnknownHostException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
        catch (MalformedURLException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public File getFile(String name, boolean createIfNeeded) throws FileNotFoundException, IOException {
        File file;
        try {
            file = this.getFile(name);
        }
        catch (FileNotFoundException ex) {
            if (createIfNeeded) {
                file = this.createFile(name);
            }
            throw ex;
        }
        return file;
    }

    @Override
    public Directory getDirectory(String name, boolean createIfNeeded) throws FileNotFoundException, IOException {
        try {
            return this.getDirectory(name);
        }
        catch (FileNotFoundException ex) {
            if (!createIfNeeded) {
                throw ex;
            }
            Directory dir = this.createDirectory(name);
            return dir;
        }
    }

    @Override
    public List<Node> getChildren() {
        return this.getChildren(null);
    }

    @Override
    public List<Directory> getDirectories() {
        return this.getDirectories(null);
    }

    @Override
    public List<File> getFiles() {
        return this.getFiles(null);
    }

    @Override
    public List<Node> getChildren(NodeFilter filter) {
        try {
            SmbFile[] files = filter == null ? this.innerFile.listFiles() : this.innerFile.listFiles((SmbFileFilter)new SmbFilterWrapper(this.filesystem, filter));
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (SmbFile file : files) {
                CifsNode node = file.isDirectory() ? new CifsDirectory(this.filesystem, file) : new CifsFile(this.filesystem, file);
                nodes.add(node);
            }
            return nodes;
        }
        catch (SmbException ex) {
            Logger.getLogger(CifsDirectory.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<Node>();
        }
    }

    @Override
    public List<Directory> getDirectories(NodeFilter filter) {
        try {
            SmbFile[] files = filter == null ? this.innerFile.listFiles() : this.innerFile.listFiles((SmbFileFilter)new SmbFilterWrapper(this.filesystem, filter));
            ArrayList<Directory> nodes = new ArrayList<Directory>();
            for (SmbFile file : files) {
                if (!file.isDirectory()) continue;
                CifsDirectory node = new CifsDirectory(this.filesystem, file);
                nodes.add(node);
            }
            return nodes;
        }
        catch (SmbException ex) {
            Logger.getLogger(CifsDirectory.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<Directory>();
        }
    }

    @Override
    public List<File> getFiles(NodeFilter filter) {
        try {
            SmbFile[] files = filter == null ? this.innerFile.listFiles() : this.innerFile.listFiles((SmbFileFilter)new SmbFilterWrapper(this.filesystem, filter));
            ArrayList<File> nodes = new ArrayList<File>();
            for (SmbFile file : files) {
                if (file.isDirectory()) continue;
                CifsFile node = new CifsFile(this.filesystem, file);
                nodes.add(node);
            }
            return nodes;
        }
        catch (SmbException ex) {
            Logger.getLogger(CifsDirectory.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<File>();
        }
    }

    @Override
    public void delete(boolean recursive) throws IOException {
        if (this.isRoot()) {
            throw new IOException("Cannot delete root.");
        }
        if (!recursive) {
            this.innerFile.delete();
        } else {
            this.deleteRecursive(this.innerFile);
        }
    }

    @Override
    public boolean isBundle() {
        return this.innerFile.getName().contains(".");
    }
}

