/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.cifs;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.impl.cifs.CifsDirectory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;

public class CifsFileSystem
implements FileSystem {
    CifsDirectory root;
    HashMap infomap = new HashMap();

    public CifsFileSystem(String server, String share) throws MalformedURLException, SmbException {
        this("smb://" + server + "/" + share + "/");
    }

    public CifsFileSystem(String url) throws MalformedURLException, SmbException {
        SmbFile smbfile = new SmbFile(url);
        if (!(smbfile.getType() == 8 || smbfile.getType() == 1 && smbfile.isDirectory())) {
            throw new MalformedURLException("The URL syntax was OK, but it must point to a share or a directory.");
        }
        this.root = new CifsDirectory(this, smbfile);
    }

    public String getName() {
        return "CIFS";
    }

    public Directory getRoot() throws FileNotFoundException {
        return this.root;
    }

    public Map getInfo() {
        return this.infomap;
    }

    public static String[] getWorkgroups() throws IOException {
        try {
            SmbFile file = new SmbFile("smb://");
            return file.list();
        }
        catch (MalformedURLException ex) {
            throw new IOException("Unable to liste workgroups. " + ex.getMessage());
        }
    }

    public static String[] getServers(String workgroup) throws IOException {
        try {
            SmbFile file = new SmbFile("smb://" + workgroup);
            return file.list();
        }
        catch (MalformedURLException ex) {
            throw new IOException("Unable to liste servers. " + ex.getMessage());
        }
    }

    public static String[] getShares(String server) throws IOException {
        try {
            SmbFile file = new SmbFile("smb://" + server);
            return file.list();
        }
        catch (MalformedURLException ex) {
            throw new IOException("Unable to liste shares. " + ex.getMessage());
        }
    }

    public long getSize() {
        return -1L;
    }

    public long getFreeSpace() {
        try {
            return this.root.innerFile.getDiskFreeSpace();
        }
        catch (SmbException ex) {
            return -1L;
        }
    }

    public Node getNode(String path) throws FileNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() throws IOException {
    }
}

