/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.cifs;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.Path;
import dk.apaq.vfs.impl.cifs.CifsDirectory;
import dk.apaq.vfs.impl.cifs.CifsFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;

public abstract class CifsNode
implements Node {
    SmbFile innerFile;
    CifsFileSystem filesystem;

    public CifsNode(CifsFileSystem filesystem, SmbFile file) {
        this.filesystem = filesystem;
        this.innerFile = file;
    }

    public CifsNode(CifsFileSystem filesystem, String url) throws MalformedURLException {
        this.filesystem = filesystem;
        this.innerFile = new SmbFile(url);
    }

    protected void deleteRecursive(SmbFile file) throws IOException {
        if (!file.exists()) {
            throw new IOException("The file does not exist.");
        }
        if (!file.isDirectory()) {
            throw new IOException("A file cannot be deleted recursively.");
        }
        if (file.exists()) {
            SmbFile[] files;
            for (SmbFile currentFile : files = file.listFiles()) {
                if (currentFile.isDirectory()) {
                    this.deleteRecursive(currentFile);
                    continue;
                }
                currentFile.delete();
            }
            file.delete();
        }
    }

    public void moveTo(Directory newParent) throws IOException {
        this.moveTo(newParent, this.innerFile.getName());
    }

    public void moveTo(Directory newParent, String newName) throws IOException {
        SmbFile newFile = new SmbFile(((CifsDirectory)newParent).innerFile, newName);
        this.innerFile.renameTo(newFile);
    }

    public void setName(String name) throws IOException {
        this.moveTo(this.getParent(), name);
    }

    public String getName() {
        String name = this.innerFile.getName();
        name = name.replaceAll("/", "");
        return name;
    }

    public boolean isRoot() {
        try {
            if (this.innerFile.getPath().equals(((CifsDirectory)this.filesystem.getRoot()).innerFile.getPath())) {
                return true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public Directory getParent() throws FileNotFoundException {
        try {
            if (this.isRoot()) {
                return null;
            }
            return new CifsDirectory(this.filesystem, this.innerFile.getParent());
        }
        catch (MalformedURLException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    public FileSystem getFileSystem() {
        return this.filesystem;
    }

    public boolean isDirectory() {
        try {
            return this.innerFile.isDirectory();
        }
        catch (SmbException ex) {
            Logger.getLogger(CifsNode.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public boolean isFile() {
        try {
            return this.innerFile.isFile();
        }
        catch (SmbException ex) {
            Logger.getLogger(CifsNode.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public boolean isHidden() {
        try {
            return this.innerFile.isHidden();
        }
        catch (SmbException ex) {
            Logger.getLogger(CifsNode.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public Date getLastModified() {
        return new Date(this.innerFile.getLastModified());
    }

    public void setLastModified(Date date) {
        try {
            this.innerFile.setLastModified(date.getTime());
        }
        catch (SmbException ex) {
            Logger.getLogger(CifsNode.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int compareTo(Node node) {
        return this.innerFile.getPath().compareTo(((CifsNode)node).innerFile.getPath());
    }

    public void delete() throws IOException {
        if (this.isRoot()) {
            throw new IOException("Cannot delete root.");
        }
        if (this.innerFile.isDirectory() && this.innerFile.list().length > 0) {
            throw new IOException("Cannot delete directory because it is not empty.");
        }
        this.innerFile.delete();
    }

    public URI toUri() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Node node) {
        return this.innerFile.getPath().equals(((CifsNode)node).innerFile.getPath());
    }

    public boolean equals(Object o) {
        if (o instanceof Node) {
            return this.equals((Node)o);
        }
        return super.equals(o);
    }

    public int compareTo(Object arg0) {
        return this.compareTo((Node)arg0);
    }

    public Path getPath() {
        return new Path();
    }

    public boolean canRead() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean canWrite() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getBaseName() {
        String name = this.innerFile.getName();
        if (name.contains(".")) {
            return name.substring(0, name.lastIndexOf(".") - 1);
        }
        return name;
    }

    public String getSuffix() {
        String name = this.innerFile.getName();
        if (name.contains(".")) {
            return name.substring(name.lastIndexOf(".") + 1);
        }
        return null;
    }
}

