/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.layered;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.File;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.NodeFilter;
import dk.apaq.vfs.impl.layered.LayeredFile;
import dk.apaq.vfs.impl.layered.LayeredFileSystem;
import dk.apaq.vfs.impl.layered.LayeredNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayeredDirectory
extends LayeredNode
implements Directory {
    private final List<Directory> layers;

    public LayeredDirectory(LayeredFileSystem fileSystem, LayeredDirectory parent, Directory wrappedNode) {
        super(fileSystem, parent, wrappedNode);
        this.layers = fileSystem.getLayers(this.getPath());
    }

    @Override
    public Directory createDirectory(String name) throws IOException {
        return new LayeredDirectory(this.fileSystem, this, ((Directory)this.wrappedNode).createDirectory(name));
    }

    @Override
    public File createFile(String name) throws IOException {
        return new LayeredFile(this.fileSystem, this, ((Directory)this.wrappedNode).createFile(name));
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean hasChild(String name) {
        if (((Directory)this.wrappedNode).hasChild(name)) {
            return true;
        }
        for (Directory dir : this.layers) {
            if (!dir.hasChild(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFile(String name) {
        if (((Directory)this.wrappedNode).hasFile(name)) {
            return true;
        }
        for (Directory dir : this.layers) {
            if (!dir.hasFile(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasDirectory(String name) {
        if (((Directory)this.wrappedNode).hasDirectory(name)) {
            return true;
        }
        for (Directory dir : this.layers) {
            if (!dir.hasDirectory(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Node getChild(String name) throws FileNotFoundException {
        if (((Directory)this.wrappedNode).hasChild(name)) {
            Node node = ((Directory)this.wrappedNode).getChild(name);
            if (node.isDirectory()) {
                return new LayeredDirectory(this.fileSystem, this, (Directory)node);
            }
            return new LayeredFile(this.fileSystem, this, (File)node);
        }
        for (Directory dir : this.layers) {
            if (!dir.hasChild(name)) continue;
            Node node = dir.getChild(name);
            if (node.isDirectory()) {
                return new LayeredDirectory(this.fileSystem, this, (Directory)node);
            }
            return new LayeredFile(this.fileSystem, this, (File)node);
        }
        throw new FileNotFoundException("Node not found. [parent=" + this.getPath() + "; name=" + name + "]");
    }

    @Override
    public File getFile(String name) throws FileNotFoundException {
        if (((Directory)this.wrappedNode).hasFile(name)) {
            return new LayeredFile(this.fileSystem, this, ((Directory)this.wrappedNode).getFile(name));
        }
        for (Directory dir : this.layers) {
            if (!dir.hasFile(name)) continue;
            return new LayeredFile(this.fileSystem, this, dir.getFile(name));
        }
        throw new FileNotFoundException("File not found. [parent=" + this.getPath() + "; name=" + name + "]");
    }

    @Override
    public Directory getDirectory(String name) throws FileNotFoundException {
        if (((Directory)this.wrappedNode).hasDirectory(name)) {
            return new LayeredDirectory(this.fileSystem, this, ((Directory)this.wrappedNode).getDirectory(name));
        }
        for (Directory dir : this.layers) {
            if (!dir.hasDirectory(name)) continue;
            return new LayeredDirectory(this.fileSystem, this, dir.getDirectory(name));
        }
        throw new FileNotFoundException("Directory not found. [parent=" + this.getPath() + "; name=" + name + "]");
    }

    @Override
    public File getFile(String name, boolean createIfNeeded) throws FileNotFoundException, IOException {
        try {
            return this.getFile(name);
        }
        catch (FileNotFoundException ex) {
            if (createIfNeeded) {
                return this.createFile(name);
            }
            throw ex;
        }
    }

    @Override
    public Directory getDirectory(String name, boolean createIfNeeded) throws FileNotFoundException, IOException {
        try {
            return this.getDirectory(name);
        }
        catch (FileNotFoundException ex) {
            if (createIfNeeded) {
                return this.createDirectory(name);
            }
            throw ex;
        }
    }

    @Override
    public List<Node> getChildren() {
        return this.getChildren(null);
    }

    @Override
    public List<Directory> getDirectories() {
        return this.getDirectories(null);
    }

    @Override
    public List<File> getFiles() {
        return this.getFiles(null);
    }

    @Override
    public List<Node> getChildren(NodeFilter filter) {
        List<Node> children = ((Directory)this.wrappedNode).getChildren(filter);
        for (Directory dir : this.layers) {
            for (Node node : dir.getChildren(filter)) {
                for (Node existingNode : children) {
                    if (existingNode.getName().equals(node.getName())) break;
                }
                children.add(node);
            }
        }
        ArrayList<Node> layeredList = new ArrayList<Node>();
        for (Node current : children) {
            if (current.isDirectory()) {
                layeredList.add(new LayeredDirectory(this.fileSystem, this, (Directory)current));
                continue;
            }
            layeredList.add(new LayeredFile(this.fileSystem, this, (File)current));
        }
        return layeredList;
    }

    @Override
    public List<Directory> getDirectories(NodeFilter filter) {
        List<Directory> children = ((Directory)this.wrappedNode).getDirectories(filter);
        for (Directory dir : this.layers) {
            for (Directory node : dir.getDirectories(filter)) {
                for (Directory existingNode : children) {
                    if (existingNode.getName().equals(node.getName())) break;
                }
                children.add(node);
            }
        }
        ArrayList<Directory> layeredList = new ArrayList<Directory>();
        for (Directory current : children) {
            layeredList.add(new LayeredDirectory(this.fileSystem, this, current));
        }
        return layeredList;
    }

    @Override
    public List<File> getFiles(NodeFilter filter) {
        List<File> children = ((Directory)this.wrappedNode).getFiles(filter);
        for (Directory dir : this.layers) {
            for (File node : dir.getFiles(filter)) {
                for (File existingNode : children) {
                    if (existingNode.getName().equals(node.getName())) break;
                }
                children.add(node);
            }
        }
        ArrayList<File> layeredList = new ArrayList<File>();
        for (File current : children) {
            layeredList.add(new LayeredFile(this.fileSystem, this, current));
        }
        return layeredList;
    }

    @Override
    public void delete(boolean recursive) throws IOException {
        ((Directory)this.wrappedNode).delete(recursive);
    }

    @Override
    public boolean isBundle() {
        return ((Directory)this.wrappedNode).isBundle();
    }
}

