/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.layered;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.Path;
import dk.apaq.vfs.impl.layered.LayeredDirectory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayeredFileSystem
implements FileSystem {
    private final FileSystem layerForFilesystem;
    private final List<LayerEntry> entries = new ArrayList<LayerEntry>();

    public LayeredFileSystem(FileSystem layerForFilesystem) {
        this.layerForFilesystem = layerForFilesystem;
    }

    public void addLayer(Path injectPath, Directory directory) {
        this.entries.add(new LayerEntry(injectPath, directory));
    }

    protected List<Directory> getLayers(Path path) {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (LayerEntry entry : this.entries) {
            if (!path.toString().equals(entry.path.toString())) continue;
            dirs.add(entry.directory);
        }
        return dirs;
    }

    @Override
    public String getName() {
        return "Layered filesystem between for " + this.layerForFilesystem.getName();
    }

    @Override
    public Map getInfo() {
        return this.layerForFilesystem.getInfo();
    }

    @Override
    public Directory getRoot() throws FileNotFoundException {
        return new LayeredDirectory(this, null, this.layerForFilesystem.getRoot());
    }

    @Override
    public long getSize() {
        return this.layerForFilesystem.getSize();
    }

    @Override
    public long getFreeSpace() {
        return this.layerForFilesystem.getFreeSpace();
    }

    @Override
    public Node getNode(String path) throws FileNotFoundException {
        Path pathObject = new Path(path);
        Node currentNode = this.getRoot();
        for (int i = 0; i < pathObject.getLevels(); ++i) {
            if (!currentNode.isDirectory()) {
                throw new FileNotFoundException("The path '" + path + "' does not exist.");
            }
            currentNode = currentNode.getChild(pathObject.getLevel(i));
        }
        return currentNode;
    }

    @Override
    public void close() throws IOException {
        this.layerForFilesystem.close();
    }

    private class LayerEntry {
        private final Path path;
        private final Directory directory;

        public LayerEntry(Path path, Directory directory) {
            this.path = path;
            this.directory = directory;
        }

        public Directory getDirectory() {
            return this.directory;
        }

        public Path getPath() {
            return this.path;
        }
    }
}

