/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.layered;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.Path;
import dk.apaq.vfs.impl.layered.LayeredDirectory;
import dk.apaq.vfs.impl.layered.LayeredFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Date;

public abstract class LayeredNode
implements Node {
    protected final LayeredFileSystem fileSystem;
    protected final LayeredDirectory parent;
    protected final Node wrappedNode;

    public LayeredNode(LayeredFileSystem fileSystem, LayeredDirectory parent, Node wrappedNode) {
        this.fileSystem = fileSystem;
        this.wrappedNode = wrappedNode;
        this.parent = parent;
    }

    public void moveTo(Directory newParent) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void moveTo(Directory newParent, String newName) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setName(String name) throws IOException {
        this.wrappedNode.setName(name);
    }

    public String getName() {
        return this.wrappedNode.getName();
    }

    public String getBaseName() {
        return this.wrappedNode.getBaseName();
    }

    public String getSuffix() {
        return this.wrappedNode.getSuffix();
    }

    public Directory getParent() throws FileNotFoundException {
        return this.parent;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public boolean isDirectory() {
        return this.wrappedNode.isDirectory();
    }

    public boolean isFile() {
        return this.wrappedNode.isFile();
    }

    public boolean isHidden() {
        return this.wrappedNode.isHidden();
    }

    public Date getLastModified() {
        return this.wrappedNode.getLastModified();
    }

    public void setLastModified(Date date) {
        this.wrappedNode.setLastModified(date);
    }

    public int compareTo(Node node) {
        return this.wrappedNode.compareTo(node);
    }

    public void delete() throws IOException {
        this.wrappedNode.delete();
    }

    public URI toUri() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Node node) {
        if (node instanceof LayeredNode) {
            return this.wrappedNode.equals(((LayeredNode)node).wrappedNode);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof LayeredNode) {
            return this.equals((LayeredNode)object);
        }
        return false;
    }

    public Path getPath() {
        Path path = new Path();
        Node node = this;
        while (!node.isDirectory() || !((Directory)node).isRoot()) {
            path.addLevel(0, node.getName());
            try {
                node = node.getParent();
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("Cannot retrieve parent directory.");
            }
        }
        return path;
    }

    public boolean canRead() {
        return this.wrappedNode.canRead();
    }

    public boolean canWrite() {
        return this.wrappedNode.canWrite();
    }

    public int compareTo(Object t) {
        return this.wrappedNode.compareTo(t);
    }
}

